package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link MutableImmutableCollection MutableImmutableCollection} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableMutableImmutableCollection is not thread-safe</em>
 * @see ImmutableMutableImmutableCollection
 */
@Generated(from = "MutableImmutableCollection", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "MutableImmutableCollection"})
@NotThreadSafe
public final class ModifiableMutableImmutableCollection
    extends MutableImmutableCollection {
  private final ArrayList<String> a = new ArrayList<String>();
  private final LinkedHashSet<String> b = new LinkedHashSet<String>();
  private final ArrayListMultimap<String, Integer> c = ArrayListMultimap.create();
  private final Map<Void, Void> d = new LinkedHashMap<Void, Void>();

  private ModifiableMutableImmutableCollection() {}

  /**
   * Construct a modifiable instance of {@code MutableImmutableCollection}.
   * @return A new modifiable instance
   */
  public static ModifiableMutableImmutableCollection create() {
    return new ModifiableMutableImmutableCollection();
  }

  /**
   * @return modifiable list {@code a}
   */
  @Override
  final ImmutableList<String> a() {
    return ImmutableList.copyOf(a);
  }

  /**
   * @return modifiable set {@code b}
   */
  @Override
  final ImmutableSet<String> b() {
    return ImmutableSet.copyOf(b);
  }

  /**
   * @return value of {@code c} attribute
   */
  @Override
  final ImmutableMultimap<String, Integer> c() {
    return ImmutableMultimap.copyOf(c);
  }

  /**
   * @return value of {@code d} attribute
   */
  @Override
  final ImmutableMap<Void, Void> d() {
    return ImmutableMap.copyOf(d);
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection clear() {
    a.clear();
    b.clear();
    c.clear();
    d.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link MutableImmutableCollection} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableMutableImmutableCollection from(MutableImmutableCollection instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableMutableImmutableCollection) {
      from((ModifiableMutableImmutableCollection) instance);
      return this;
    }
    addAllA(instance.a());
    addAllB(instance.b());
    putAllC(instance.c());
    putAllD(instance.d());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link MutableImmutableCollection} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableMutableImmutableCollection from(ModifiableMutableImmutableCollection instance) {
    Objects.requireNonNull(instance, "instance");
    addAllA(instance.a());
    addAllB(instance.b());
    putAllC(instance.c());
    putAllD(instance.d());
    return this;
  }

  /**
   * Adds one element to {@link MutableImmutableCollection#a() a} list.
   * @param element The a element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection addA(String element) {
    Objects.requireNonNull(element, "a element");
    this.a.add(element);
    return this;
  }

  /**
   * Adds elements to {@link MutableImmutableCollection#a() a} list.
   * @param elements An array of a elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableMutableImmutableCollection addA(String... elements) {
    for (String e : elements) {
      addA(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link MutableImmutableCollection#a() a} list.
   * @param elements An iterable of a elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection setA(Iterable<String> elements) {
    this.a.clear();
    addAllA(elements);
    return this;
  }

  /**
   * Adds elements to {@link MutableImmutableCollection#a() a} list.
   * @param elements An iterable of a elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection addAllA(Iterable<String> elements) {
    for (String e : elements) {
      addA(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link MutableImmutableCollection#b() b} set.
   * @param element The b element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection addB(String element) {
    Objects.requireNonNull(element, "b element");
    this.b.add(element);
    return this;
  }

  /**
   * Adds elements to {@link MutableImmutableCollection#b() b} set.
   * @param elements An array of b elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableMutableImmutableCollection addB(String... elements) {
    for (String e : elements) {
      addB(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link MutableImmutableCollection#b() b} set.
   * @param elements An iterable of b elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection setB(Iterable<String> elements) {
    this.b.clear();
    addAllB(elements);
    return this;
  }

  /**
   * Adds elements to {@link MutableImmutableCollection#b() b} set.
   * @param elements An iterable of b elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection addAllB(Iterable<String> elements) {
    for (String e : elements) {
      addB(e);
    }
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@link MutableImmutableCollection#c() c} true. Nulls are not permitted
   * @param key The key for c
   * @param values The values for c
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableMutableImmutableCollection putC(String key, int... values) {
    putAllC(key, Ints.asList(values));
    return this;
  }

  /**
   * Put all mappings from the specified key to values for {@link MutableImmutableCollection#c() c} true. Nulls are not permitted
   * @param key The key for c
   * @param values The values for c
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection putAllC(String key, Iterable<Integer> values) {
    for (Integer v : values) {
      this.c.put(
          Objects.requireNonNull(key, "c key"),
          Objects.requireNonNull(v, "c value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@link MutableImmutableCollection#c() c} map.
   * @param key The key in c map
   * @param value The associated value in the c map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection putC(String key, int value) {
    this.c.put(
        Objects.requireNonNull(key, "c key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link MutableImmutableCollection#c() c} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the c map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection setC(Multimap<String, ? extends Integer> entries) {
    this.c.clear();
    for (Map.Entry<String, ? extends Integer> e : entries.entries()) {
      String k = e.getKey();
      Integer v = e.getValue();
      this.c.put(
          Objects.requireNonNull(k, "c key"),
          Objects.requireNonNull(v, "c value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link MutableImmutableCollection#c() c} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to c map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection putAllC(Multimap<String, ? extends Integer> entries) {
    for (Map.Entry<String, ? extends Integer> e : entries.entries()) {
      String k = e.getKey();
      Integer v = e.getValue();
      this.c.put(
          Objects.requireNonNull(k, "c key"),
          Objects.requireNonNull(v, "c value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@link MutableImmutableCollection#d() d} map.
   * @param key The key in d map
   * @param value The associated value in the d map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection putD(Void key, Void value) {
    this.d.put(
        Objects.requireNonNull(key, "d key"),
        Objects.requireNonNull(value, "d value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link MutableImmutableCollection#d() d} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the d map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection setD(Map<? extends Void, ? extends Void> entries) {
    this.d.clear();
    for (Map.Entry<? extends Void, ? extends Void> e : entries.entrySet()) {
      Void k = e.getKey();
      Void v = e.getValue();
      this.d.put(
          Objects.requireNonNull(k, "d key"),
          Objects.requireNonNull(v, "d value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link MutableImmutableCollection#d() d} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to d map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableMutableImmutableCollection putAllD(Map<? extends Void, ? extends Void> entries) {
    for (Map.Entry<? extends Void, ? extends Void> e : entries.entrySet()) {
      Void k = e.getKey();
      Void v = e.getValue();
      this.d.put(
          Objects.requireNonNull(k, "d key"),
          Objects.requireNonNull(v, "d value"));
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableMutableImmutableCollection ImmutableMutableImmutableCollection}.
   * @return An immutable instance of MutableImmutableCollection
   */
  public final ImmutableMutableImmutableCollection toImmutable() {
    return ImmutableMutableImmutableCollection.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableMutableImmutableCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableMutableImmutableCollection)) return false;
    ModifiableMutableImmutableCollection other = (ModifiableMutableImmutableCollection) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableMutableImmutableCollection another) {
    return a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && d.equals(another.d);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}, {@code d}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + d.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code MutableImmutableCollection}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableMutableImmutableCollection")
        .add("a", a())
        .add("b", b())
        .add("c", c())
        .add("d", d())
        .toString();
  }
}
