package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link GenericMods GenericMods} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableGenericMods is not thread-safe</em>
 * @param <T> generic parameter T
 * @see ImmutableGenericMods
 */
@Generated(from = "GenericMods", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "GenericMods"})
@NotThreadSafe
public final class ModifiableGenericMods<T> implements GenericMods<T> {
  private static final long INIT_BIT_A = 0x1L;
  private static final long INIT_BIT_B = 0x2L;
  private static final long INIT_BIT_C = 0x4L;
  private long initBits = 0x7L;

  private int a;
  private T b;
  private int c;

  private ModifiableGenericMods() {}

  /**
   * Construct a modifiable instance of {@code GenericMods}.
   * @param <T> generic parameter T
   * @return A new modifiable instance
   */
  public static <T> ModifiableGenericMods<T> create() {
    return new ModifiableGenericMods<>();
  }

  /**
   * @return value of {@code a} attribute
   */
  @Override
  public final int a() {
    if (!aIsSet()) {
      checkRequiredAttributes();
    }
    return a;
  }

  /**
   * @return value of {@code b} attribute
   */
  @Override
  public final T b() {
    if (!bIsSet()) {
      checkRequiredAttributes();
    }
    return b;
  }

  /**
   * @return value of {@code c} attribute
   */
  @Override
  public final int c() {
    if (!cIsSet()) {
      checkRequiredAttributes();
    }
    return c;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericMods<T> clear() {
    initBits = 0x7L;
    a = 0;
    b = null;
    c = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.modifiable.Supertype} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericMods<T> from(Supertype instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.modifiable.GenericMods} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericMods<T> from(GenericMods<T> instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link GenericMods} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableGenericMods<T> from(ModifiableGenericMods<T> instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  @SuppressWarnings("unchecked")
  private void from(Object object) {
    if (object instanceof ModifiableGenericMods<?>) {
      ModifiableGenericMods<T> instance = (ModifiableGenericMods<T>) object;
      if (instance.aIsSet()) {
        setA(instance.a());
      }
      if (instance.bIsSet()) {
        setB(instance.b());
      }
      if (instance.cIsSet()) {
        setC(instance.c());
      }
      return;
    }
    long bits = 0;
    if (object instanceof Supertype) {
      Supertype instance = (Supertype) object;
      if ((bits & 0x1L) == 0) {
        setA(instance.a());
        bits |= 0x1L;
      }
      if ((bits & 0x2L) == 0) {
        setC(instance.c());
        bits |= 0x2L;
      }
    }
    if (object instanceof GenericMods<?>) {
      GenericMods<T> instance = (GenericMods<T>) object;
      if ((bits & 0x1L) == 0) {
        setA(instance.a());
        bits |= 0x1L;
      }
      setB(instance.b());
      if ((bits & 0x2L) == 0) {
        setC(instance.c());
        bits |= 0x2L;
      }
    }
  }

  /**
   * Assigns a value to the {@link GenericMods#a() a} attribute.
   * @param a The value for a
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericMods<T> setA(int a) {
    this.a = a;
    initBits &= ~INIT_BIT_A;
    return this;
  }

  /**
   * Assigns a value to the {@link GenericMods#b() b} attribute.
   * @param b The value for b
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericMods<T> setB(T b) {
    this.b = Objects.requireNonNull(b, "b");
    initBits &= ~INIT_BIT_B;
    return this;
  }

  /**
   * Assigns a value to the {@link GenericMods#c() c} attribute.
   * @param c The value for c
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableGenericMods<T> setC(int c) {
    this.c = c;
    initBits &= ~INIT_BIT_C;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link GenericMods#a() a} is set.
   * @return {@code true} if set
   */
  public final boolean aIsSet() {
    return (initBits & INIT_BIT_A) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link GenericMods#b() b} is set.
   * @return {@code true} if set
   */
  public final boolean bIsSet() {
    return (initBits & INIT_BIT_B) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link GenericMods#c() c} is set.
   * @return {@code true} if set
   */
  public final boolean cIsSet() {
    return (initBits & INIT_BIT_C) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableGenericMods<T> unsetA() {
    initBits |= INIT_BIT_A;
    a = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableGenericMods<T> unsetB() {
    initBits |= INIT_BIT_B;
    b = null;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableGenericMods<T> unsetC() {
    initBits |= INIT_BIT_C;
    c = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!aIsSet()) attributes.add("a");
    if (!bIsSet()) attributes.add("b");
    if (!cIsSet()) attributes.add("c");
    return "GenericMods is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableGenericMods ImmutableGenericMods}.
   * @return An immutable instance of GenericMods
   */
  public final ImmutableGenericMods<T> toImmutable() {
    checkRequiredAttributes();
    return ImmutableGenericMods.<T>copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableGenericMods<?>} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableGenericMods<?>)) return false;
    ModifiableGenericMods<?> other = (ModifiableGenericMods<?>) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableGenericMods<?> another) {
    return a == another.a
        && b.equals(another.b)
        && c == another.c;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c;
    return h;
  }

  /**
   * Generates a string representation of this {@code GenericMods}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableGenericMods")
        .add("a", aIsSet() ? a() : "?")
        .add("b", bIsSet() ? b() : "?")
        .add("c", cIsSet() ? c() : "?")
        .toString();
  }
}
