package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link FromTypesModifiables.FromManyTypes FromManyTypes} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableFromManyTypes is not thread-safe</em>
 * @see ImmutableFromManyTypes
 */
@Generated(from = "FromTypesModifiables.FromManyTypes", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "FromTypesModifiables.FromManyTypes"})
@NotThreadSafe
public final class ModifiableFromManyTypes
    extends FromTypesModifiables.FromManyTypes {
  private static final long INIT_BIT_A = 0x1L;
  private static final long INIT_BIT_B = 0x2L;
  private long initBits = 0x3L;

  private boolean a;
  private int b;

  private ModifiableFromManyTypes() {}

  /**
   * Construct a modifiable instance of {@code FromManyTypes}.
   * @return A new modifiable instance
   */
  public static ModifiableFromManyTypes create() {
    return new ModifiableFromManyTypes();
  }

  /**
   * @return value of {@code a} attribute
   */
  @Override
  public final boolean a() {
    if (!aIsSet()) {
      checkRequiredAttributes();
    }
    return a;
  }

  /**
   * @return value of {@code b} attribute
   */
  @Override
  public final int b() {
    if (!bIsSet()) {
      checkRequiredAttributes();
    }
    return b;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFromManyTypes clear() {
    initBits = 0x3L;
    a = false;
    b = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.modifiable.FromTypesModifiables.Iface} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFromManyTypes mergeFrom(FromTypesModifiables.Iface instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.immutables.fixture.modifiable.FromTypesModifiables.FromManyTypes} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFromManyTypes mergeFrom(FromTypesModifiables.FromManyTypes instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FromTypesModifiables.FromManyTypes} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFromManyTypes mergeFrom(ModifiableFromManyTypes instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof ModifiableFromManyTypes) {
      ModifiableFromManyTypes instance = (ModifiableFromManyTypes) object;
      if (instance.aIsSet()) {
        setA(instance.a());
      }
      if (instance.bIsSet()) {
        setB(instance.b());
      }
      return;
    }
    if (object instanceof FromTypesModifiables.Iface) {
      FromTypesModifiables.Iface instance = (FromTypesModifiables.Iface) object;
      setA(instance.a());
    }
    if (object instanceof FromTypesModifiables.FromManyTypes) {
      FromTypesModifiables.FromManyTypes instance = (FromTypesModifiables.FromManyTypes) object;
      setB(instance.b());
    }
  }

  /**
   * Assigns a value to the {@link FromTypesModifiables.FromManyTypes#a() a} attribute.
   * @param a The value for a
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFromManyTypes setA(boolean a) {
    this.a = a;
    initBits &= ~INIT_BIT_A;
    return this;
  }

  /**
   * Assigns a value to the {@link FromTypesModifiables.FromManyTypes#b() b} attribute.
   * @param b The value for b
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFromManyTypes setB(int b) {
    this.b = b;
    initBits &= ~INIT_BIT_B;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link FromTypesModifiables.FromManyTypes#a() a} is set.
   * @return {@code true} if set
   */
  public final boolean aIsSet() {
    return (initBits & INIT_BIT_A) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link FromTypesModifiables.FromManyTypes#b() b} is set.
   * @return {@code true} if set
   */
  public final boolean bIsSet() {
    return (initBits & INIT_BIT_B) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableFromManyTypes unsetA() {
    initBits |= INIT_BIT_A;
    a = false;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableFromManyTypes unsetB() {
    initBits |= INIT_BIT_B;
    b = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!aIsSet()) attributes.add("a");
    if (!bIsSet()) attributes.add("b");
    return "FromManyTypes is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableFromManyTypes ImmutableFromManyTypes}.
   * @return An immutable instance of FromManyTypes
   */
  public final ImmutableFromManyTypes toImmutable() {
    checkRequiredAttributes();
    return ImmutableFromManyTypes.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableFromManyTypes} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableFromManyTypes)) return false;
    ModifiableFromManyTypes other = (ModifiableFromManyTypes) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableFromManyTypes another) {
    return a == another.a
        && b == another.b;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Booleans.hashCode(a);
    h += (h << 5) + b;
    return h;
  }

  /**
   * Generates a string representation of this {@code FromManyTypes}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableFromManyTypes")
        .add("a", aIsSet() ? a() : "?")
        .add("b", bIsSet() ? b() : "?")
        .toString();
  }
}
