package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Companion Companion} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableCompanion is not thread-safe</em>
 * @see ImmutableCompanion
 */
@Generated(from = "Companion", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Companion"})
@NotThreadSafe
public final class ModifiableCompanion implements Companion {
  private static final long INIT_BIT_INTEGER = 0x1L;
  private static final long INIT_BIT_STRING = 0x2L;
  private static final long INIT_BIT_ARRAY_INTS = 0x4L;
  private static final long INIT_BIT_ARRAY_STRINGS = 0x8L;
  private long initBits = 0xfL;

  private int integer;
  private String string;
  private @Nullable Boolean bools;
  private final ArrayList<String> str = new ArrayList<String>();
  private final LinkedHashSet<Integer> ints = new LinkedHashSet<Integer>();
  private int[] arrayInts;
  private String[] arrayStrings;
  private final TreeSet<Integer> ords = new TreeSet<Integer>();
  private final EnumSet<RetentionPolicy> pols = EnumSet.noneOf(RetentionPolicy.class);
  private final TreeSet<Integer> navs = new TreeSet<Integer>(Collections.<Integer>reverseOrder());
  private final Map<Long, Integer> just = new LinkedHashMap<Long, Integer>();
  private final TreeMap<Integer, String> ordsmap = new TreeMap<Integer, String>();
  private final EnumMap<RetentionPolicy, Integer> polsmap = new EnumMap<RetentionPolicy, Integer>(RetentionPolicy.class);
  private final TreeMap<String, Integer> navsmap = new TreeMap<String, Integer>(Collections.<String>reverseOrder());

  private ModifiableCompanion() {}

  /**
   * Construct a modifiable instance of {@code Companion}.
   * @return A new modifiable instance
   */
  public static ModifiableCompanion create() {
    return new ModifiableCompanion();
  }

  /**
   * @return value of {@code integer} attribute
   */
  @Override
  public final int integer() {
    if (!integerIsSet()) {
      checkRequiredAttributes();
    }
    return integer;
  }

  /**
   * @return value of {@code string} attribute
   */
  @Override
  public final String string() {
    if (!stringIsSet()) {
      checkRequiredAttributes();
    }
    return string;
  }

  /**
   * @return value of {@code bools} attribute, may be {@code null}
   */
  @Override
  public final @Nullable Boolean bools() {
    return bools;
  }

  /**
   * @return modifiable list {@code str}
   */
  @Override
  public final List<String> str() {
    return str;
  }

  /**
   * @return modifiable set {@code ints}
   */
  @Override
  public final Set<Integer> ints() {
    return ints;
  }

  /**
   * @return assigned modifiable {@code arrayInts} array
   */
  @Override
  public final int[] arrayInts() {
    if (!arrayIntsIsSet()) {
      checkRequiredAttributes();
    }
    return arrayInts;
  }

  /**
   * @return assigned modifiable {@code arrayStrings} array
   */
  @Override
  public final String[] arrayStrings() {
    if (!arrayStringsIsSet()) {
      checkRequiredAttributes();
    }
    return arrayStrings;
  }

  /**
   * @return modifiable sortedSet {@code ords}
   */
  @Override
  public final SortedSet<Integer> ords() {
    return ords;
  }

  /**
   * @return modifiable set {@code pols}
   */
  @Override
  public final Set<RetentionPolicy> pols() {
    return pols;
  }

  /**
   * @return modifiable sortedSet {@code navs}
   */
  @Override
  public final NavigableSet<Integer> navs() {
    return navs;
  }

  /**
   * @return value of {@code just} attribute
   */
  @Override
  public final Map<Long, Integer> just() {
    return just;
  }

  /**
   * @return value of {@code ordsmap} attribute
   */
  @Override
  public final SortedMap<Integer, String> ordsmap() {
    return ordsmap;
  }

  /**
   * @return value of {@code polsmap} attribute
   */
  @Override
  public final Map<RetentionPolicy, Integer> polsmap() {
    return polsmap;
  }

  /**
   * @return value of {@code navsmap} attribute
   */
  @Override
  public final NavigableMap<String, Integer> navsmap() {
    return navsmap;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion clear() {
    initBits = 0xfL;
    integer = 0;
    string = null;
    bools = null;
    str.clear();
    ints.clear();
    arrayInts = null;
    arrayStrings = null;
    ords.clear();
    pols.clear();
    navs.clear();
    just.clear();
    ordsmap.clear();
    polsmap.clear();
    navsmap.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableCompanion from(Companion instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableCompanion) {
      from((ModifiableCompanion) instance);
      return this;
    }
    setInteger(instance.integer());
    setString(instance.string());
    @Nullable Boolean boolsValue = instance.bools();
    if (boolsValue != null) {
      setBools(boolsValue);
    }
    addAllStr(instance.str());
    addAllInts(instance.ints());
    setArrayInts(instance.arrayInts());
    setArrayStrings(instance.arrayStrings());
    addAllOrds(instance.ords());
    addAllPols(instance.pols());
    addAllNavs(instance.navs());
    putAllJust(instance.just());
    putAllOrdsmap(instance.ordsmap());
    putAllPolsmap(instance.polsmap());
    putAllNavsmap(instance.navsmap());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableCompanion from(ModifiableCompanion instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.integerIsSet()) {
      setInteger(instance.integer());
    }
    if (instance.stringIsSet()) {
      setString(instance.string());
    }
    @Nullable Boolean boolsValue = instance.bools();
    if (boolsValue != null) {
      setBools(boolsValue);
    }
    addAllStr(instance.str());
    addAllInts(instance.ints());
    if (instance.arrayIntsIsSet()) {
      setArrayInts(instance.arrayInts());
    }
    if (instance.arrayStringsIsSet()) {
      setArrayStrings(instance.arrayStrings());
    }
    addAllOrds(instance.ords());
    addAllPols(instance.pols());
    addAllNavs(instance.navs());
    putAllJust(instance.just());
    putAllOrdsmap(instance.ordsmap());
    putAllPolsmap(instance.polsmap());
    putAllNavsmap(instance.navsmap());
    return this;
  }

  /**
   * Assigns a value to the {@link Companion#integer() integer} attribute.
   * @param integer The value for integer
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setInteger(int integer) {
    this.integer = integer;
    initBits &= ~INIT_BIT_INTEGER;
    return this;
  }

  /**
   * Assigns a value to the {@link Companion#string() string} attribute.
   * @param string The value for string
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setString(String string) {
    this.string = Objects.requireNonNull(string, "string");
    initBits &= ~INIT_BIT_STRING;
    return this;
  }

  /**
   * Assigns a value to the {@link Companion#bools() bools} attribute.
   * @param bools The value for bools, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setBools(@Nullable Boolean bools) {
    this.bools = bools;
    return this;
  }

  /**
   * Adds one element to {@link Companion#str() str} list.
   * @param element The str element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addStr(String element) {
    Objects.requireNonNull(element, "str element");
    this.str.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion#str() str} list.
   * @param elements An array of str elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion addStr(String... elements) {
    for (String e : elements) {
      addStr(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion#str() str} list.
   * @param elements An iterable of str elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setStr(Iterable<String> elements) {
    this.str.clear();
    addAllStr(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion#str() str} list.
   * @param elements An iterable of str elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addAllStr(Iterable<String> elements) {
    for (String e : elements) {
      addStr(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Companion#ints() ints} set.
   * @param element The ints element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addInts(int element) {
    this.ints.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion#ints() ints} set.
   * @param elements An array of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion addInts(int... elements) {
    for (int e : elements) {
      addInts(Objects.requireNonNull(e, "ints element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion#ints() ints} set.
   * @param elements An iterable of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setInts(Iterable<Integer> elements) {
    this.ints.clear();
    addAllInts(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion#ints() ints} set.
   * @param elements An iterable of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addAllInts(Iterable<Integer> elements) {
    for (int e : elements) {
      addInts(e);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Companion#arrayInts() arrayInts} attribute.
   * @param elements The elements for arrayInts
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion setArrayInts(int... elements) {
    this.arrayInts = elements.clone();
    initBits &= ~INIT_BIT_ARRAY_INTS;
    return this;
  }

  /**
   * Assigns a value to the {@link Companion#arrayStrings() arrayStrings} attribute.
   * @param elements The elements for arrayStrings
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion setArrayStrings(String... elements) {
    this.arrayStrings = elements.clone();
    initBits &= ~INIT_BIT_ARRAY_STRINGS;
    return this;
  }

  /**
   * Adds one element to {@link Companion#ords() ords} sortedSet.
   * @param element The ords element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addOrds(int element) {
    this.ords.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion#ords() ords} sortedSet.
   * @param elements An array of ords elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion addOrds(int... elements) {
    for (int e : elements) {
      addOrds(Objects.requireNonNull(e, "ords element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion#ords() ords} sortedSet.
   * @param elements An iterable of ords elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setOrds(Iterable<Integer> elements) {
    this.ords.clear();
    addAllOrds(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion#ords() ords} sortedSet.
   * @param elements An iterable of ords elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addAllOrds(Iterable<Integer> elements) {
    for (int e : elements) {
      addOrds(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Companion#pols() pols} set.
   * @param element The pols element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addPols(RetentionPolicy element) {
    Objects.requireNonNull(element, "pols element");
    this.pols.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion#pols() pols} set.
   * @param elements An array of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion addPols(RetentionPolicy... elements) {
    for (RetentionPolicy e : elements) {
      addPols(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion#pols() pols} set.
   * @param elements An iterable of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setPols(Iterable<RetentionPolicy> elements) {
    this.pols.clear();
    addAllPols(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion#pols() pols} set.
   * @param elements An iterable of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addAllPols(Iterable<RetentionPolicy> elements) {
    for (RetentionPolicy e : elements) {
      addPols(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Companion#navs() navs} sortedSet.
   * @param element The navs element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addNavs(int element) {
    this.navs.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion#navs() navs} sortedSet.
   * @param elements An array of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion addNavs(int... elements) {
    for (int e : elements) {
      addNavs(Objects.requireNonNull(e, "navs element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion#navs() navs} sortedSet.
   * @param elements An iterable of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setNavs(Iterable<Integer> elements) {
    this.navs.clear();
    addAllNavs(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion#navs() navs} sortedSet.
   * @param elements An iterable of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion addAllNavs(Iterable<Integer> elements) {
    for (int e : elements) {
      addNavs(e);
    }
    return this;
  }

  /**
   * Put one entry to the {@link Companion#just() just} map.
   * @param key The key in just map
   * @param value The associated value in the just map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion putJust(long key, int value) {
    this.just.put(
        key,
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Companion#just() just} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the just map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setJust(Map<Long, ? extends Integer> entries) {
    this.just.clear();
    for (Map.Entry<Long, ? extends Integer> e : entries.entrySet()) {
      Long k = e.getKey();
      Integer v = e.getValue();
      this.just.put(
          Objects.requireNonNull(k, "just key"),
          Objects.requireNonNull(v, "just value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Companion#just() just} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to just map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion putAllJust(Map<Long, ? extends Integer> entries) {
    for (Map.Entry<Long, ? extends Integer> e : entries.entrySet()) {
      Long k = e.getKey();
      Integer v = e.getValue();
      this.just.put(
          Objects.requireNonNull(k, "just key"),
          Objects.requireNonNull(v, "just value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@link Companion#ordsmap() ordsmap} map.
   * @param key The key in ordsmap map
   * @param value The associated value in the ordsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion putOrdsmap(int key, String value) {
    this.ordsmap.put(
        key,
        Objects.requireNonNull(value, "ordsmap value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Companion#ordsmap() ordsmap} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the ordsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setOrdsmap(Map<Integer, ? extends String> entries) {
    this.ordsmap.clear();
    for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.ordsmap.put(
          Objects.requireNonNull(k, "ordsmap key"),
          Objects.requireNonNull(v, "ordsmap value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Companion#ordsmap() ordsmap} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to ordsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion putAllOrdsmap(Map<Integer, ? extends String> entries) {
    for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.ordsmap.put(
          Objects.requireNonNull(k, "ordsmap key"),
          Objects.requireNonNull(v, "ordsmap value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@link Companion#polsmap() polsmap} map.
   * @param key The key in polsmap map
   * @param value The associated value in the polsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion putPolsmap(RetentionPolicy key, int value) {
    this.polsmap.put(
        Objects.requireNonNull(key, "polsmap key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Companion#polsmap() polsmap} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the polsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
    this.polsmap.clear();
    for (Map.Entry<RetentionPolicy, ? extends Integer> e : entries.entrySet()) {
      RetentionPolicy k = e.getKey();
      Integer v = e.getValue();
      this.polsmap.put(
          Objects.requireNonNull(k, "polsmap key"),
          Objects.requireNonNull(v, "polsmap value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Companion#polsmap() polsmap} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to polsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion putAllPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
    for (Map.Entry<RetentionPolicy, ? extends Integer> e : entries.entrySet()) {
      RetentionPolicy k = e.getKey();
      Integer v = e.getValue();
      this.polsmap.put(
          Objects.requireNonNull(k, "polsmap key"),
          Objects.requireNonNull(v, "polsmap value"));
    }
    return this;
  }

  /**
   * Put one entry to the {@link Companion#navsmap() navsmap} map.
   * @param key The key in navsmap map
   * @param value The associated value in the navsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion putNavsmap(String key, int value) {
    this.navsmap.put(
        Objects.requireNonNull(key, "navsmap key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Companion#navsmap() navsmap} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the navsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion setNavsmap(Map<String, ? extends Integer> entries) {
    this.navsmap.clear();
    for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
      String k = e.getKey();
      Integer v = e.getValue();
      this.navsmap.put(
          Objects.requireNonNull(k, "navsmap key"),
          Objects.requireNonNull(v, "navsmap value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Companion#navsmap() navsmap} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to navsmap map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableCompanion putAllNavsmap(Map<String, ? extends Integer> entries) {
    for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
      String k = e.getKey();
      Integer v = e.getValue();
      this.navsmap.put(
          Objects.requireNonNull(k, "navsmap key"),
          Objects.requireNonNull(v, "navsmap value"));
    }
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link Companion#integer() integer} is set.
   * @return {@code true} if set
   */
  public final boolean integerIsSet() {
    return (initBits & INIT_BIT_INTEGER) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Companion#string() string} is set.
   * @return {@code true} if set
   */
  public final boolean stringIsSet() {
    return (initBits & INIT_BIT_STRING) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Companion#arrayInts() arrayInts} is set.
   * @return {@code true} if set
   */
  public final boolean arrayIntsIsSet() {
    return (initBits & INIT_BIT_ARRAY_INTS) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Companion#arrayStrings() arrayStrings} is set.
   * @return {@code true} if set
   */
  public final boolean arrayStringsIsSet() {
    return (initBits & INIT_BIT_ARRAY_STRINGS) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion unsetInteger() {
    initBits |= INIT_BIT_INTEGER;
    integer = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion unsetString() {
    initBits |= INIT_BIT_STRING;
    string = null;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion unsetArrayInts() {
    initBits |= INIT_BIT_ARRAY_INTS;
    arrayInts = null;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableCompanion unsetArrayStrings() {
    initBits |= INIT_BIT_ARRAY_STRINGS;
    arrayStrings = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!integerIsSet()) attributes.add("integer");
    if (!stringIsSet()) attributes.add("string");
    if (!arrayIntsIsSet()) attributes.add("arrayInts");
    if (!arrayStringsIsSet()) attributes.add("arrayStrings");
    return "Companion is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableCompanion ImmutableCompanion}.
   * @return An immutable instance of Companion
   */
  public final ImmutableCompanion toImmutable() {
    checkRequiredAttributes();
    return ImmutableCompanion.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableCompanion} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableCompanion)) return false;
    ModifiableCompanion other = (ModifiableCompanion) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableCompanion another) {
    return integer == another.integer
        && string.equals(another.string)
        && Objects.equals(bools, another.bools)
        && str.equals(another.str)
        && ints.equals(another.ints)
        && Arrays.equals(arrayInts, another.arrayInts)
        && Arrays.equals(arrayStrings, another.arrayStrings)
        && ords.equals(another.ords)
        && pols.equals(another.pols)
        && navs.equals(another.navs)
        && just.equals(another.just)
        && ordsmap.equals(another.ordsmap)
        && polsmap.equals(another.polsmap)
        && navsmap.equals(another.navsmap);
  }

  /**
   * Computes a hash code from attributes: {@code integer}, {@code string}, {@code bools}, {@code str}, {@code ints}, {@code arrayInts}, {@code arrayStrings}, {@code ords}, {@code pols}, {@code navs}, {@code just}, {@code ordsmap}, {@code polsmap}, {@code navsmap}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + integer;
    h += (h << 5) + string.hashCode();
    h += (h << 5) + Objects.hashCode(bools);
    h += (h << 5) + str.hashCode();
    h += (h << 5) + ints.hashCode();
    h += (h << 5) + Arrays.hashCode(arrayInts);
    h += (h << 5) + Arrays.hashCode(arrayStrings);
    h += (h << 5) + ords.hashCode();
    h += (h << 5) + pols.hashCode();
    h += (h << 5) + navs.hashCode();
    h += (h << 5) + just.hashCode();
    h += (h << 5) + ordsmap.hashCode();
    h += (h << 5) + polsmap.hashCode();
    h += (h << 5) + navsmap.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Companion}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableCompanion")
        .add("integer", integerIsSet() ? integer() : "?")
        .add("string", stringIsSet() ? string() : "?")
        .add("bools", bools())
        .add("str", str())
        .add("ints", ints())
        .add("arrayInts", arrayIntsIsSet() ? Arrays.toString(arrayInts()) : "?")
        .add("arrayStrings", arrayStringsIsSet() ? Arrays.toString(arrayStrings()) : "?")
        .add("ords", ords())
        .add("pols", pols())
        .add("navs", navs())
        .add("just", just())
        .add("ordsmap", ordsmap())
        .add("polsmap", polsmap())
        .add("navsmap", navsmap())
        .toString();
  }
}
