package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link ToImmutableCopyFalse.B B} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableB is not thread-safe</em>
 * @see ImmutableB
 */
@Generated(from = "ToImmutableCopyFalse.B", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "ToImmutableCopyFalse.B"})
@NotThreadSafe
public final class ModifiableB implements ToImmutableCopyFalse.B {

  private ModifiableB() {}

  /**
   * Construct a modifiable instance of {@code B}.
   * @return A new modifiable instance
   */
  public static ModifiableB create() {
    return new ModifiableB();
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableB clear() {
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ToImmutableCopyFalse.B} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableB from(ToImmutableCopyFalse.B instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableB) {
      from((ModifiableB) instance);
      return this;
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ToImmutableCopyFalse.B} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableB from(ModifiableB instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableB ImmutableB}.
   * @return An immutable instance of B
   */
  public final ImmutableB toImmutable() {
    return ImmutableB.builder()
        .build();
  }

  /**
   * This instance is equal to all instances of {@code ModifiableB} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableB)) return false;
    ModifiableB other = (ModifiableB) another;
    return equalTo(other);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ModifiableB another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 54852940;
  }

  /**
   * Generates a string representation of this {@code B}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableB{}";
  }
}
