package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link CreateFromDetect.Aaa Aaa} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableAaa is not thread-safe</em>
 */
@Generated(from = "CreateFromDetect.Aaa", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "CreateFromDetect.Aaa"})
@NotThreadSafe
public final class ModifiableAaa implements CreateFromDetect.Aaa {
  private static final long INIT_BIT_BBB = 0x1L;
  private long initBits = 0x1L;

  private ModifiableBbb bbb;

  private ModifiableAaa() {}

  /**
   * Construct a modifiable instance of {@code Aaa}.
   * @return A new modifiable instance
   */
  public static ModifiableAaa create() {
    return new ModifiableAaa();
  }

  /**
   * @return value of {@code bbb} attribute
   */
  @Override
  public final ModifiableBbb bbb() {
    if (!bbbIsSet()) {
      checkRequiredAttributes();
    }
    return bbb;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAaa clear() {
    initBits = 0x1L;
    bbb = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link CreateFromDetect.Aaa} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAaa from(CreateFromDetect.Aaa instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableAaa) {
      from((ModifiableAaa) instance);
      return this;
    }
    setBbb(instance.bbb());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link CreateFromDetect.Aaa} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAaa from(ModifiableAaa instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.bbbIsSet()) {
      setBbb(instance.bbb());
    }
    return this;
  }

  /**
   * Assigns a value to the {@code bbb} attribute.
   * @param bbb The value for bbb
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAaa setBbb(CreateFromDetect.Bbb bbb) {
    this.bbb = (bbb instanceof ModifiableBbb ? (ModifiableBbb) bbb : ModifiableBbb.create().from(bbb));
    initBits &= ~INIT_BIT_BBB;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@code bbb} is set.
   * @return {@code true} if set
   */
  public final boolean bbbIsSet() {
    return (initBits & INIT_BIT_BBB) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableAaa unsetBbb() {
    initBits |= INIT_BIT_BBB;
    bbb = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!bbbIsSet()) attributes.add("bbb");
    return "Aaa is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * This instance is equal to all instances of {@code ModifiableAaa} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableAaa)) return false;
    ModifiableAaa other = (ModifiableAaa) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableAaa another) {
    return bbb.equals(another.bbb);
  }

  /**
   * Computes a hash code from attributes: {@code bbb}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + bbb.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Aaa}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableAaa")
        .add("bbb", bbbIsSet() ? bbb() : "?")
        .toString();
  }
}
