package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link ToImmutableCopyFalse.A A} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableA is not thread-safe</em>
 * @see ImmutableA
 */
@Generated(from = "ToImmutableCopyFalse.A", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "ToImmutableCopyFalse.A"})
@NotThreadSafe
public final class ModifiableA implements ToImmutableCopyFalse.A {

  private ModifiableA() {}

  /**
   * Construct a modifiable instance of {@code A}.
   * @return A new modifiable instance
   */
  public static ModifiableA create() {
    return new ModifiableA();
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableA clear() {
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ToImmutableCopyFalse.A} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableA from(ToImmutableCopyFalse.A instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableA) {
      from((ModifiableA) instance);
      return this;
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link ToImmutableCopyFalse.A} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableA from(ModifiableA instance) {
    Objects.requireNonNull(instance, "instance");
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableA ImmutableA}.
   * @return An immutable instance of A
   */
  public final ImmutableA toImmutable() {
    return ImmutableA.builder()
        .from(this)
        .build();
  }

  /**
   * This instance is equal to all instances of {@code ModifiableA} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableA)) return false;
    ModifiableA other = (ModifiableA) another;
    return equalTo(other);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ModifiableA another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 54852939;
  }

  /**
   * Generates a string representation of this {@code A}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableA{}";
  }
}
