package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Companion.NullableAndDefault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableAndDefault.builder()}.
 */
@Generated(from = "Companion.NullableAndDefault", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNullableAndDefault
    implements Companion.NullableAndDefault {
  private final ImmutableList<String> lst;
  private final @Nullable ImmutableList<String> str;
  private final ImmutableSet<Integer> ints;
  private final int[] arrayInts;
  private final @Nullable ImmutableSortedSet<Integer> ords;
  private final ImmutableSet<RetentionPolicy> pols;
  private final ImmutableSortedSet<Integer> navs;

  private ImmutableNullableAndDefault(ImmutableNullableAndDefault.Builder builder) {
    this.lst = builder.lst == null ? ImmutableList.<String>of() : builder.lst.build();
    if (builder.strIsSet()) {
      initShim.str(builder.str == null ? null : builder.str.build());
    }
    if (builder.intsIsSet()) {
      initShim.ints(builder.ints == null ? ImmutableSet.<Integer>of() : builder.ints.build());
    }
    if (builder.arrayInts != null) {
      initShim.arrayInts(builder.arrayInts);
    }
    if (builder.ordsIsSet()) {
      initShim.ords(builder.ords == null ? null : builder.ords.build());
    }
    if (builder.polsIsSet()) {
      initShim.pols(builder.pols == null ? ImmutableSet.<RetentionPolicy>of() : Sets.immutableEnumSet(builder.pols.build()));
    }
    if (builder.navsIsSet()) {
      initShim.navs(builder.navs == null ? ImmutableSortedSet.<Integer>of() : builder.navs.build());
    }
    this.str = initShim.str();
    this.ints = initShim.ints();
    this.arrayInts = initShim.arrayInts();
    this.ords = initShim.ords();
    this.pols = initShim.pols();
    this.navs = initShim.navs();
    this.initShim = null;
  }

  private ImmutableNullableAndDefault(
      ImmutableList<String> lst,
      @Nullable ImmutableList<String> str,
      ImmutableSet<Integer> ints,
      int[] arrayInts,
      @Nullable ImmutableSortedSet<Integer> ords,
      ImmutableSet<RetentionPolicy> pols,
      ImmutableSortedSet<Integer> navs) {
    this.lst = lst;
    this.str = str;
    this.ints = ints;
    this.arrayInts = arrayInts;
    this.ords = ords;
    this.pols = pols;
    this.navs = navs;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Companion.NullableAndDefault", generator = "Immutables")
  private final class InitShim {
    private byte strBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<String> str;

    ImmutableList<String> str() {
      if (strBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (strBuildStage == STAGE_UNINITIALIZED) {
        strBuildStage = STAGE_INITIALIZING;
        this.str = strInitialize() == null ? null : ImmutableList.copyOf(strInitialize());
        strBuildStage = STAGE_INITIALIZED;
      }
      return this.str;
    }

    void str(ImmutableList<String> str) {
      this.str = str;
      strBuildStage = STAGE_INITIALIZED;
    }

    private byte intsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<Integer> ints;

    ImmutableSet<Integer> ints() {
      if (intsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (intsBuildStage == STAGE_UNINITIALIZED) {
        intsBuildStage = STAGE_INITIALIZING;
        this.ints = ImmutableSet.copyOf(intsInitialize());
        intsBuildStage = STAGE_INITIALIZED;
      }
      return this.ints;
    }

    void ints(ImmutableSet<Integer> ints) {
      this.ints = ints;
      intsBuildStage = STAGE_INITIALIZED;
    }

    private byte arrayIntsBuildStage = STAGE_UNINITIALIZED;
    private int[] arrayInts;

    int[] arrayInts() {
      if (arrayIntsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (arrayIntsBuildStage == STAGE_UNINITIALIZED) {
        arrayIntsBuildStage = STAGE_INITIALIZING;
        this.arrayInts = arrayIntsInitialize().clone();
        arrayIntsBuildStage = STAGE_INITIALIZED;
      }
      return this.arrayInts;
    }

    void arrayInts(int[] arrayInts) {
      this.arrayInts = arrayInts;
      arrayIntsBuildStage = STAGE_INITIALIZED;
    }

    private byte ordsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSortedSet<Integer> ords;

    ImmutableSortedSet<Integer> ords() {
      if (ordsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ordsBuildStage == STAGE_UNINITIALIZED) {
        ordsBuildStage = STAGE_INITIALIZING;
        this.ords = ordsInitialize() == null ? null : ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural(),
        ordsInitialize());
        ordsBuildStage = STAGE_INITIALIZED;
      }
      return this.ords;
    }

    void ords(ImmutableSortedSet<Integer> ords) {
      this.ords = ords;
      ordsBuildStage = STAGE_INITIALIZED;
    }

    private byte polsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<RetentionPolicy> pols;

    ImmutableSet<RetentionPolicy> pols() {
      if (polsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (polsBuildStage == STAGE_UNINITIALIZED) {
        polsBuildStage = STAGE_INITIALIZING;
        this.pols = Sets.immutableEnumSet(polsInitialize());
        polsBuildStage = STAGE_INITIALIZED;
      }
      return this.pols;
    }

    void pols(ImmutableSet<RetentionPolicy> pols) {
      this.pols = pols;
      polsBuildStage = STAGE_INITIALIZED;
    }

    private byte navsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSortedSet<Integer> navs;

    ImmutableSortedSet<Integer> navs() {
      if (navsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (navsBuildStage == STAGE_UNINITIALIZED) {
        navsBuildStage = STAGE_INITIALIZING;
        this.navs = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural().reverse(),
        navsInitialize());
        navsBuildStage = STAGE_INITIALIZED;
      }
      return this.navs;
    }

    void navs(ImmutableSortedSet<Integer> navs) {
      this.navs = navs;
      navsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (strBuildStage == STAGE_INITIALIZING) attributes.add("str");
      if (intsBuildStage == STAGE_INITIALIZING) attributes.add("ints");
      if (arrayIntsBuildStage == STAGE_INITIALIZING) attributes.add("arrayInts");
      if (ordsBuildStage == STAGE_INITIALIZING) attributes.add("ords");
      if (polsBuildStage == STAGE_INITIALIZING) attributes.add("pols");
      if (navsBuildStage == STAGE_INITIALIZING) attributes.add("navs");
      return "Cannot build NullableAndDefault, attribute initializers form cycle " + attributes;
    }
  }

  private @Nullable List<String> strInitialize() {
    return Companion.NullableAndDefault.super.str();
  }

  private Set<Integer> intsInitialize() {
    return Companion.NullableAndDefault.super.ints();
  }

  private int[] arrayIntsInitialize() {
    return Companion.NullableAndDefault.super.arrayInts();
  }

  private @Nullable SortedSet<Integer> ordsInitialize() {
    return Companion.NullableAndDefault.super.ords();
  }

  private Set<RetentionPolicy> polsInitialize() {
    return Companion.NullableAndDefault.super.pols();
  }

  private NavigableSet<Integer> navsInitialize() {
    return Companion.NullableAndDefault.super.navs();
  }

  /**
   * @return The value of the {@code lst} attribute
   */
  @Override
  public ImmutableList<String> lst() {
    return lst;
  }

  /**
   * @return The value of the {@code str} attribute
   */
  @Override
  public @Nullable ImmutableList<String> str() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.str()
        : this.str;
  }

  /**
   * @return The value of the {@code ints} attribute
   */
  @Override
  public ImmutableSet<Integer> ints() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ints()
        : this.ints;
  }

  /**
   * @return A cloned {@code arrayInts} array
   */
  @Override
  public int[] arrayInts() {
    InitShim shim = this.initShim;
    return shim != null
      ? shim.arrayInts().clone()
      : this.arrayInts.clone();
  }

  /**
   * @return The value of the {@code ords} attribute
   */
  @Override
  public @Nullable ImmutableSortedSet<Integer> ords() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ords()
        : this.ords;
  }

  /**
   * @return The value of the {@code pols} attribute
   */
  @Override
  public ImmutableSet<RetentionPolicy> pols() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.pols()
        : this.pols;
  }

  /**
   * @return The value of the {@code navs} attribute
   */
  @Override
  public ImmutableSortedSet<Integer> navs() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.navs()
        : this.navs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#lst() lst}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withLst(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNullableAndDefault(newValue, this.str, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#lst() lst}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of lst elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withLst(Iterable<String> elements) {
    if (this.lst == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNullableAndDefault(newValue, this.str, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#str() str}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withStr(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableNullableAndDefault(this.lst, null, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
    }
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableNullableAndDefault(this.lst, newValue, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#str() str}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of str elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withStr(@Nullable Iterable<String> elements) {
    if (this.str == elements) return this;
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableNullableAndDefault(this.lst, newValue, this.ints, this.arrayInts, this.ords, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#ints() ints}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withInts(int... elements) {
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(Ints.asList(elements));
    return new ImmutableNullableAndDefault(this.lst, this.str, newValue, this.arrayInts, this.ords, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#ints() ints}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ints elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withInts(Iterable<Integer> elements) {
    if (this.ints == elements) return this;
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableNullableAndDefault(this.lst, this.str, newValue, this.arrayInts, this.ords, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#arrayInts() arrayInts}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for arrayInts
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withArrayInts(int... elements) {
    int[] newValue = elements.clone();
    return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, newValue, this.ords, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#ords() ords}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withOrds(@Nullable int... elements) {
    if (elements == null) {
      return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, null, this.pols, this.navs);
    }
    @Nullable ImmutableSortedSet<Integer> newValue = Ints.asList(elements) == null ? null : ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural(),
        Ints.asList(elements));
    return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, newValue, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#ords() ords}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ords elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withOrds(@Nullable Iterable<Integer> elements) {
    if (this.ords == elements) return this;
    @Nullable ImmutableSortedSet<Integer> newValue = elements == null ? null : ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural(),
        elements);
    return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, newValue, this.pols, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#pols() pols}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withPols(RetentionPolicy... elements) {
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(Arrays.asList(elements));
    return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, this.ords, newValue, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#pols() pols}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pols elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withPols(Iterable<RetentionPolicy> elements) {
    if (this.pols == elements) return this;
    ImmutableSet<RetentionPolicy> newValue = Sets.immutableEnumSet(elements);
    return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, this.ords, newValue, this.navs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#navs() navs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withNavs(int... elements) {
    ImmutableSortedSet<Integer> newValue = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural().reverse(),
        Ints.asList(elements));
    return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, this.ords, this.pols, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Companion.NullableAndDefault#navs() navs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of navs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAndDefault withNavs(Iterable<Integer> elements) {
    if (this.navs == elements) return this;
    ImmutableSortedSet<Integer> newValue = ImmutableSortedSet.copyOf(
        Ordering.<Integer>natural().reverse(),
        elements);
    return new ImmutableNullableAndDefault(this.lst, this.str, this.ints, this.arrayInts, this.ords, this.pols, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableAndDefault} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableAndDefault
        && equalTo(0, (ImmutableNullableAndDefault) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableAndDefault another) {
    return lst.equals(another.lst)
        && Objects.equals(str, another.str)
        && ints.equals(another.ints)
        && Arrays.equals(arrayInts, another.arrayInts)
        && Objects.equals(ords, another.ords)
        && pols.equals(another.pols)
        && navs.equals(another.navs);
  }

  /**
   * Computes a hash code from attributes: {@code lst}, {@code str}, {@code ints}, {@code arrayInts}, {@code ords}, {@code pols}, {@code navs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + lst.hashCode();
    h += (h << 5) + Objects.hashCode(str);
    h += (h << 5) + ints.hashCode();
    h += (h << 5) + Arrays.hashCode(arrayInts);
    h += (h << 5) + Objects.hashCode(ords);
    h += (h << 5) + pols.hashCode();
    h += (h << 5) + navs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NullableAndDefault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullableAndDefault")
        .omitNullValues()
        .add("lst", lst)
        .add("str", str)
        .add("ints", ints)
        .add("arrayInts", Arrays.toString(arrayInts))
        .add("ords", ords)
        .add("pols", pols)
        .add("navs", navs)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Companion.NullableAndDefault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableAndDefault instance
   */
  public static ImmutableNullableAndDefault copyOf(Companion.NullableAndDefault instance) {
    if (instance instanceof ImmutableNullableAndDefault) {
      return (ImmutableNullableAndDefault) instance;
    }
    return ImmutableNullableAndDefault.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableAndDefault ImmutableNullableAndDefault}.
   * <pre>
   * ImmutableNullableAndDefault.builder()
   *    .addLst|addAllLst(String) // {@link Companion.NullableAndDefault#lst() lst} elements
   *    .str(List&amp;lt;String&amp;gt; | null) // nullable {@link Companion.NullableAndDefault#str() str}
   *    .addInts|addAllInts(int) // {@link Companion.NullableAndDefault#ints() ints} elements
   *    .arrayInts(int) // optional {@link Companion.NullableAndDefault#arrayInts() arrayInts}
   *    .ords(SortedSet&amp;lt;Integer&amp;gt; | null) // nullable {@link Companion.NullableAndDefault#ords() ords}
   *    .addPols|addAllPols(annotation.RetentionPolicy) // {@link Companion.NullableAndDefault#pols() pols} elements
   *    .addNavs|addAllNavs(int) // {@link Companion.NullableAndDefault#navs() navs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableNullableAndDefault builder
   */
  public static ImmutableNullableAndDefault.Builder builder() {
    return new ImmutableNullableAndDefault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableAndDefault ImmutableNullableAndDefault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Companion.NullableAndDefault", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_STR = 0x1L;
    private static final long OPT_BIT_INTS = 0x2L;
    private static final long OPT_BIT_ORDS = 0x4L;
    private static final long OPT_BIT_POLS = 0x8L;
    private static final long OPT_BIT_NAVS = 0x10L;
    private long optBits;

    private ImmutableList.Builder<String> lst = null;
    private ImmutableList.Builder<String> str = null;
    private ImmutableSet.Builder<Integer> ints = null;
    private @Nullable int[] arrayInts;
    private ImmutableSortedSet.Builder<Integer> ords = null;
    private ImmutableSet.Builder<RetentionPolicy> pols = null;
    private ImmutableSortedSet.Builder<Integer> navs = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableNullableAndDefault} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableNullableAndDefault instance) {
      Objects.requireNonNull(instance, "instance");
      addAllLst(instance.lst());
      @Nullable List<String> strValue = instance.str();
      if (strValue != null) {
        addAllStr(strValue);
      }
      addAllInts(instance.ints());
      arrayInts(instance.arrayInts());
      @Nullable SortedSet<Integer> ordsValue = instance.ords();
      if (ordsValue != null) {
        addAllOrds(ordsValue);
      }
      addAllPols(instance.pols());
      addAllNavs(instance.navs());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableAndDefault} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Companion.NullableAndDefault instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableNullableAndDefault) {
        return from((ModifiableNullableAndDefault) instance);
      }
      addAllLst(instance.lst());
      @Nullable List<String> strValue = instance.str();
      if (strValue != null) {
        addAllStr(strValue);
      }
      addAllInts(instance.ints());
      arrayInts(instance.arrayInts());
      @Nullable SortedSet<Integer> ordsValue = instance.ords();
      if (ordsValue != null) {
        addAllOrds(ordsValue);
      }
      addAllPols(instance.pols());
      addAllNavs(instance.navs());
      return this;
    }

    /**
     * Adds one element to {@link Companion.NullableAndDefault#lst() lst} list.
     * @param element A lst element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLst(String element) {
      if (this.lst == null) {
        this.lst = ImmutableList.builder();
      }
      this.lst.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#lst() lst} list.
     * @param elements An array of lst elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLst(String... elements) {
      if (this.lst == null) {
        this.lst = ImmutableList.builder();
      }
      this.lst.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.NullableAndDefault#lst() lst} list.
     * @param elements An iterable of lst elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lst(Iterable<String> elements) {
      this.lst = ImmutableList.builder();
      return addAllLst(elements);
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#lst() lst} list.
     * @param elements An iterable of lst elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLst(Iterable<String> elements) {
      Objects.requireNonNull(elements, "lst element");
      if (this.lst == null) {
        this.lst = ImmutableList.builder();
      }
      this.lst.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Companion.NullableAndDefault#str() str} list.
     * @param element A str element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStr(String element) {
      if (this.str == null) {
        this.str = ImmutableList.builder();
      }
      this.str.add(element);
      optBits |= OPT_BIT_STR;
      return this;
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#str() str} list.
     * @param elements An array of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStr(String... elements) {
      if (this.str == null) {
        this.str = ImmutableList.builder();
      }
      this.str.add(elements);
      optBits |= OPT_BIT_STR;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.NullableAndDefault#str() str} list.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder str(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.str = null;
        optBits |= OPT_BIT_STR;
        return this;
      }
      this.str = ImmutableList.builder();
      return addAllStr(elements);
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#str() str} list.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStr(Iterable<String> elements) {
      Objects.requireNonNull(elements, "str element");
      if (this.str == null) {
        this.str = ImmutableList.builder();
      }
      this.str.addAll(elements);
      optBits |= OPT_BIT_STR;
      return this;
    }

    /**
     * Adds one element to {@link Companion.NullableAndDefault#ints() ints} set.
     * @param element A ints element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int element) {
      if (this.ints == null) {
        this.ints = ImmutableSet.builder();
      }
      this.ints.add(element);
      optBits |= OPT_BIT_INTS;
      return this;
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#ints() ints} set.
     * @param elements An array of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int... elements) {
      if (this.ints == null) {
        this.ints = ImmutableSet.builder();
      }
      this.ints.addAll(Ints.asList(elements));
      optBits |= OPT_BIT_INTS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.NullableAndDefault#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ints(Iterable<Integer> elements) {
      this.ints = ImmutableSet.builder();
      return addAllInts(elements);
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInts(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "ints element");
      if (this.ints == null) {
        this.ints = ImmutableSet.builder();
      }
      this.ints.addAll(elements);
      optBits |= OPT_BIT_INTS;
      return this;
    }

    /**
     * Initializes the value for the {@link Companion.NullableAndDefault#arrayInts() arrayInts} attribute.
     * <p><em>If not set, this attribute will have a default value as defined by {@link Companion.NullableAndDefault#arrayInts() arrayInts}.</em>
     * @param arrayInts The elements for arrayInts
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder arrayInts(int... arrayInts) {
      this.arrayInts = arrayInts.clone();
      return this;
    }

    /**
     * Adds one element to {@link Companion.NullableAndDefault#ords() ords} sortedSet.
     * @param element A ords element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOrds(int element) {
      if (this.ords == null) {
        this.ords = ImmutableSortedSet.naturalOrder();
      }
      this.ords.add(element);
      optBits |= OPT_BIT_ORDS;
      return this;
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#ords() ords} sortedSet.
     * @param elements An array of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOrds(int... elements) {
      if (this.ords == null) {
        this.ords = ImmutableSortedSet.naturalOrder();
      }
      this.ords.addAll(Ints.asList(elements));
      optBits |= OPT_BIT_ORDS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.NullableAndDefault#ords() ords} sortedSet.
     * @param elements An iterable of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ords(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.ords = null;
        optBits |= OPT_BIT_ORDS;
        return this;
      }
      this.ords = ImmutableSortedSet.naturalOrder();
      return addAllOrds(elements);
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#ords() ords} sortedSet.
     * @param elements An iterable of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOrds(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "ords element");
      if (this.ords == null) {
        this.ords = ImmutableSortedSet.naturalOrder();
      }
      this.ords.addAll(elements);
      optBits |= OPT_BIT_ORDS;
      return this;
    }

    /**
     * Adds one element to {@link Companion.NullableAndDefault#pols() pols} set.
     * @param element A pols element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPols(RetentionPolicy element) {
      if (this.pols == null) {
        this.pols = ImmutableSet.builder();
      }
      this.pols.add(element);
      optBits |= OPT_BIT_POLS;
      return this;
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#pols() pols} set.
     * @param elements An array of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPols(RetentionPolicy... elements) {
      if (this.pols == null) {
        this.pols = ImmutableSet.builder();
      }
      this.pols.addAll(Arrays.asList(elements));
      optBits |= OPT_BIT_POLS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.NullableAndDefault#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pols(Iterable<RetentionPolicy> elements) {
      this.pols = ImmutableSet.builder();
      return addAllPols(elements);
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
      Objects.requireNonNull(elements, "pols element");
      if (this.pols == null) {
        this.pols = ImmutableSet.builder();
      }
      this.pols.addAll(elements);
      optBits |= OPT_BIT_POLS;
      return this;
    }

    /**
     * Adds one element to {@link Companion.NullableAndDefault#navs() navs} sortedSet.
     * @param element A navs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNavs(int element) {
      if (this.navs == null) {
        this.navs = ImmutableSortedSet.reverseOrder();
      }
      this.navs.add(element);
      optBits |= OPT_BIT_NAVS;
      return this;
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#navs() navs} sortedSet.
     * @param elements An array of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNavs(int... elements) {
      if (this.navs == null) {
        this.navs = ImmutableSortedSet.reverseOrder();
      }
      this.navs.addAll(Ints.asList(elements));
      optBits |= OPT_BIT_NAVS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Companion.NullableAndDefault#navs() navs} sortedSet.
     * @param elements An iterable of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder navs(Iterable<Integer> elements) {
      this.navs = ImmutableSortedSet.reverseOrder();
      return addAllNavs(elements);
    }

    /**
     * Adds elements to {@link Companion.NullableAndDefault#navs() navs} sortedSet.
     * @param elements An iterable of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNavs(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "navs element");
      if (this.navs == null) {
        this.navs = ImmutableSortedSet.reverseOrder();
      }
      this.navs.addAll(elements);
      optBits |= OPT_BIT_NAVS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableAndDefault ImmutableNullableAndDefault}.
     * @return An immutable instance of NullableAndDefault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableAndDefault build() {
      return new ImmutableNullableAndDefault(this);
    }

    private boolean strIsSet() {
      return (optBits & OPT_BIT_STR) != 0;
    }

    private boolean intsIsSet() {
      return (optBits & OPT_BIT_INTS) != 0;
    }

    private boolean ordsIsSet() {
      return (optBits & OPT_BIT_ORDS) != 0;
    }

    private boolean polsIsSet() {
      return (optBits & OPT_BIT_POLS) != 0;
    }

    private boolean navsIsSet() {
      return (optBits & OPT_BIT_NAVS) != 0;
    }
  }
}
