package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FromTypesModifiables.FromManyTypes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFromManyTypes.builder()}.
 */
@Generated(from = "FromTypesModifiables.FromManyTypes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFromManyTypes
    extends FromTypesModifiables.FromManyTypes {
  private final boolean a;
  private final int b;

  private ImmutableFromManyTypes(boolean a, int b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public boolean a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public int b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FromTypesModifiables.FromManyTypes#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFromManyTypes withA(boolean value) {
    if (this.a == value) return this;
    return new ImmutableFromManyTypes(value, this.b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FromTypesModifiables.FromManyTypes#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFromManyTypes withB(int value) {
    if (this.b == value) return this;
    return new ImmutableFromManyTypes(this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFromManyTypes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFromManyTypes
        && equalTo(0, (ImmutableFromManyTypes) another);
  }

  private boolean equalTo(int synthetic, ImmutableFromManyTypes another) {
    return a == another.a
        && b == another.b;
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(a);
    h += (h << 5) + b;
    return h;
  }

  /**
   * Prints the immutable value {@code FromManyTypes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FromManyTypes")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FromTypesModifiables.FromManyTypes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FromManyTypes instance
   */
  public static ImmutableFromManyTypes copyOf(FromTypesModifiables.FromManyTypes instance) {
    if (instance instanceof ImmutableFromManyTypes) {
      return (ImmutableFromManyTypes) instance;
    }
    return ImmutableFromManyTypes.builder()
        .mergeFrom(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFromManyTypes ImmutableFromManyTypes}.
   * <pre>
   * ImmutableFromManyTypes.builder()
   *    .a(boolean) // required {@link FromTypesModifiables.FromManyTypes#a() a}
   *    .b(int) // required {@link FromTypesModifiables.FromManyTypes#b() b}
   *    .build();
   * </pre>
   * @return A new ImmutableFromManyTypes builder
   */
  public static ImmutableFromManyTypes.Builder builder() {
    return new ImmutableFromManyTypes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFromManyTypes ImmutableFromManyTypes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FromTypesModifiables.FromManyTypes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private boolean a;
    private int b;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableFromManyTypes} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeFrom(ModifiableFromManyTypes instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.aIsSet()) {
        a(instance.a());
      }
      if (instance.bIsSet()) {
        b(instance.b());
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.modifiable.FromTypesModifiables.Iface} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeFrom(FromTypesModifiables.Iface instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.modifiable.FromTypesModifiables.FromManyTypes} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeFrom(FromTypesModifiables.FromManyTypes instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ModifiableFromManyTypes) {
        mergeFrom((ModifiableFromManyTypes) object);
        return;
      }
      if (object instanceof FromTypesModifiables.Iface) {
        FromTypesModifiables.Iface instance = (FromTypesModifiables.Iface) object;
        a(instance.a());
      }
      if (object instanceof FromTypesModifiables.FromManyTypes) {
        FromTypesModifiables.FromManyTypes instance = (FromTypesModifiables.FromManyTypes) object;
        b(instance.b());
      }
    }

    /**
     * Initializes the value for the {@link FromTypesModifiables.FromManyTypes#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(boolean a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link FromTypesModifiables.FromManyTypes#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(int b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFromManyTypes ImmutableFromManyTypes}.
     * @return An immutable instance of FromManyTypes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFromManyTypes build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFromManyTypes(a, b);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build FromManyTypes, some of required attributes are not set " + attributes;
    }
  }
}
