package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link JdkMaps JdkMaps}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code JdkMapsBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "JdkMaps", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class JdkMapsBuilder {
  private Map<Long, Integer> just = new LinkedHashMap<Long, Integer>();
  private Map<Integer, String> ords = new LinkedHashMap<Integer, String>();
  private EnumMap<RetentionPolicy, Integer> pols = new EnumMap<RetentionPolicy, Integer>(RetentionPolicy.class);
  private Map<String, Integer> navs = new LinkedHashMap<String, Integer>();

  /**
   * Creates a builder for {@link JdkMaps JdkMaps} instances.
   * <pre>
   * new JdkMapsBuilder()
   *    .putJust|putAllJust(long =&gt; int) // {@link JdkMaps#just() just} mappings
   *    .putOrds|putAllOrds(int =&gt; String) // {@link JdkMaps#ords() ords} mappings
   *    .putPols|putAllPols(annotation.RetentionPolicy =&gt; int) // {@link JdkMaps#pols() pols} mappings
   *    .putNavs|putAllNavs(String =&gt; int) // {@link JdkMaps#navs() navs} mappings
   *    .build();
   * </pre>
   */
  public JdkMapsBuilder() {
  }

  /**
   * Fill a builder with attribute values from the provided {@code JdkMaps} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder from(JdkMaps instance) {
    Objects.requireNonNull(instance, "instance");
    putAllJust(instance.just());
    putAllOrds(instance.ords());
    putAllPols(instance.pols());
    putAllNavs(instance.navs());
    return this;
  }

  /**
   * Put one entry to the {@link JdkMaps#just() just} map.
   * @param key The key in the just map
   * @param value The associated value in the just map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putJust(long key, int value) {
    this.just.put(
        Objects.requireNonNull(key, "just key"),
        value);
    return this;
  }

  /**
   * Put one entry to the {@link JdkMaps#just() just} map. Nulls are not permitted
   * @param entry The key and value entry
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putJust(Map.Entry<Long, ? extends Integer> entry) {
    Long k = entry.getKey();
    Integer v = entry.getValue();
    this.just.put(
        Objects.requireNonNull(k, "just key"),
        v == null ? Objects.requireNonNull(v, "just value for key: " + k) : v);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link JdkMaps#just() just} map. Nulls are not permitted
   * @param entries The entries that will be added to the just map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder just(Map<Long, ? extends Integer> entries) {
    this.just.clear();
    return putAllJust(entries);
  }

  /**
   * Put all mappings from the specified map as entries to {@link JdkMaps#just() just} map. Nulls are not permitted
   * @param entries The entries that will be added to the just map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putAllJust(Map<Long, ? extends Integer> entries) {
    for (Map.Entry<Long, ? extends Integer> e : entries.entrySet()) {
      Long k = e.getKey();
      Integer v = e.getValue();
      this.just.put(
          Objects.requireNonNull(k, "just key"),
          v == null ? Objects.requireNonNull(v, "just value for key: " + k) : v);
    }
    return this;
  }

  /**
   * Put one entry to the {@link JdkMaps#ords() ords} map.
   * @param key The key in the ords map
   * @param value The associated value in the ords map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putOrds(int key, String value) {
    this.ords.put(
        Objects.requireNonNull(key, "ords key"),
        value == null ? Objects.requireNonNull(value, "ords value for key: " + key) : value);
    return this;
  }

  /**
   * Put one entry to the {@link JdkMaps#ords() ords} map. Nulls are not permitted
   * @param entry The key and value entry
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putOrds(Map.Entry<Integer, ? extends String> entry) {
    Integer k = entry.getKey();
    String v = entry.getValue();
    this.ords.put(
        Objects.requireNonNull(k, "ords key"),
        v == null ? Objects.requireNonNull(v, "ords value for key: " + k) : v);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link JdkMaps#ords() ords} map. Nulls are not permitted
   * @param entries The entries that will be added to the ords map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder ords(Map<Integer, ? extends String> entries) {
    this.ords.clear();
    return putAllOrds(entries);
  }

  /**
   * Put all mappings from the specified map as entries to {@link JdkMaps#ords() ords} map. Nulls are not permitted
   * @param entries The entries that will be added to the ords map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putAllOrds(Map<Integer, ? extends String> entries) {
    for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
      Integer k = e.getKey();
      String v = e.getValue();
      this.ords.put(
          Objects.requireNonNull(k, "ords key"),
          v == null ? Objects.requireNonNull(v, "ords value for key: " + k) : v);
    }
    return this;
  }

  /**
   * Put one entry to the {@link JdkMaps#pols() pols} map.
   * @param key The key in the pols map
   * @param value The associated value in the pols map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putPols(RetentionPolicy key, int value) {
    this.pols.put(
        Objects.requireNonNull(key, "pols key"),
        value);
    return this;
  }

  /**
   * Put one entry to the {@link JdkMaps#pols() pols} map. Nulls are not permitted
   * @param entry The key and value entry
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putPols(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
    RetentionPolicy k = entry.getKey();
    Integer v = entry.getValue();
    this.pols.put(
        Objects.requireNonNull(k, "pols key"),
        v == null ? Objects.requireNonNull(v, "pols value for key: " + k) : v);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link JdkMaps#pols() pols} map. Nulls are not permitted
   * @param entries The entries that will be added to the pols map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder pols(Map<RetentionPolicy, ? extends Integer> entries) {
    this.pols.clear();
    return putAllPols(entries);
  }

  /**
   * Put all mappings from the specified map as entries to {@link JdkMaps#pols() pols} map. Nulls are not permitted
   * @param entries The entries that will be added to the pols map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putAllPols(Map<RetentionPolicy, ? extends Integer> entries) {
    for (Map.Entry<RetentionPolicy, ? extends Integer> e : entries.entrySet()) {
      RetentionPolicy k = e.getKey();
      Integer v = e.getValue();
      this.pols.put(
          Objects.requireNonNull(k, "pols key"),
          v == null ? Objects.requireNonNull(v, "pols value for key: " + k) : v);
    }
    return this;
  }

  /**
   * Put one entry to the {@link JdkMaps#navs() navs} map.
   * @param key The key in the navs map
   * @param value The associated value in the navs map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putNavs(String key, int value) {
    this.navs.put(
        Objects.requireNonNull(key, "navs key"),
        value);
    return this;
  }

  /**
   * Put one entry to the {@link JdkMaps#navs() navs} map. Nulls are not permitted
   * @param entry The key and value entry
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putNavs(Map.Entry<String, ? extends Integer> entry) {
    String k = entry.getKey();
    Integer v = entry.getValue();
    this.navs.put(
        Objects.requireNonNull(k, "navs key"),
        v == null ? Objects.requireNonNull(v, "navs value for key: " + k) : v);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link JdkMaps#navs() navs} map. Nulls are not permitted
   * @param entries The entries that will be added to the navs map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder navs(Map<String, ? extends Integer> entries) {
    this.navs.clear();
    return putAllNavs(entries);
  }

  /**
   * Put all mappings from the specified map as entries to {@link JdkMaps#navs() navs} map. Nulls are not permitted
   * @param entries The entries that will be added to the navs map
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final JdkMapsBuilder putAllNavs(Map<String, ? extends Integer> entries) {
    for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
      String k = e.getKey();
      Integer v = e.getValue();
      this.navs.put(
          Objects.requireNonNull(k, "navs key"),
          v == null ? Objects.requireNonNull(v, "navs value for key: " + k) : v);
    }
    return this;
  }

  /**
   * Builds a new {@link JdkMaps JdkMaps}.
   * @return An immutable instance of JdkMaps
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public JdkMaps build() {
    return JdkMapsBuilder.ImmutableJdkMaps.validate(new JdkMapsBuilder.ImmutableJdkMaps(this));
  }

  /**
   * Immutable implementation of {@link JdkMaps}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new JdkMapsBuilder()}.
   * Use the static factory method to get the default singleton instance:
   * {@code JdkMapsBuilder.ImmutableJdkMaps.of()}.
   */
  @Generated(from = "JdkMaps", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  private static final class ImmutableJdkMaps implements JdkMaps {
    private final Map<Long, Integer> just;
    private final SortedMap<Integer, String> ords;
    private final Map<RetentionPolicy, Integer> pols;
    private final NavigableMap<String, Integer> navs;

    private ImmutableJdkMaps() {
      this.just = Collections.emptyMap();
      this.ords = createUnmodifiableSortedMap(false, false, false, Collections.<Integer, String>emptyMap());
      this.pols = Collections.emptyMap();
      this.navs = createUnmodifiableSortedMap(true, false, false, Collections.<String, Integer>emptyMap());
    }

    private ImmutableJdkMaps(JdkMapsBuilder builder) {
      this.just = createUnmodifiableMap(false, false, builder.just);
      this.ords = createUnmodifiableSortedMap(false, false, false, builder.ords);
      this.pols = createUnmodifiableEnumMap(false, false, builder.pols);
      this.navs = createUnmodifiableSortedMap(true, false, false, builder.navs);
    }

    /**
     * @return The value of the {@code just} attribute
     */
    @Override
    public Map<Long, Integer> just() {
      return just;
    }

    /**
     * @return The value of the {@code ords} attribute
     */
    @Override
    public SortedMap<Integer, String> ords() {
      return ords;
    }

    /**
     * @return The value of the {@code pols} attribute
     */
    @Override
    public Map<RetentionPolicy, Integer> pols() {
      return pols;
    }

    /**
     * @return The value of the {@code navs} attribute
     */
    @Override
    public NavigableMap<String, Integer> navs() {
      return navs;
    }

    /**
     * This instance is equal to all instances of {@code ImmutableJdkMaps} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof JdkMapsBuilder.ImmutableJdkMaps
          && equalTo(0, (JdkMapsBuilder.ImmutableJdkMaps) another);
    }

    private boolean equalTo(int synthetic, JdkMapsBuilder.ImmutableJdkMaps another) {
      return just.equals(another.just)
          && ords.equals(another.ords)
          && pols.equals(another.pols)
          && navs.equals(another.navs);
    }

    /**
     * Computes a hash code from attributes: {@code just}, {@code ords}, {@code pols}, {@code navs}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + just.hashCode();
      h += (h << 5) + ords.hashCode();
      h += (h << 5) + pols.hashCode();
      h += (h << 5) + navs.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code JdkMaps} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "JdkMaps{"
          + "just=" + just
          + ", ords=" + ords
          + ", pols=" + pols
          + ", navs=" + navs
          + "}";
    }

    private static final JdkMapsBuilder.ImmutableJdkMaps INSTANCE = validate(new JdkMapsBuilder.ImmutableJdkMaps());

    /**
     * Returns the default immutable singleton value of {@code JdkMaps}
     * @return An immutable instance of JdkMaps
     */
    public static JdkMaps of() {
      return INSTANCE;
    }

    private static JdkMapsBuilder.ImmutableJdkMaps validate(JdkMapsBuilder.ImmutableJdkMaps instance) {
      return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }

  private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
    if (map.isEmpty()) return Collections.emptyMap();
    EnumMap<K, V> enumMap = new EnumMap<>(map);
    if (checkNulls || skipNulls) {
      Iterator<? extends V> it = map.values().iterator();
      while(it.hasNext()) {
        V v = it.next();
        if (checkNulls) {
          Objects.requireNonNull(v, "value");
        } else if (skipNulls) {
          if (v == null) it.remove();
        }
      }
    }
    return Collections.unmodifiableMap(enumMap);
  }

  private static <K extends Comparable<K>, V> NavigableMap<K, V> createUnmodifiableSortedMap(boolean reverse, boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    TreeMap<K, V> sortedMap = reverse
        ? new TreeMap<K, V>(Collections.<K>reverseOrder())
        : new TreeMap<K, V>();

    if (checkNulls || skipNulls) {
      for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
        K k = e.getKey();
        V v = e.getValue();
        if (skipNulls) {
          if (k == null || v == null) continue;
        } else if (checkNulls) {
          Objects.requireNonNull(k, "key");
          if (v == null) Objects.requireNonNull(v, "value for key: " + k);
        }
        sortedMap.put(k, v);
      }
    } else {
      sortedMap.putAll(map);
    }
    return Collections.unmodifiableNavigableMap(sortedMap);
  }
}
