package org.immutables.fixture.jdkonly;

import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.atlassian.fugue.Option;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UsingAllOptionals}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUsingAllOptionals.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableUsingAllOptionals.of()}.
 */
@Generated(from = "UsingAllOptionals", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUsingAllOptionals implements UsingAllOptionals {
  private final Optional<Integer> v1;
  private final @Nullable Integer v2;
  private final @Nullable Integer i1;
  private final @Nullable Long l1;
  private final @Nullable Double d1;
  private final Option<String> fo3;
  private final javaslang.control.Option<String> jso;

  private ImmutableUsingAllOptionals(
      Optional<Integer> v1,
      java.util.Optional<Integer> v2,
      OptionalInt i1,
      OptionalLong l1,
      OptionalDouble d1,
      Option<String> fo3,
      javaslang.control.Option<String> jso) {
    this.v1 = v1;
    this.v2 = v2.orElse(null);
    this.i1 = i1.isPresent() ? i1.getAsInt() : null;
    this.l1 = l1.isPresent() ? l1.getAsLong() : null;
    this.d1 = d1.isPresent() ? d1.getAsDouble() : null;
    this.fo3 = fo3;
    this.jso = jso;
  }

  private ImmutableUsingAllOptionals(
      ImmutableUsingAllOptionals original,
      Optional<Integer> v1,
      @Nullable Integer v2,
      @Nullable Integer i1,
      @Nullable Long l1,
      @Nullable Double d1,
      Option<String> fo3,
      javaslang.control.Option<String> jso) {
    this.v1 = v1;
    this.v2 = v2;
    this.i1 = i1;
    this.l1 = l1;
    this.d1 = d1;
    this.fo3 = fo3;
    this.jso = jso;
  }

  /**
   * @return The value of the {@code v1} attribute
   */
  @Override
  public Optional<Integer> v1() {
    return v1;
  }

  /**
   * @return The value of the {@code v2} attribute
   */
  @Override
  public java.util.Optional<Integer> v2() {
    return java.util.Optional.ofNullable(v2);
  }

  /**
   * @return The value of the {@code i1} attribute
   */
  @Override
  public OptionalInt i1() {
    return i1 != null
        ? OptionalInt.of(i1)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code l1} attribute
   */
  @Override
  public OptionalLong l1() {
    return l1 != null
        ? OptionalLong.of(l1)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code d1} attribute
   */
  @Override
  public OptionalDouble d1() {
    return d1 != null
        ? OptionalDouble.of(d1)
        : OptionalDouble.empty();
  }

  /**
   * @return The value of the {@code fo3} attribute
   */
  @Override
  public Option<String> fo3() {
    return fo3;
  }

  /**
   * @return The value of the {@code jso} attribute
   */
  @Override
  public javaslang.control.Option<String> jso() {
    return jso;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsingAllOptionals#v1() v1} attribute.
   * @param value The value for v1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withV1(int value) {
    Optional<Integer> newValue = Optional.of(value);
    if (this.v1.equals(newValue)) return this;
    return new ImmutableUsingAllOptionals(this, newValue, this.v2, this.i1, this.l1, this.d1, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsingAllOptionals#v1() v1} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withV1(Optional<Integer> optional) {
    Optional<Integer> value = optional;
    if (this.v1.equals(value)) return this;
    return new ImmutableUsingAllOptionals(this, value, this.v2, this.i1, this.l1, this.d1, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsingAllOptionals#v2() v2} attribute.
   * @param value The value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withV2(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.v2, newValue)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, newValue, this.i1, this.l1, this.d1, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsingAllOptionals#v2() v2} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withV2(java.util.Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.v2, value)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, value, this.i1, this.l1, this.d1, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsingAllOptionals#i1() i1} attribute.
   * @param value The value for i1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withI1(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.i1, newValue)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, newValue, this.l1, this.d1, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsingAllOptionals#i1() i1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for i1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withI1(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.i1, value)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, value, this.l1, this.d1, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsingAllOptionals#l1() l1} attribute.
   * @param value The value for l1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withL1(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.l1, newValue)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, newValue, this.d1, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsingAllOptionals#l1() l1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for l1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withL1(OptionalLong optional) {
    @Nullable Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.l1, value)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, value, this.d1, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsingAllOptionals#d1() d1} attribute.
   * @param value The value for d1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withD1(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.d1, newValue)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, newValue, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsingAllOptionals#d1() d1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for d1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withD1(OptionalDouble optional) {
    @Nullable Double value = optional.isPresent() ? optional.getAsDouble() : null;
    if (Objects.equals(this.d1, value)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, value, this.fo3, this.jso);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsingAllOptionals#fo3() fo3} attribute.
   * @param value The value for fo3
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withFo3(String value) {
    Option<String> newValue = Option.some(value);
    if (this.fo3.equals(newValue)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, this.d1, newValue, this.jso);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsingAllOptionals#fo3() fo3} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for fo3
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withFo3(Option<String> optional) {
    Option<String> value = optional;
    if (this.fo3.equals(value)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, this.d1, value, this.jso);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsingAllOptionals#jso() jso} attribute.
   * @param value The value for jso
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withJso(String value) {
    javaslang.control.Option<String> newValue = javaslang.control.Option.some(value);
    if (this.jso.equals(newValue)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, this.d1, this.fo3, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsingAllOptionals#jso() jso} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for jso
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUsingAllOptionals withJso(javaslang.control.Option<String> optional) {
    javaslang.control.Option<String> value = optional;
    if (this.jso.equals(value)) return this;
    return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, this.d1, this.fo3, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUsingAllOptionals} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUsingAllOptionals
        && equalTo(0, (ImmutableUsingAllOptionals) another);
  }

  private boolean equalTo(int synthetic, ImmutableUsingAllOptionals another) {
    return v1.equals(another.v1)
        && Objects.equals(v2, another.v2)
        && Objects.equals(i1, another.i1)
        && Objects.equals(l1, another.l1)
        && Objects.equals(d1, another.d1)
        && fo3.equals(another.fo3)
        && jso.equals(another.jso);
  }

  /**
   * Computes a hash code from attributes: {@code v1}, {@code v2}, {@code i1}, {@code l1}, {@code d1}, {@code fo3}, {@code jso}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + v1.hashCode();
    h += (h << 5) + Objects.hashCode(v2);
    h += (h << 5) + Objects.hashCode(i1);
    h += (h << 5) + Objects.hashCode(l1);
    h += (h << 5) + Objects.hashCode(d1);
    h += (h << 5) + fo3.hashCode();
    h += (h << 5) + jso.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UsingAllOptionals} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsingAllOptionals{");
    if (v1.isPresent()) {
      builder.append("v1=").append(v1.get());
    }
    if (v2 != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("v2=").append(v2);
    }
    if (i1 != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("i1=").append(i1);
    }
    if (l1 != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("l1=").append(l1);
    }
    if (d1 != null) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("d1=").append(d1);
    }
    if (fo3.isDefined()) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("fo3=").append(fo3.get());
    }
    if (jso.isDefined()) {
      if (builder.length() > 18) builder.append(", ");
      builder.append("jso=").append(jso.get());
    }
    return builder.append("}").toString();
  }

  /**
   * Construct a new immutable {@code UsingAllOptionals} instance.
   * @param v1 The value for the {@code v1} attribute
   * @param v2 The value for the {@code v2} attribute
   * @param i1 The value for the {@code i1} attribute
   * @param l1 The value for the {@code l1} attribute
   * @param d1 The value for the {@code d1} attribute
   * @param fo3 The value for the {@code fo3} attribute
   * @param jso The value for the {@code jso} attribute
   * @return An immutable UsingAllOptionals instance
   */
  public static ImmutableUsingAllOptionals of(Optional<Integer> v1, java.util.Optional<Integer> v2, OptionalInt i1, OptionalLong l1, OptionalDouble d1, Option<String> fo3, javaslang.control.Option<String> jso) {
    return new ImmutableUsingAllOptionals(v1, v2, i1, l1, d1, fo3, jso);
  }

  /**
   * Creates an immutable copy of a {@link UsingAllOptionals} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsingAllOptionals instance
   */
  public static ImmutableUsingAllOptionals copyOf(UsingAllOptionals instance) {
    if (instance instanceof ImmutableUsingAllOptionals) {
      return (ImmutableUsingAllOptionals) instance;
    }
    return ImmutableUsingAllOptionals.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUsingAllOptionals ImmutableUsingAllOptionals}.
   * <pre>
   * ImmutableUsingAllOptionals.builder()
   *    .v1(Integer) // optional {@link UsingAllOptionals#v1() v1}
   *    .v2(Integer) // optional {@link UsingAllOptionals#v2() v2}
   *    .i1(int) // optional {@link UsingAllOptionals#i1() i1}
   *    .l1(long) // optional {@link UsingAllOptionals#l1() l1}
   *    .d1(double) // optional {@link UsingAllOptionals#d1() d1}
   *    .fo3(String) // optional {@link UsingAllOptionals#fo3() fo3}
   *    .jso(String) // optional {@link UsingAllOptionals#jso() jso}
   *    .build();
   * </pre>
   * @return A new ImmutableUsingAllOptionals builder
   */
  public static ImmutableUsingAllOptionals.Builder builder() {
    return new ImmutableUsingAllOptionals.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUsingAllOptionals ImmutableUsingAllOptionals}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UsingAllOptionals", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Optional<Integer> v1 = Optional.absent();
    private @Nullable Integer v2;
    private @Nullable Integer i1;
    private @Nullable Long l1;
    private @Nullable Double d1;
    private Option<String> fo3 = Option.none();
    private javaslang.control.Option<String> jso = javaslang.control.Option.none();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UsingAllOptionals} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UsingAllOptionals instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<Integer> v1Optional = instance.v1();
      if (v1Optional.isPresent()) {
        v1(v1Optional);
      }
      java.util.Optional<Integer> v2Optional = instance.v2();
      if (v2Optional.isPresent()) {
        v2(v2Optional);
      }
      OptionalInt i1Optional = instance.i1();
      if (i1Optional.isPresent()) {
        i1(i1Optional);
      }
      OptionalLong l1Optional = instance.l1();
      if (l1Optional.isPresent()) {
        l1(l1Optional);
      }
      OptionalDouble d1Optional = instance.d1();
      if (d1Optional.isPresent()) {
        d1(d1Optional);
      }
      Option<String> fo3Optional = instance.fo3();
      if (fo3Optional.isDefined()) {
        fo3(fo3Optional);
      }
      javaslang.control.Option<String> jsoOptional = instance.jso();
      if (jsoOptional.isDefined()) {
        jso(jsoOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#v1() v1} to v1.
     * @param v1 The value for v1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v1(int v1) {
      this.v1 = Optional.of(v1);
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#v1() v1} to v1.
     * @param v1 The value for v1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v1(Optional<Integer> v1) {
      this.v1 = v1;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#v2() v2} to v2.
     * @param v2 The value for v2
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v2(int v2) {
      this.v2 = v2;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#v2() v2} to v2.
     * @param v2 The value for v2
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v2(java.util.Optional<Integer> v2) {
      this.v2 = v2.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#i1() i1} to i1.
     * @param i1 The value for i1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i1(int i1) {
      this.i1 = i1;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#i1() i1} to i1.
     * @param i1 The value for i1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i1(OptionalInt i1) {
      this.i1 = i1.isPresent() ? i1.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#l1() l1} to l1.
     * @param l1 The value for l1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l1(long l1) {
      this.l1 = l1;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#l1() l1} to l1.
     * @param l1 The value for l1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l1(OptionalLong l1) {
      this.l1 = l1.isPresent() ? l1.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#d1() d1} to d1.
     * @param d1 The value for d1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d1(double d1) {
      this.d1 = d1;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#d1() d1} to d1.
     * @param d1 The value for d1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d1(OptionalDouble d1) {
      this.d1 = d1.isPresent() ? d1.getAsDouble() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#fo3() fo3} to fo3.
     * @param fo3 The value for fo3
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fo3(String fo3) {
      this.fo3 = Option.some(fo3);
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#fo3() fo3} to fo3.
     * @param fo3 The value for fo3
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fo3(Option<String> fo3) {
      this.fo3 = fo3;
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#jso() jso} to jso.
     * @param jso The value for jso
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder jso(String jso) {
      this.jso = javaslang.control.Option.some(jso);
      return this;
    }

    /**
     * Initializes the optional value {@link UsingAllOptionals#jso() jso} to jso.
     * @param jso The value for jso
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder jso(javaslang.control.Option<String> jso) {
      this.jso = jso;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUsingAllOptionals ImmutableUsingAllOptionals}.
     * @return An immutable instance of UsingAllOptionals
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUsingAllOptionals build() {
      return new ImmutableUsingAllOptionals(null, v1, v2, i1, l1, d1, fo3, jso);
    }
  }
}
