package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JdkUtil}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJdkUtil.builder()}.
 */
@Generated(from = "JdkUtil", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJdkUtil implements JdkUtil {
  private final boolean a;
  private final double d;
  private final float f;
  private final long l;
  private final char c;
  private final Object o;

  private ImmutableJdkUtil(boolean a, double d, float f, long l, char c, Object o) {
    this.a = a;
    this.d = d;
    this.f = f;
    this.l = l;
    this.c = c;
    this.o = o;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public boolean a() {
    return a;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public double d() {
    return d;
  }

  /**
   * @return The value of the {@code f} attribute
   */
  @Override
  public float f() {
    return f;
  }

  /**
   * @return The value of the {@code l} attribute
   */
  @Override
  public long l() {
    return l;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public char c() {
    return c;
  }

  /**
   * @return The value of the {@code o} attribute
   */
  @Override
  public Object o() {
    return o;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkUtil#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkUtil withA(boolean value) {
    if (this.a == value) return this;
    return new ImmutableJdkUtil(value, this.d, this.f, this.l, this.c, this.o);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkUtil#d() d} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkUtil withD(double value) {
    if (Double.doubleToLongBits(this.d) == Double.doubleToLongBits(value)) return this;
    return new ImmutableJdkUtil(this.a, value, this.f, this.l, this.c, this.o);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkUtil#f() f} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for f
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkUtil withF(float value) {
    if (Float.floatToIntBits(this.f) == Float.floatToIntBits(value)) return this;
    return new ImmutableJdkUtil(this.a, this.d, value, this.l, this.c, this.o);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkUtil#l() l} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for l
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkUtil withL(long value) {
    if (this.l == value) return this;
    return new ImmutableJdkUtil(this.a, this.d, this.f, value, this.c, this.o);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkUtil#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkUtil withC(char value) {
    if (this.c == value) return this;
    return new ImmutableJdkUtil(this.a, this.d, this.f, this.l, value, this.o);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkUtil#o() o} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for o
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkUtil withO(Object value) {
    if (this.o == value) return this;
    Object newValue = Objects.requireNonNull(value, "o");
    return new ImmutableJdkUtil(this.a, this.d, this.f, this.l, this.c, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkUtil} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJdkUtil
        && equalTo(0, (ImmutableJdkUtil) another);
  }

  private boolean equalTo(int synthetic, ImmutableJdkUtil another) {
    return a == another.a
        && Double.doubleToLongBits(d) == Double.doubleToLongBits(another.d)
        && Float.floatToIntBits(f) == Float.floatToIntBits(another.f)
        && l == another.l
        && c == another.c
        && o.equals(another.o);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code d}, {@code f}, {@code l}, {@code c}, {@code o}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Boolean.hashCode(a);
    h += (h << 5) + Double.hashCode(d);
    h += (h << 5) + Float.hashCode(f);
    h += (h << 5) + Long.hashCode(l);
    h += (h << 5) + Character.hashCode(c);
    h += (h << 5) + o.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JdkUtil} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JdkUtil{"
        + "a=" + a
        + ", d=" + d
        + ", f=" + f
        + ", l=" + l
        + ", c=" + c
        + ", o=" + o
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JdkUtil} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkUtil instance
   */
  public static ImmutableJdkUtil copyOf(JdkUtil instance) {
    if (instance instanceof ImmutableJdkUtil) {
      return (ImmutableJdkUtil) instance;
    }
    return ImmutableJdkUtil.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJdkUtil ImmutableJdkUtil}.
   * <pre>
   * ImmutableJdkUtil.builder()
   *    .a(boolean) // required {@link JdkUtil#a() a}
   *    .d(double) // required {@link JdkUtil#d() d}
   *    .f(float) // required {@link JdkUtil#f() f}
   *    .l(long) // required {@link JdkUtil#l() l}
   *    .c(char) // required {@link JdkUtil#c() c}
   *    .o(Object) // required {@link JdkUtil#o() o}
   *    .build();
   * </pre>
   * @return A new ImmutableJdkUtil builder
   */
  public static ImmutableJdkUtil.Builder builder() {
    return new ImmutableJdkUtil.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJdkUtil ImmutableJdkUtil}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JdkUtil", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_D = 0x2L;
    private static final long INIT_BIT_F = 0x4L;
    private static final long INIT_BIT_L = 0x8L;
    private static final long INIT_BIT_C = 0x10L;
    private static final long INIT_BIT_O = 0x20L;
    private long initBits = 0x3fL;

    private boolean a;
    private double d;
    private float f;
    private long l;
    private char c;
    private @Nullable Object o;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JdkUtil} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JdkUtil instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      d(instance.d());
      f(instance.f());
      l(instance.l());
      c(instance.c());
      o(instance.o());
      return this;
    }

    /**
     * Initializes the value for the {@link JdkUtil#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(boolean a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link JdkUtil#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d(double d) {
      this.d = d;
      initBits &= ~INIT_BIT_D;
      return this;
    }

    /**
     * Initializes the value for the {@link JdkUtil#f() f} attribute.
     * @param f The value for f 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder f(float f) {
      this.f = f;
      initBits &= ~INIT_BIT_F;
      return this;
    }

    /**
     * Initializes the value for the {@link JdkUtil#l() l} attribute.
     * @param l The value for l 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l(long l) {
      this.l = l;
      initBits &= ~INIT_BIT_L;
      return this;
    }

    /**
     * Initializes the value for the {@link JdkUtil#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(char c) {
      this.c = c;
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Initializes the value for the {@link JdkUtil#o() o} attribute.
     * @param o The value for o 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder o(Object o) {
      this.o = Objects.requireNonNull(o, "o");
      initBits &= ~INIT_BIT_O;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJdkUtil ImmutableJdkUtil}.
     * @return An immutable instance of JdkUtil
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJdkUtil build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJdkUtil(a, d, f, l, c, o);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      if ((initBits & INIT_BIT_F) != 0) attributes.add("f");
      if ((initBits & INIT_BIT_L) != 0) attributes.add("l");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      if ((initBits & INIT_BIT_O) != 0) attributes.add("o");
      return "Cannot build JdkUtil, some of required attributes are not set " + attributes;
    }
  }
}
