package org.immutables.fixture.jdkonly;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JdkOptionalsWithNullable}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableJdkOptionalsWithNullable.of()}.
 */
@Generated(from = "JdkOptionalsWithNullable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableJdkOptionalsWithNullable
    implements JdkOptionalsWithNullable {
  private final @Nullable String v2;
  private final @Nullable Integer i1;
  private final @Nullable Long l1;
  private final @Nullable Double d1;

  private ImmutableJdkOptionalsWithNullable(
      Optional<String> v2,
      OptionalInt i1,
      OptionalLong l1,
      OptionalDouble d1) {
    this.v2 = v2.orElse(null);
    this.i1 = i1.isPresent() ? i1.getAsInt() : null;
    this.l1 = l1.isPresent() ? l1.getAsLong() : null;
    this.d1 = d1.isPresent() ? d1.getAsDouble() : null;
  }

  private ImmutableJdkOptionalsWithNullable(@Nullable String v2, int i1, long l1, double d1) {
    this.v2 = v2;
    this.i1 = i1;
    this.l1 = l1;
    this.d1 = d1;
  }

  private ImmutableJdkOptionalsWithNullable(
      ImmutableJdkOptionalsWithNullable original,
      @Nullable String v2,
      @Nullable Integer i1,
      @Nullable Long l1,
      @Nullable Double d1) {
    this.v2 = v2;
    this.i1 = i1;
    this.l1 = l1;
    this.d1 = d1;
  }

  /**
   * @return The value of the {@code v2} attribute
   */
  @Override
  public Optional<String> v2() {
    return Optional.ofNullable(v2);
  }

  /**
   * @return The value of the {@code i1} attribute
   */
  @Override
  public OptionalInt i1() {
    return i1 != null
        ? OptionalInt.of(i1)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code l1} attribute
   */
  @Override
  public OptionalLong l1() {
    return l1 != null
        ? OptionalLong.of(l1)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code d1} attribute
   */
  @Override
  public OptionalDouble d1() {
    return d1 != null
        ? OptionalDouble.of(d1)
        : OptionalDouble.empty();
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionalsWithNullable#v2() v2} attribute.
   * @param value The value for v2, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsWithNullable withV2(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.v2, newValue)) return this;
    return new ImmutableJdkOptionalsWithNullable(this, newValue, this.i1, this.l1, this.d1);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionalsWithNullable#v2() v2} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsWithNullable withV2(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.v2, value)) return this;
    return new ImmutableJdkOptionalsWithNullable(this, value, this.i1, this.l1, this.d1);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionalsWithNullable#i1() i1} attribute.
   * @param value The value for i1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsWithNullable withI1(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.i1, newValue)) return this;
    return new ImmutableJdkOptionalsWithNullable(this, this.v2, newValue, this.l1, this.d1);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionalsWithNullable#i1() i1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for i1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsWithNullable withI1(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.i1, value)) return this;
    return new ImmutableJdkOptionalsWithNullable(this, this.v2, value, this.l1, this.d1);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionalsWithNullable#l1() l1} attribute.
   * @param value The value for l1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsWithNullable withL1(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.l1, newValue)) return this;
    return new ImmutableJdkOptionalsWithNullable(this, this.v2, this.i1, newValue, this.d1);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionalsWithNullable#l1() l1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for l1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsWithNullable withL1(OptionalLong optional) {
    @Nullable Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.l1, value)) return this;
    return new ImmutableJdkOptionalsWithNullable(this, this.v2, this.i1, value, this.d1);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionalsWithNullable#d1() d1} attribute.
   * @param value The value for d1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsWithNullable withD1(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.d1, newValue)) return this;
    return new ImmutableJdkOptionalsWithNullable(this, this.v2, this.i1, this.l1, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionalsWithNullable#d1() d1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for d1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsWithNullable withD1(OptionalDouble optional) {
    @Nullable Double value = optional.isPresent() ? optional.getAsDouble() : null;
    if (Objects.equals(this.d1, value)) return this;
    return new ImmutableJdkOptionalsWithNullable(this, this.v2, this.i1, this.l1, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkOptionalsWithNullable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJdkOptionalsWithNullable
        && equalTo(0, (ImmutableJdkOptionalsWithNullable) another);
  }

  private boolean equalTo(int synthetic, ImmutableJdkOptionalsWithNullable another) {
    return Objects.equals(v2, another.v2)
        && Objects.equals(i1, another.i1)
        && Objects.equals(l1, another.l1)
        && Objects.equals(d1, another.d1);
  }

  /**
   * Computes a hash code from attributes: {@code v2}, {@code i1}, {@code l1}, {@code d1}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(v2);
    h += (h << 5) + Objects.hashCode(i1);
    h += (h << 5) + Objects.hashCode(l1);
    h += (h << 5) + Objects.hashCode(d1);
    return h;
  }

  /**
   * Prints the immutable value {@code JdkOptionalsWithNullable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JdkOptionalsWithNullable")
        .omitNullValues()
        .add("v2", v2)
        .add("i1", i1)
        .add("l1", l1)
        .add("d1", d1)
        .toString();
  }

  /**
   * Construct a new immutable {@code JdkOptionalsWithNullable} instance.
   * @param v2 The value for the {@code v2} attribute
   * @param i1 The value for the {@code i1} attribute
   * @param l1 The value for the {@code l1} attribute
   * @param d1 The value for the {@code d1} attribute
   * @return An immutable JdkOptionalsWithNullable instance
   */
  public static ImmutableJdkOptionalsWithNullable of(Optional<String> v2, OptionalInt i1, OptionalLong l1, OptionalDouble d1) {
    return new ImmutableJdkOptionalsWithNullable(v2, i1, l1, d1);
  }

  /**
   * Construct a new immutable {@code JdkOptionalsWithNullable} instance.
   * @param v2 The value for the {@code v2} attribute
   * @param i1 The value for the {@code i1} attribute
   * @param l1 The value for the {@code l1} attribute
   * @param d1 The value for the {@code d1} attribute
   * @return An immutable JdkOptionalsWithNullable instance
   */
  public static ImmutableJdkOptionalsWithNullable of(@Nullable String v2, int i1, long l1, double d1) {
    return new ImmutableJdkOptionalsWithNullable(v2, i1, l1, d1);
  }

  /**
   * Creates an immutable copy of a {@link JdkOptionalsWithNullable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkOptionalsWithNullable instance
   */
  public static ImmutableJdkOptionalsWithNullable copyOf(JdkOptionalsWithNullable instance) {
    if (instance instanceof ImmutableJdkOptionalsWithNullable) {
      return (ImmutableJdkOptionalsWithNullable) instance;
    }
    return ImmutableJdkOptionalsWithNullable.of(instance.v2(), instance.i1(), instance.l1(), instance.d1());
  }
}
