package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultSpecializedOptionals}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultSpecializedOptionals.builder()}.
 */
@Generated(from = "DefaultSpecializedOptionals", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDefaultSpecializedOptionals
    implements DefaultSpecializedOptionals {
  private final OptionalInt value;

  private ImmutableDefaultSpecializedOptionals(ImmutableDefaultSpecializedOptionals.Builder builder) {
    this.value = builder.value != null
        ? builder.value
        : Objects.requireNonNull(DefaultSpecializedOptionals.super.value(), "value");
  }

  private ImmutableDefaultSpecializedOptionals(OptionalInt value) {
    this.value = value;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public OptionalInt value() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultSpecializedOptionals#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDefaultSpecializedOptionals withValue(OptionalInt value) {
    OptionalInt newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableDefaultSpecializedOptionals(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultSpecializedOptionals} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultSpecializedOptionals
        && equalTo(0, (ImmutableDefaultSpecializedOptionals) another);
  }

  private boolean equalTo(int synthetic, ImmutableDefaultSpecializedOptionals another) {
    return value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultSpecializedOptionals} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DefaultSpecializedOptionals{"
        + "value=" + value
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DefaultSpecializedOptionals} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultSpecializedOptionals instance
   */
  public static ImmutableDefaultSpecializedOptionals copyOf(DefaultSpecializedOptionals instance) {
    if (instance instanceof ImmutableDefaultSpecializedOptionals) {
      return (ImmutableDefaultSpecializedOptionals) instance;
    }
    return ImmutableDefaultSpecializedOptionals.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultSpecializedOptionals ImmutableDefaultSpecializedOptionals}.
   * <pre>
   * ImmutableDefaultSpecializedOptionals.builder()
   *    .value(OptionalInt) // optional {@link DefaultSpecializedOptionals#value() value}
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultSpecializedOptionals builder
   */
  public static ImmutableDefaultSpecializedOptionals.Builder builder() {
    return new ImmutableDefaultSpecializedOptionals.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultSpecializedOptionals ImmutableDefaultSpecializedOptionals}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultSpecializedOptionals", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable OptionalInt value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultSpecializedOptionals} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DefaultSpecializedOptionals instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultSpecializedOptionals#value() value} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultSpecializedOptionals#value() value}.</em>
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(OptionalInt value) {
      this.value = Objects.requireNonNull(value, "value");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultSpecializedOptionals ImmutableDefaultSpecializedOptionals}.
     * @return An immutable instance of DefaultSpecializedOptionals
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultSpecializedOptionals build() {
      return new ImmutableDefaultSpecializedOptionals(this);
    }
  }
}
