package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultTypingProblem.OuterObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOuterObject.builder()}.
 */
@Generated(from = "DefaultTypingProblem.OuterObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOuterObject
    extends DefaultTypingProblem.OuterObject {
  private final DefaultTypingProblem.EmptyObject emptyObject;

  private ImmutableOuterObject(DefaultTypingProblem.EmptyObject emptyObject) {
    this.emptyObject = emptyObject;
  }

  /**
   * @return The value of the {@code emptyObject} attribute
   */
  @JsonProperty("emptyObject")
  @Override
  public DefaultTypingProblem.EmptyObject emptyObject() {
    return emptyObject;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DefaultTypingProblem.OuterObject#emptyObject() emptyObject} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for emptyObject
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOuterObject withEmptyObject(DefaultTypingProblem.EmptyObject value) {
    if (this.emptyObject == value) return this;
    DefaultTypingProblem.EmptyObject newValue = Objects.requireNonNull(value, "emptyObject");
    return new ImmutableOuterObject(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOuterObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOuterObject
        && equalTo(0, (ImmutableOuterObject) another);
  }

  private boolean equalTo(int synthetic, ImmutableOuterObject another) {
    return emptyObject.equals(another.emptyObject);
  }

  /**
   * Computes a hash code from attributes: {@code emptyObject}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + emptyObject.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OuterObject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OuterObject")
        .omitNullValues()
        .add("emptyObject", emptyObject)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DefaultTypingProblem.OuterObject", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends DefaultTypingProblem.OuterObject {
    @Nullable DefaultTypingProblem.EmptyObject emptyObject;
    @JsonProperty("emptyObject")
    public void setEmptyObject(DefaultTypingProblem.EmptyObject emptyObject) {
      this.emptyObject = emptyObject;
    }
    @Override
    public DefaultTypingProblem.EmptyObject emptyObject() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOuterObject fromJson(Json json) {
    ImmutableOuterObject.Builder builder = ImmutableOuterObject.builder();
    if (json.emptyObject != null) {
      builder.emptyObject(json.emptyObject);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DefaultTypingProblem.OuterObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OuterObject instance
   */
  public static ImmutableOuterObject copyOf(DefaultTypingProblem.OuterObject instance) {
    if (instance instanceof ImmutableOuterObject) {
      return (ImmutableOuterObject) instance;
    }
    return ImmutableOuterObject.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOuterObject ImmutableOuterObject}.
   * <pre>
   * ImmutableOuterObject.builder()
   *    .emptyObject(org.immutables.fixture.jackson.DefaultTypingProblem.EmptyObject) // required {@link DefaultTypingProblem.OuterObject#emptyObject() emptyObject}
   *    .build();
   * </pre>
   * @return A new ImmutableOuterObject builder
   */
  public static ImmutableOuterObject.Builder builder() {
    return new ImmutableOuterObject.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOuterObject ImmutableOuterObject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultTypingProblem.OuterObject", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EMPTY_OBJECT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable DefaultTypingProblem.EmptyObject emptyObject;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OuterObject} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DefaultTypingProblem.OuterObject instance) {
      Objects.requireNonNull(instance, "instance");
      emptyObject(instance.emptyObject());
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultTypingProblem.OuterObject#emptyObject() emptyObject} attribute.
     * @param emptyObject The value for emptyObject 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("emptyObject")
    public final Builder emptyObject(DefaultTypingProblem.EmptyObject emptyObject) {
      this.emptyObject = Objects.requireNonNull(emptyObject, "emptyObject");
      initBits &= ~INIT_BIT_EMPTY_OBJECT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOuterObject ImmutableOuterObject}.
     * @return An immutable instance of OuterObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOuterObject build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOuterObject(emptyObject);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EMPTY_OBJECT) != 0) attributes.add("emptyObject");
      return "Cannot build OuterObject, some of required attributes are not set " + attributes;
    }
  }
}
