package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MinimumAnnotationsMapped}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMinimumAnnotationsMapped.builder()}.
 */
@Generated(from = "MinimumAnnotationsMapped", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableMinimumAnnotationsMapped
    implements MinimumAnnotationsMapped {
  private final String a;
  private final ImmutableList<Integer> b;

  private ImmutableMinimumAnnotationsMapped(String a, ImmutableList<Integer> b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @JsonProperty("A")
  @Override
  public String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @JsonProperty("B")
  @Override
  public ImmutableList<Integer> b() {
    return b;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MinimumAnnotationsMapped#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMinimumAnnotationsMapped withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableMinimumAnnotationsMapped(newValue, this.b);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MinimumAnnotationsMapped#b() b}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMinimumAnnotationsMapped withB(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableMinimumAnnotationsMapped(this.a, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MinimumAnnotationsMapped#b() b}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of b elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMinimumAnnotationsMapped withB(Iterable<Integer> elements) {
    if (this.b == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableMinimumAnnotationsMapped(this.a, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMinimumAnnotationsMapped} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMinimumAnnotationsMapped
        && equalTo(0, (ImmutableMinimumAnnotationsMapped) another);
  }

  private boolean equalTo(int synthetic, ImmutableMinimumAnnotationsMapped another) {
    return a.equals(another.a)
        && b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MinimumAnnotationsMapped} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MinimumAnnotationsMapped")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "MinimumAnnotationsMapped", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements MinimumAnnotationsMapped {
    @Nullable String a;
    @Nullable List<Integer> b = ImmutableList.of();
    @JsonProperty("A")
    public void setA(String a) {
      this.a = a;
    }
    @JsonProperty("B")
    public void setB(List<Integer> b) {
      this.b = b;
    }
    @Override
    public String a() { throw new UnsupportedOperationException(); }
    @Override
    public List<Integer> b() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMinimumAnnotationsMapped fromJson(Json json) {
    ImmutableMinimumAnnotationsMapped.Builder builder = ImmutableMinimumAnnotationsMapped.builder();
    if (json.a != null) {
      builder.a(json.a);
    }
    if (json.b != null) {
      builder.addAllB(json.b);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MinimumAnnotationsMapped} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MinimumAnnotationsMapped instance
   */
  public static ImmutableMinimumAnnotationsMapped copyOf(MinimumAnnotationsMapped instance) {
    if (instance instanceof ImmutableMinimumAnnotationsMapped) {
      return (ImmutableMinimumAnnotationsMapped) instance;
    }
    return ImmutableMinimumAnnotationsMapped.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMinimumAnnotationsMapped ImmutableMinimumAnnotationsMapped}.
   * <pre>
   * ImmutableMinimumAnnotationsMapped.builder()
   *    .a(String) // required {@link MinimumAnnotationsMapped#a() a}
   *    .addB|addAllB(int) // {@link MinimumAnnotationsMapped#b() b} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMinimumAnnotationsMapped builder
   */
  public static ImmutableMinimumAnnotationsMapped.Builder builder() {
    return new ImmutableMinimumAnnotationsMapped.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMinimumAnnotationsMapped ImmutableMinimumAnnotationsMapped}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MinimumAnnotationsMapped", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String a;
    private ImmutableList.Builder<Integer> b = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MinimumAnnotationsMapped} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MinimumAnnotationsMapped instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      addAllB(instance.b());
      return this;
    }

    /**
     * Initializes the value for the {@link MinimumAnnotationsMapped#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("A")
    public final Builder a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Adds one element to {@link MinimumAnnotationsMapped#b() b} list.
     * @param element A b element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(int element) {
      this.b.add(element);
      return this;
    }

    /**
     * Adds elements to {@link MinimumAnnotationsMapped#b() b} list.
     * @param elements An array of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(int... elements) {
      this.b.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link MinimumAnnotationsMapped#b() b} list.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("B")
    public final Builder b(Iterable<Integer> elements) {
      this.b = ImmutableList.builder();
      return addAllB(elements);
    }

    /**
     * Adds elements to {@link MinimumAnnotationsMapped#b() b} list.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllB(Iterable<Integer> elements) {
      this.b.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableMinimumAnnotationsMapped ImmutableMinimumAnnotationsMapped}.
     * @return An immutable instance of MinimumAnnotationsMapped
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMinimumAnnotationsMapped build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMinimumAnnotationsMapped(a, b.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build MinimumAnnotationsMapped, some of required attributes are not set " + attributes;
    }
  }
}
