package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JacksonGenerics}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJacksonGenerics.builder()}.
 */
@Generated(from = "JacksonGenerics", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJacksonGenerics<T extends Number>
    implements JacksonGenerics<T> {
  private final T attr;
  private final String nm;

  private ImmutableJacksonGenerics(T attr, String nm) {
    this.attr = attr;
    this.nm = nm;
  }

  /**
   * @return The value of the {@code attr} attribute
   */
  @JsonProperty("attr")
  @Override
  public T attr() {
    return attr;
  }

  /**
   * @return The value of the {@code nm} attribute
   */
  @JsonProperty("nm")
  @Override
  public String nm() {
    return nm;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JacksonGenerics#attr() attr} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJacksonGenerics<T> withAttr(T value) {
    if (this.attr == value) return this;
    T newValue = Objects.requireNonNull(value, "attr");
    return new ImmutableJacksonGenerics<>(newValue, this.nm);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JacksonGenerics#nm() nm} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nm
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJacksonGenerics<T> withNm(String value) {
    String newValue = Objects.requireNonNull(value, "nm");
    if (this.nm.equals(newValue)) return this;
    return new ImmutableJacksonGenerics<>(this.attr, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJacksonGenerics} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJacksonGenerics<?>
        && equalTo(0, (ImmutableJacksonGenerics<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableJacksonGenerics<?> another) {
    return attr.equals(another.attr)
        && nm.equals(another.nm);
  }

  /**
   * Computes a hash code from attributes: {@code attr}, {@code nm}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + attr.hashCode();
    h += (h << 5) + nm.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JacksonGenerics} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JacksonGenerics")
        .omitNullValues()
        .add("attr", attr)
        .add("nm", nm)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JacksonGenerics", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json<T extends Number>
      implements JacksonGenerics<T> {
    @Nullable T attr;
    @Nullable String nm;
    @JsonProperty("attr")
    public void setAttr(T attr) {
      this.attr = attr;
    }
    @JsonProperty("nm")
    public void setNm(String nm) {
      this.nm = nm;
    }
    @Override
    public T attr() { throw new UnsupportedOperationException(); }
    @Override
    public String nm() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <T> generic parameter T
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static <T extends Number> ImmutableJacksonGenerics<T> fromJson(Json<T> json) {
    ImmutableJacksonGenerics.Builder<T> builder = ImmutableJacksonGenerics.<T>builder();
    if (json.attr != null) {
      builder.attr(json.attr);
    }
    if (json.nm != null) {
      builder.nm(json.nm);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JacksonGenerics} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable JacksonGenerics instance
   */
  public static <T extends Number> ImmutableJacksonGenerics<T> copyOf(JacksonGenerics<T> instance) {
    if (instance instanceof ImmutableJacksonGenerics<?>) {
      return (ImmutableJacksonGenerics<T>) instance;
    }
    return ImmutableJacksonGenerics.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJacksonGenerics ImmutableJacksonGenerics}.
   * <pre>
   * ImmutableJacksonGenerics.&amp;lt;T&amp;gt;builder()
   *    .attr(T) // required {@link JacksonGenerics#attr() attr}
   *    .nm(String) // required {@link JacksonGenerics#nm() nm}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableJacksonGenerics builder
   */
  public static <T extends Number> ImmutableJacksonGenerics.Builder<T> builder() {
    return new ImmutableJacksonGenerics.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableJacksonGenerics ImmutableJacksonGenerics}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JacksonGenerics", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T extends Number> {
    private static final long INIT_BIT_ATTR = 0x1L;
    private static final long INIT_BIT_NM = 0x2L;
    private long initBits = 0x3L;

    private @Nullable T attr;
    private @Nullable String nm;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JacksonGenerics} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(JacksonGenerics<T> instance) {
      Objects.requireNonNull(instance, "instance");
      attr(instance.attr());
      nm(instance.nm());
      return this;
    }

    /**
     * Initializes the value for the {@link JacksonGenerics#attr() attr} attribute.
     * @param attr The value for attr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("attr")
    public final Builder<T> attr(T attr) {
      this.attr = Objects.requireNonNull(attr, "attr");
      initBits &= ~INIT_BIT_ATTR;
      return this;
    }

    /**
     * Initializes the value for the {@link JacksonGenerics#nm() nm} attribute.
     * @param nm The value for nm 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("nm")
    public final Builder<T> nm(String nm) {
      this.nm = Objects.requireNonNull(nm, "nm");
      initBits &= ~INIT_BIT_NM;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJacksonGenerics ImmutableJacksonGenerics}.
     * @return An immutable instance of JacksonGenerics
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJacksonGenerics<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJacksonGenerics<>(attr, nm);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ATTR) != 0) attributes.add("attr");
      if ((initBits & INIT_BIT_NM) != 0) attributes.add("nm");
      return "Cannot build JacksonGenerics, some of required attributes are not set " + attributes;
    }
  }
}
