package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GeoPoint2}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGeoPoint2.builder()}.
 */
@Generated(from = "GeoPoint2", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGeoPoint2 extends GeoPoint2 {
  private final double lon;
  private final double lat;

  private ImmutableGeoPoint2(double lon, double lat) {
    this.lon = lon;
    this.lat = lat;
  }

  /**
   * @return The value of the {@code lon} attribute
   */
  @JsonProperty("lon")
  @Override
  public double lon() {
    return lon;
  }

  /**
   * @return The value of the {@code lat} attribute
   */
  @JsonProperty("lat")
  @Override
  public double lat() {
    return lat;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GeoPoint2#lon() lon} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lon
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGeoPoint2 withLon(double value) {
    if (Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(value)) return this;
    return new ImmutableGeoPoint2(value, this.lat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GeoPoint2#lat() lat} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lat
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGeoPoint2 withLat(double value) {
    if (Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(value)) return this;
    return new ImmutableGeoPoint2(this.lon, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGeoPoint2} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGeoPoint2
        && equalTo(0, (ImmutableGeoPoint2) another);
  }

  private boolean equalTo(int synthetic, ImmutableGeoPoint2 another) {
    return Double.doubleToLongBits(lon) == Double.doubleToLongBits(another.lon)
        && Double.doubleToLongBits(lat) == Double.doubleToLongBits(another.lat);
  }

  /**
   * Computes a hash code from attributes: {@code lon}, {@code lat}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Doubles.hashCode(lon);
    h += (h << 5) + Doubles.hashCode(lat);
    return h;
  }

  /**
   * Prints the immutable value {@code GeoPoint2} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GeoPoint2")
        .omitNullValues()
        .add("lon", lon)
        .add("lat", lat)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GeoPoint2", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends GeoPoint2 {
    double lon;
    boolean lonIsSet;
    double lat;
    boolean latIsSet;
    @JsonProperty("lon")
    public void setLon(double lon) {
      this.lon = lon;
      this.lonIsSet = true;
    }
    @JsonProperty("lat")
    public void setLat(double lat) {
      this.lat = lat;
      this.latIsSet = true;
    }
    @Override
    public double lon() { throw new UnsupportedOperationException(); }
    @Override
    public double lat() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGeoPoint2 fromJson(Json json) {
    ImmutableGeoPoint2.Builder builder = ImmutableGeoPoint2.builder();
    if (json.lonIsSet) {
      builder.lon(json.lon);
    }
    if (json.latIsSet) {
      builder.lat(json.lat);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link GeoPoint2} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GeoPoint2 instance
   */
  public static ImmutableGeoPoint2 copyOf(GeoPoint2 instance) {
    if (instance instanceof ImmutableGeoPoint2) {
      return (ImmutableGeoPoint2) instance;
    }
    return ImmutableGeoPoint2.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGeoPoint2 ImmutableGeoPoint2}.
   * <pre>
   * ImmutableGeoPoint2.builder()
   *    .lon(double) // required {@link GeoPoint2#lon() lon}
   *    .lat(double) // required {@link GeoPoint2#lat() lat}
   *    .build();
   * </pre>
   * @return A new ImmutableGeoPoint2 builder
   */
  public static ImmutableGeoPoint2.Builder builder() {
    return new ImmutableGeoPoint2.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGeoPoint2 ImmutableGeoPoint2}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GeoPoint2", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LON = 0x1L;
    private static final long INIT_BIT_LAT = 0x2L;
    private long initBits = 0x3L;

    private double lon;
    private double lat;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GeoPoint2} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GeoPoint2 instance) {
      Objects.requireNonNull(instance, "instance");
      lon(instance.lon());
      lat(instance.lat());
      return this;
    }

    /**
     * Initializes the value for the {@link GeoPoint2#lon() lon} attribute.
     * @param lon The value for lon 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lon")
    public final Builder lon(double lon) {
      this.lon = lon;
      initBits &= ~INIT_BIT_LON;
      return this;
    }

    /**
     * Initializes the value for the {@link GeoPoint2#lat() lat} attribute.
     * @param lat The value for lat 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lat")
    public final Builder lat(double lat) {
      this.lat = lat;
      initBits &= ~INIT_BIT_LAT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGeoPoint2 ImmutableGeoPoint2}.
     * @return An immutable instance of GeoPoint2
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGeoPoint2 build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGeoPoint2(lon, lat);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LON) != 0) attributes.add("lon");
      if ((initBits & INIT_BIT_LAT) != 0) attributes.add("lat");
      return "Cannot build GeoPoint2, some of required attributes are not set " + attributes;
    }
  }
}
