package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GeoPoint}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGeoPoint.builder()}.
 */
@Generated(from = "GeoPoint", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGeoPoint extends GeoPoint {
  private final double altitude;
  private final double longitude;
  private final double latitude;

  private ImmutableGeoPoint(double altitude, double longitude, double latitude) {
    this.altitude = altitude;
    this.longitude = longitude;
    this.latitude = latitude;
  }

  /**
   * @return The value of the {@code altitude} attribute
   */
  @JsonProperty("altitude")
  @Override
  public double altitude() {
    return altitude;
  }

  /**
   * @return The value of the {@code longitude} attribute
   */
  @JsonProperty("longitude")
  @Override
  public double longitude() {
    return longitude;
  }

  /**
   * @return The value of the {@code latitude} attribute
   */
  @JsonProperty("latitude")
  @Override
  public double latitude() {
    return latitude;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GeoPoint#altitude() altitude} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for altitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGeoPoint withAltitude(double value) {
    if (Double.doubleToLongBits(this.altitude) == Double.doubleToLongBits(value)) return this;
    return new ImmutableGeoPoint(value, this.longitude, this.latitude);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GeoPoint#longitude() longitude} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for longitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGeoPoint withLongitude(double value) {
    if (Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(value)) return this;
    return new ImmutableGeoPoint(this.altitude, value, this.latitude);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GeoPoint#latitude() latitude} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for latitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGeoPoint withLatitude(double value) {
    if (Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(value)) return this;
    return new ImmutableGeoPoint(this.altitude, this.longitude, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGeoPoint} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGeoPoint
        && equalTo(0, (ImmutableGeoPoint) another);
  }

  private boolean equalTo(int synthetic, ImmutableGeoPoint another) {
    return Double.doubleToLongBits(altitude) == Double.doubleToLongBits(another.altitude)
        && Double.doubleToLongBits(longitude) == Double.doubleToLongBits(another.longitude)
        && Double.doubleToLongBits(latitude) == Double.doubleToLongBits(another.latitude);
  }

  /**
   * Computes a hash code from attributes: {@code altitude}, {@code longitude}, {@code latitude}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Doubles.hashCode(altitude);
    h += (h << 5) + Doubles.hashCode(longitude);
    h += (h << 5) + Doubles.hashCode(latitude);
    return h;
  }

  /**
   * Prints the immutable value {@code GeoPoint} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GeoPoint")
        .omitNullValues()
        .add("altitude", altitude)
        .add("longitude", longitude)
        .add("latitude", latitude)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "GeoPoint", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends GeoPoint {
    double altitude;
    boolean altitudeIsSet;
    double longitude;
    boolean longitudeIsSet;
    double latitude;
    boolean latitudeIsSet;
    @JsonProperty("altitude")
    public void setAltitude(double altitude) {
      this.altitude = altitude;
      this.altitudeIsSet = true;
    }
    @JsonProperty("longitude")
    public void setLongitude(double longitude) {
      this.longitude = longitude;
      this.longitudeIsSet = true;
    }
    @JsonProperty("latitude")
    public void setLatitude(double latitude) {
      this.latitude = latitude;
      this.latitudeIsSet = true;
    }
    @Override
    public double altitude() { throw new UnsupportedOperationException(); }
    @Override
    public double longitude() { throw new UnsupportedOperationException(); }
    @Override
    public double latitude() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGeoPoint fromJson(Json json) {
    ImmutableGeoPoint.Builder builder = ImmutableGeoPoint.builder();
    if (json.altitudeIsSet) {
      builder.altitude(json.altitude);
    }
    if (json.longitudeIsSet) {
      builder.longitude(json.longitude);
    }
    if (json.latitudeIsSet) {
      builder.latitude(json.latitude);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link GeoPoint} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GeoPoint instance
   */
  public static ImmutableGeoPoint copyOf(GeoPoint instance) {
    if (instance instanceof ImmutableGeoPoint) {
      return (ImmutableGeoPoint) instance;
    }
    return ImmutableGeoPoint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGeoPoint ImmutableGeoPoint}.
   * <pre>
   * ImmutableGeoPoint.builder()
   *    .altitude(double) // required {@link GeoPoint#altitude() altitude}
   *    .longitude(double) // required {@link GeoPoint#longitude() longitude}
   *    .latitude(double) // required {@link GeoPoint#latitude() latitude}
   *    .build();
   * </pre>
   * @return A new ImmutableGeoPoint builder
   */
  public static ImmutableGeoPoint.Builder builder() {
    return new ImmutableGeoPoint.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGeoPoint ImmutableGeoPoint}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GeoPoint", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ALTITUDE = 0x1L;
    private static final long INIT_BIT_LONGITUDE = 0x2L;
    private static final long INIT_BIT_LATITUDE = 0x4L;
    private long initBits = 0x7L;

    private double altitude;
    private double longitude;
    private double latitude;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GeoPoint} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GeoPoint instance) {
      Objects.requireNonNull(instance, "instance");
      altitude(instance.altitude());
      longitude(instance.longitude());
      latitude(instance.latitude());
      return this;
    }

    /**
     * Initializes the value for the {@link GeoPoint#altitude() altitude} attribute.
     * @param altitude The value for altitude 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("altitude")
    public final Builder altitude(double altitude) {
      this.altitude = altitude;
      initBits &= ~INIT_BIT_ALTITUDE;
      return this;
    }

    /**
     * Initializes the value for the {@link GeoPoint#longitude() longitude} attribute.
     * @param longitude The value for longitude 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("longitude")
    public final Builder longitude(double longitude) {
      this.longitude = longitude;
      initBits &= ~INIT_BIT_LONGITUDE;
      return this;
    }

    /**
     * Initializes the value for the {@link GeoPoint#latitude() latitude} attribute.
     * @param latitude The value for latitude 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("latitude")
    public final Builder latitude(double latitude) {
      this.latitude = latitude;
      initBits &= ~INIT_BIT_LATITUDE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGeoPoint ImmutableGeoPoint}.
     * @return An immutable instance of GeoPoint
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGeoPoint build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGeoPoint(altitude, longitude, latitude);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ALTITUDE) != 0) attributes.add("altitude");
      if ((initBits & INIT_BIT_LONGITUDE) != 0) attributes.add("longitude");
      if ((initBits & INIT_BIT_LATITUDE) != 0) attributes.add("latitude");
      return "Cannot build GeoPoint, some of required attributes are not set " + attributes;
    }
  }
}
