package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PolymorphicMappings.DatasetPathLocator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new PolymorphicMappings.DatasetPathLocator.Builder()}.
 */
@Generated(from = "PolymorphicMappings.DatasetPathLocator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDatasetPathLocator
    implements PolymorphicMappings.DatasetPathLocator {
  private final String datasetPath;

  private ImmutableDatasetPathLocator(String datasetPath) {
    this.datasetPath = datasetPath;
  }

  /**
   * @return The value of the {@code datasetPath} attribute
   */
  @JsonProperty("datasetPath")
  @Override
  public String getDatasetPath() {
    return datasetPath;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PolymorphicMappings.DatasetPathLocator#getDatasetPath() datasetPath} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datasetPath
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetPathLocator withDatasetPath(String value) {
    String newValue = Objects.requireNonNull(value, "datasetPath");
    if (this.datasetPath.equals(newValue)) return this;
    return new ImmutableDatasetPathLocator(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatasetPathLocator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatasetPathLocator
        && equalTo(0, (ImmutableDatasetPathLocator) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatasetPathLocator another) {
    return datasetPath.equals(another.datasetPath);
  }

  /**
   * Computes a hash code from attributes: {@code datasetPath}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + datasetPath.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DatasetPathLocator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DatasetPathLocator")
        .omitNullValues()
        .add("datasetPath", datasetPath)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PolymorphicMappings.DatasetPathLocator", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PolymorphicMappings.DatasetPathLocator {
    @Nullable String datasetPath;
    @JsonProperty("datasetPath")
    public void setDatasetPath(String datasetPath) {
      this.datasetPath = datasetPath;
    }
    @Override
    public String getDatasetPath() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDatasetPathLocator fromJson(Json json) {
    PolymorphicMappings.DatasetPathLocator.Builder builder = new PolymorphicMappings.DatasetPathLocator.Builder();
    if (json.datasetPath != null) {
      builder.datasetPath(json.datasetPath);
    }
    return (ImmutableDatasetPathLocator) builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PolymorphicMappings.DatasetPathLocator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatasetPathLocator instance
   */
  public static ImmutableDatasetPathLocator copyOf(PolymorphicMappings.DatasetPathLocator instance) {
    if (instance instanceof ImmutableDatasetPathLocator) {
      return (ImmutableDatasetPathLocator) instance;
    }
    return new PolymorphicMappings.DatasetPathLocator.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableDatasetPathLocator ImmutableDatasetPathLocator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PolymorphicMappings.DatasetPathLocator", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_DATASET_PATH = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String datasetPath;

    /**
     * Creates a builder for {@link ImmutableDatasetPathLocator ImmutableDatasetPathLocator} instances.
     * <pre>
     * new PolymorphicMappings.DatasetPathLocator.Builder()
     *    .datasetPath(String) // required {@link PolymorphicMappings.DatasetPathLocator#getDatasetPath() datasetPath}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof PolymorphicMappings.DatasetPathLocator.Builder)) {
        throw new UnsupportedOperationException("Use: new PolymorphicMappings.DatasetPathLocator.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatasetPathLocator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final PolymorphicMappings.DatasetPathLocator.Builder from(PolymorphicMappings.DatasetPathLocator instance) {
      Objects.requireNonNull(instance, "instance");
      datasetPath(instance.getDatasetPath());
      return (PolymorphicMappings.DatasetPathLocator.Builder) this;
    }

    /**
     * Initializes the value for the {@link PolymorphicMappings.DatasetPathLocator#getDatasetPath() datasetPath} attribute.
     * @param datasetPath The value for datasetPath 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("datasetPath")
    public final PolymorphicMappings.DatasetPathLocator.Builder datasetPath(String datasetPath) {
      this.datasetPath = Objects.requireNonNull(datasetPath, "datasetPath");
      initBits &= ~INIT_BIT_DATASET_PATH;
      return (PolymorphicMappings.DatasetPathLocator.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableDatasetPathLocator ImmutableDatasetPathLocator}.
     * @return An immutable instance of DatasetPathLocator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatasetPathLocator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDatasetPathLocator(datasetPath);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DATASET_PATH) != 0) attributes.add("datasetPath");
      return "Cannot build DatasetPathLocator, some of required attributes are not set " + attributes;
    }
  }
}
