package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PolymorphicMappings.DatasetIdLocator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new PolymorphicMappings.DatasetIdLocator.Builder()}.
 */
@Generated(from = "PolymorphicMappings.DatasetIdLocator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDatasetIdLocator
    implements PolymorphicMappings.DatasetIdLocator {
  private final String datasetId;

  private ImmutableDatasetIdLocator(String datasetId) {
    this.datasetId = datasetId;
  }

  /**
   * @return The value of the {@code datasetId} attribute
   */
  @JsonProperty("datasetId")
  @Override
  public String getDatasetId() {
    return datasetId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PolymorphicMappings.DatasetIdLocator#getDatasetId() datasetId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datasetId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDatasetIdLocator withDatasetId(String value) {
    String newValue = Objects.requireNonNull(value, "datasetId");
    if (this.datasetId.equals(newValue)) return this;
    return new ImmutableDatasetIdLocator(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDatasetIdLocator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDatasetIdLocator
        && equalTo(0, (ImmutableDatasetIdLocator) another);
  }

  private boolean equalTo(int synthetic, ImmutableDatasetIdLocator another) {
    return datasetId.equals(another.datasetId);
  }

  /**
   * Computes a hash code from attributes: {@code datasetId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + datasetId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DatasetIdLocator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DatasetIdLocator")
        .omitNullValues()
        .add("datasetId", datasetId)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PolymorphicMappings.DatasetIdLocator", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PolymorphicMappings.DatasetIdLocator {
    @Nullable String datasetId;
    @JsonProperty("datasetId")
    public void setDatasetId(String datasetId) {
      this.datasetId = datasetId;
    }
    @Override
    public String getDatasetId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDatasetIdLocator fromJson(Json json) {
    PolymorphicMappings.DatasetIdLocator.Builder builder = new PolymorphicMappings.DatasetIdLocator.Builder();
    if (json.datasetId != null) {
      builder.datasetId(json.datasetId);
    }
    return (ImmutableDatasetIdLocator) builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PolymorphicMappings.DatasetIdLocator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DatasetIdLocator instance
   */
  public static ImmutableDatasetIdLocator copyOf(PolymorphicMappings.DatasetIdLocator instance) {
    if (instance instanceof ImmutableDatasetIdLocator) {
      return (ImmutableDatasetIdLocator) instance;
    }
    return new PolymorphicMappings.DatasetIdLocator.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableDatasetIdLocator ImmutableDatasetIdLocator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PolymorphicMappings.DatasetIdLocator", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_DATASET_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String datasetId;

    /**
     * Creates a builder for {@link ImmutableDatasetIdLocator ImmutableDatasetIdLocator} instances.
     * <pre>
     * new PolymorphicMappings.DatasetIdLocator.Builder()
     *    .datasetId(String) // required {@link PolymorphicMappings.DatasetIdLocator#getDatasetId() datasetId}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof PolymorphicMappings.DatasetIdLocator.Builder)) {
        throw new UnsupportedOperationException("Use: new PolymorphicMappings.DatasetIdLocator.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code DatasetIdLocator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final PolymorphicMappings.DatasetIdLocator.Builder from(PolymorphicMappings.DatasetIdLocator instance) {
      Objects.requireNonNull(instance, "instance");
      datasetId(instance.getDatasetId());
      return (PolymorphicMappings.DatasetIdLocator.Builder) this;
    }

    /**
     * Initializes the value for the {@link PolymorphicMappings.DatasetIdLocator#getDatasetId() datasetId} attribute.
     * @param datasetId The value for datasetId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("datasetId")
    public final PolymorphicMappings.DatasetIdLocator.Builder datasetId(String datasetId) {
      this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
      initBits &= ~INIT_BIT_DATASET_ID;
      return (PolymorphicMappings.DatasetIdLocator.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableDatasetIdLocator ImmutableDatasetIdLocator}.
     * @return An immutable instance of DatasetIdLocator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDatasetIdLocator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDatasetIdLocator(datasetId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DATASET_ID) != 0) attributes.add("datasetId");
      return "Cannot build DatasetIdLocator, some of required attributes are not set " + attributes;
    }
  }
}
