package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AttributeIs}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAttributeIs.builder()}.
 */
@Generated(from = "AttributeIs", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAttributeIs implements AttributeIs {
  private final boolean isEmpty;
  private final boolean empty;

  private ImmutableAttributeIs(boolean isEmpty, boolean empty) {
    this.isEmpty = isEmpty;
    this.empty = empty;
  }

  /**
   * @return The value of the {@code isEmpty} attribute
   */
  @JsonProperty("isEmpty")
  @Override
  public boolean isEmpty() {
    return isEmpty;
  }

  /**
   * @return The value of the {@code empty} attribute
   */
  @JsonProperty("empty")
  @Override
  public boolean getEmpty() {
    return empty;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeIs#isEmpty() isEmpty} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isEmpty
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeIs withIsEmpty(boolean value) {
    if (this.isEmpty == value) return this;
    return new ImmutableAttributeIs(value, this.empty);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeIs#getEmpty() empty} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for empty
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeIs withEmpty(boolean value) {
    if (this.empty == value) return this;
    return new ImmutableAttributeIs(this.isEmpty, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAttributeIs} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAttributeIs
        && equalTo(0, (ImmutableAttributeIs) another);
  }

  private boolean equalTo(int synthetic, ImmutableAttributeIs another) {
    return isEmpty == another.isEmpty
        && empty == another.empty;
  }

  /**
   * Computes a hash code from attributes: {@code isEmpty}, {@code empty}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(isEmpty);
    h += (h << 5) + Booleans.hashCode(empty);
    return h;
  }

  /**
   * Prints the immutable value {@code AttributeIs} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AttributeIs")
        .omitNullValues()
        .add("isEmpty", isEmpty)
        .add("empty", empty)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AttributeIs", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AttributeIs {
    boolean isEmpty;
    boolean isEmptyIsSet;
    boolean empty;
    boolean emptyIsSet;
    @JsonProperty("isEmpty")
    public void setIsEmpty(boolean isEmpty) {
      this.isEmpty = isEmpty;
      this.isEmptyIsSet = true;
    }
    @JsonProperty("empty")
    public void setEmpty(boolean empty) {
      this.empty = empty;
      this.emptyIsSet = true;
    }
    @Override
    public boolean isEmpty() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getEmpty() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAttributeIs fromJson(Json json) {
    ImmutableAttributeIs.Builder builder = ImmutableAttributeIs.builder();
    if (json.isEmptyIsSet) {
      builder.isEmpty(json.isEmpty);
    }
    if (json.emptyIsSet) {
      builder.empty(json.empty);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AttributeIs} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AttributeIs instance
   */
  public static ImmutableAttributeIs copyOf(AttributeIs instance) {
    if (instance instanceof ImmutableAttributeIs) {
      return (ImmutableAttributeIs) instance;
    }
    return ImmutableAttributeIs.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAttributeIs ImmutableAttributeIs}.
   * <pre>
   * ImmutableAttributeIs.builder()
   *    .isEmpty(boolean) // required {@link AttributeIs#isEmpty() isEmpty}
   *    .empty(boolean) // required {@link AttributeIs#getEmpty() empty}
   *    .build();
   * </pre>
   * @return A new ImmutableAttributeIs builder
   */
  public static ImmutableAttributeIs.Builder builder() {
    return new ImmutableAttributeIs.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAttributeIs ImmutableAttributeIs}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AttributeIs", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IS_EMPTY = 0x1L;
    private static final long INIT_BIT_EMPTY = 0x2L;
    private long initBits = 0x3L;

    private boolean isEmpty;
    private boolean empty;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AttributeIs} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AttributeIs instance) {
      Objects.requireNonNull(instance, "instance");
      isEmpty(instance.isEmpty());
      empty(instance.getEmpty());
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeIs#isEmpty() isEmpty} attribute.
     * @param isEmpty The value for isEmpty 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("isEmpty")
    public final Builder isEmpty(boolean isEmpty) {
      this.isEmpty = isEmpty;
      initBits &= ~INIT_BIT_IS_EMPTY;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeIs#getEmpty() empty} attribute.
     * @param empty The value for empty 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("empty")
    public final Builder empty(boolean empty) {
      this.empty = empty;
      initBits &= ~INIT_BIT_EMPTY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAttributeIs ImmutableAttributeIs}.
     * @return An immutable instance of AttributeIs
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAttributeIs build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAttributeIs(isEmpty, empty);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IS_EMPTY) != 0) attributes.add("isEmpty");
      if ((initBits & INIT_BIT_EMPTY) != 0) attributes.add("empty");
      return "Cannot build AttributeIs, some of required attributes are not set " + attributes;
    }
  }
}
