package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Secondie}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSecondie.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSecondie.of()}.
 */
@Generated(from = "Secondie", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSecondie<T, V> implements Secondie<T, V> {
  private final @Nullable V integer;
  private final @Nullable ImmutableList<T> list;
  private final @Nullable ImmutableSet<V> set;
  private final ImmutableMultimap<T, V> coll;
  private transient final @Nullable List<V> lst;

  private ImmutableSecondie(@Nullable V integer, @Nullable Iterable<? extends T> list) {
    this.integer = integer;
    this.list = list == null ? null : ImmutableList.copyOf(list);
    this.coll = ImmutableMultimap.of();
    this.set = initShim.set();
    this.lst = initShim.lst();
    this.initShim = null;
  }

  private ImmutableSecondie(ImmutableSecondie.Builder<T, V> builder) {
    this.integer = builder.integer;
    this.list = builder.list == null ? null : builder.list.build();
    this.coll = builder.coll.build();
    if (builder.setIsSet()) {
      initShim.set(builder.set == null ? null : builder.set.build());
    }
    this.set = initShim.set();
    this.lst = initShim.lst();
    this.initShim = null;
  }

  private ImmutableSecondie(
      @Nullable V integer,
      @Nullable ImmutableList<T> list,
      @Nullable ImmutableSet<V> set,
      ImmutableMultimap<T, V> coll) {
    this.integer = integer;
    this.list = list;
    initShim.set(set);
    this.coll = coll;
    this.set = initShim.set();
    this.lst = initShim.lst();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Secondie", generator = "Immutables")
  private final class InitShim {
    private byte setBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<V> set;

    ImmutableSet<V> set() {
      if (setBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (setBuildStage == STAGE_UNINITIALIZED) {
        setBuildStage = STAGE_INITIALIZING;
        this.set = setInitialize() == null ? null : ImmutableSet.copyOf(setInitialize());
        setBuildStage = STAGE_INITIALIZED;
      }
      return this.set;
    }

    void set(ImmutableSet<V> set) {
      this.set = set;
      setBuildStage = STAGE_INITIALIZED;
    }

    private byte lstBuildStage = STAGE_UNINITIALIZED;
    private List<V> lst;

    List<V> lst() {
      if (lstBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (lstBuildStage == STAGE_UNINITIALIZED) {
        lstBuildStage = STAGE_INITIALIZING;
        this.lst = lstInitialize();
        lstBuildStage = STAGE_INITIALIZED;
      }
      return this.lst;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (setBuildStage == STAGE_INITIALIZING) attributes.add("set");
      if (lstBuildStage == STAGE_INITIALIZING) attributes.add("lst");
      return "Cannot build Secondie, attribute initializers form cycle " + attributes;
    }
  }

  private @Nullable Set<V> setInitialize() {
    return Secondie.super.set();
  }

  private @Nullable List<V> lstInitialize() {
    return Secondie.super.lst();
  }

  /**
   * @return The value of the {@code integer} attribute
   */
  @Override
  public @Nullable V integer() {
    return integer;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public @Nullable ImmutableList<T> list() {
    return list;
  }

  /**
   * @return The value of the {@code set} attribute
   */
  @Override
  public @Nullable ImmutableSet<V> set() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.set()
        : this.set;
  }

  /**
   * @return The value of the {@code coll} attribute
   */
  @Override
  public ImmutableMultimap<T, V> coll() {
    return coll;
  }

  /**
   * @return The computed-at-construction value of the {@code lst} attribute
   */
  @Override
  public @Nullable List<V> lst() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.lst()
        : this.lst;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Secondie#integer() integer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for integer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSecondie<T, V> withInteger(@Nullable V value) {
    if (this.integer == value) return this;
    return new ImmutableSecondie<>(value, this.list, this.set, this.coll);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Secondie#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableSecondie<T, V> withList(@Nullable T... elements) {
    if (elements == null) {
      return new ImmutableSecondie<>(this.integer, null, this.set, this.coll);
    }
    @Nullable ImmutableList<T> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableSecondie<>(this.integer, newValue, this.set, this.coll);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Secondie#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSecondie<T, V> withList(@Nullable Iterable<? extends T> elements) {
    if (this.list == elements) return this;
    @Nullable ImmutableList<T> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableSecondie<>(this.integer, newValue, this.set, this.coll);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Secondie#set() set}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableSecondie<T, V> withSet(@Nullable V... elements) {
    if (elements == null) {
      return new ImmutableSecondie<>(this.integer, this.list, null, this.coll);
    }
    @Nullable ImmutableSet<V> newValue = elements == null ? null : ImmutableSet.copyOf(elements);
    return new ImmutableSecondie<>(this.integer, this.list, newValue, this.coll);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Secondie#set() set}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of set elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSecondie<T, V> withSet(@Nullable Iterable<? extends V> elements) {
    if (this.set == elements) return this;
    @Nullable ImmutableSet<V> newValue = elements == null ? null : ImmutableSet.copyOf(elements);
    return new ImmutableSecondie<>(this.integer, this.list, newValue, this.coll);
  }

  /**
   * Copy the current immutable object by replacing the {@link Secondie#coll() coll} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the coll map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSecondie<T, V> withColl(Multimap<? extends T, ? extends V> entries) {
    if (this.coll == entries) return this;
    ImmutableMultimap<T, V> newValue = ImmutableMultimap.copyOf(entries);
    return new ImmutableSecondie<>(this.integer, this.list, this.set, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSecondie} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSecondie<?, ?>
        && equalTo(0, (ImmutableSecondie<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableSecondie<?, ?> another) {
    return Objects.equals(integer, another.integer)
        && Objects.equals(list, another.list)
        && Objects.equals(set, another.set)
        && coll.equals(another.coll)
        && Objects.equals(lst, another.lst);
  }

  /**
   * Computes a hash code from attributes: {@code integer}, {@code list}, {@code set}, {@code coll}, {@code lst}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(integer);
    h += (h << 5) + Objects.hashCode(list);
    h += (h << 5) + Objects.hashCode(set);
    h += (h << 5) + coll.hashCode();
    h += (h << 5) + Objects.hashCode(lst);
    return h;
  }

  /**
   * Prints the immutable value {@code Secondie} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Secondie")
        .omitNullValues()
        .add("integer", integer)
        .add("list", list)
        .add("set", set)
        .add("coll", coll)
        .add("lst", lst)
        .toString();
  }

  /**
   * Construct a new immutable {@code Secondie} instance.
 * @param <T> generic parameter T
 * @param <V> generic parameter V
   * @param integer The value for the {@code integer} attribute
   * @param list The value for the {@code list} attribute
   * @return An immutable Secondie instance
   */
  public static <T, V> ImmutableSecondie<T, V> of(@Nullable V integer, @Nullable List<T> list) {
    return of(integer, (Iterable<? extends T>) list);
  }

  /**
   * Construct a new immutable {@code Secondie} instance.
 * @param <T> generic parameter T
 * @param <V> generic parameter V
   * @param integer The value for the {@code integer} attribute
   * @param list The value for the {@code list} attribute
   * @return An immutable Secondie instance
   */
  public static <T, V> ImmutableSecondie<T, V> of(@Nullable V integer, @Nullable Iterable<? extends T> list) {
    return new ImmutableSecondie<>(integer, list);
  }

  /**
   * Creates an immutable copy of a {@link Secondie} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param <V> generic parameter V
   * @param instance The instance to copy
   * @return A copied immutable Secondie instance
   */
  public static <T, V> ImmutableSecondie<T, V> copyOf(Secondie<T, V> instance) {
    if (instance instanceof ImmutableSecondie<?, ?>) {
      return (ImmutableSecondie<T, V>) instance;
    }
    return ImmutableSecondie.<T, V>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSecondie ImmutableSecondie}.
   * <pre>
   * ImmutableSecondie.&amp;lt;T, V&amp;gt;builder()
   *    .integer(V | null) // nullable {@link Secondie#integer() integer}
   *    .list(List&amp;lt;T&amp;gt; | null) // nullable {@link Secondie#list() list}
   *    .set(Set&amp;lt;V&amp;gt; | null) // nullable {@link Secondie#set() set}
   *    .putColl|putAllColl(T =&gt; V) // {@link Secondie#coll() coll} mappings
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param <V> generic parameter V
   * @return A new ImmutableSecondie builder
   */
  public static <T, V> ImmutableSecondie.Builder<T, V> builder() {
    return new ImmutableSecondie.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableSecondie ImmutableSecondie}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Secondie", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T, V> {
    private static final long OPT_BIT_SET = 0x1L;
    private long optBits;

    private @Nullable V integer;
    private ImmutableList.Builder<T> list = null;
    private ImmutableSet.Builder<V> set = null;
    private ImmutableMultimap.Builder<T, V> coll = ImmutableMultimap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableSecondie} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> from(ModifiableSecondie<T, V> instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable V integerValue = instance.integer();
      if (integerValue != null) {
        integer(integerValue);
      }
      @Nullable List<T> listValue = instance.list();
      if (listValue != null) {
        addAllList(listValue);
      }
      @Nullable Set<V> setValue = instance.set();
      if (setValue != null) {
        addAllSet(setValue);
      }
      putAllColl(instance.coll());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Secondie} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> from(Secondie<T, V> instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableSecondie<?, ?>) {
        return from((ModifiableSecondie<T, V>) instance);
      }
      @Nullable V integerValue = instance.integer();
      if (integerValue != null) {
        integer(integerValue);
      }
      @Nullable List<T> listValue = instance.list();
      if (listValue != null) {
        addAllList(listValue);
      }
      @Nullable Set<V> setValue = instance.set();
      if (setValue != null) {
        addAllSet(setValue);
      }
      putAllColl(instance.coll());
      return this;
    }

    /**
     * Initializes the value for the {@link Secondie#integer() integer} attribute.
     * @param integer The value for integer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> integer(@Nullable V integer) {
      this.integer = integer;
      return this;
    }

    /**
     * Adds one element to {@link Secondie#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> addList(T element) {
      if (this.list == null) {
        this.list = ImmutableList.builder();
      }
      this.list.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Secondie#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T, V> addList(T... elements) {
      if (this.list == null) {
        this.list = ImmutableList.builder();
      }
      this.list.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Secondie#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> list(@Nullable Iterable<? extends T> elements) {
      if (elements == null) {
        this.list = null;
        return this;
      }
      this.list = ImmutableList.builder();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link Secondie#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> addAllList(Iterable<? extends T> elements) {
      Objects.requireNonNull(elements, "list element");
      if (this.list == null) {
        this.list = ImmutableList.builder();
      }
      this.list.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link Secondie#set() set} set.
     * @param element A set element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> addSet(V element) {
      if (this.set == null) {
        this.set = ImmutableSet.builder();
      }
      this.set.add(element);
      optBits |= OPT_BIT_SET;
      return this;
    }

    /**
     * Adds elements to {@link Secondie#set() set} set.
     * @param elements An array of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T, V> addSet(V... elements) {
      if (this.set == null) {
        this.set = ImmutableSet.builder();
      }
      this.set.add(elements);
      optBits |= OPT_BIT_SET;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Secondie#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> set(@Nullable Iterable<? extends V> elements) {
      if (elements == null) {
        this.set = null;
        optBits |= OPT_BIT_SET;
        return this;
      }
      this.set = ImmutableSet.builder();
      return addAllSet(elements);
    }

    /**
     * Adds elements to {@link Secondie#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> addAllSet(Iterable<? extends V> elements) {
      Objects.requireNonNull(elements, "set element");
      if (this.set == null) {
        this.set = ImmutableSet.builder();
      }
      this.set.addAll(elements);
      optBits |= OPT_BIT_SET;
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link Secondie#coll() coll} true. Nulls are not permitted
     * @param key The key for coll
     * @param values The values for coll
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T, V> putColl(T key, V... values) {
      this.coll.putAll(key, Arrays.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link Secondie#coll() coll} true. Nulls are not permitted
     * @param key The key for coll
     * @param values The values for coll
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> putAllColl(T key, Iterable<V> values) {
      this.coll.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link Secondie#coll() coll} map.
     * @param key The key in the coll map
     * @param value The associated value in the coll map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> putColl(T key, V value) {
      this.coll.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Secondie#coll() coll} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> putColl(Map.Entry<? extends T, ? extends V> entry) {
      this.coll.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Secondie#coll() coll} map. Nulls are not permitted
     * @param entries The entries that will be added to the coll map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> coll(Multimap<? extends T, ? extends V> entries) {
      this.coll = ImmutableMultimap.builder();
      return putAllColl(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Secondie#coll() coll} map. Nulls are not permitted
     * @param entries The entries that will be added to the coll map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T, V> putAllColl(Multimap<? extends T, ? extends V> entries) {
      this.coll.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSecondie ImmutableSecondie}.
     * @return An immutable instance of Secondie
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSecondie<T, V> build() {
      return new ImmutableSecondie<T, V>(this);
    }

    private boolean setIsSet() {
      return (optBits & OPT_BIT_SET) != 0;
    }
  }
}
