package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RawType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRawType.builder()}.
 */
@Generated(from = "RawType", generator = "Immutables")
@SuppressWarnings({"rawtypes", "all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRawType implements RawType {
  private final Set set;
  private final Map map;

  private ImmutableRawType(Set set, Map map) {
    this.set = set;
    this.map = map;
  }

  /**
   * @return The value of the {@code set} attribute
   */
  @Override
  public Set set() {
    return set;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public Map map() {
    return map;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawType#set() set} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for set
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRawType withSet(Set value) {
    if (this.set == value) return this;
    Set newValue = Objects.requireNonNull(value, "set");
    return new ImmutableRawType(newValue, this.map);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawType#map() map} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for map
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRawType withMap(Map value) {
    if (this.map == value) return this;
    Map newValue = Objects.requireNonNull(value, "map");
    return new ImmutableRawType(this.set, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRawType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRawType
        && equalTo(0, (ImmutableRawType) another);
  }

  private boolean equalTo(int synthetic, ImmutableRawType another) {
    return set.equals(another.set)
        && map.equals(another.map);
  }

  /**
   * Computes a hash code from attributes: {@code set}, {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + set.hashCode();
    h += (h << 5) + map.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RawType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RawType")
        .omitNullValues()
        .add("set", set)
        .add("map", map)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RawType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RawType instance
   */
  public static ImmutableRawType copyOf(RawType instance) {
    if (instance instanceof ImmutableRawType) {
      return (ImmutableRawType) instance;
    }
    return ImmutableRawType.builder()
        .set(instance.set())
        .map(instance.map())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRawType ImmutableRawType}.
   * <pre>
   * ImmutableRawType.builder()
   *    .set(Set) // required {@link RawType#set() set}
   *    .map(Map) // required {@link RawType#map() map}
   *    .build();
   * </pre>
   * @return A new ImmutableRawType builder
   */
  public static ImmutableRawType.Builder builder() {
    return new ImmutableRawType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRawType ImmutableRawType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RawType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SET = 0x1L;
    private static final long INIT_BIT_MAP = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Set set;
    private @Nullable Map map;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link RawType#set() set} attribute.
     * @param set The value for set 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder set(Set set) {
      checkNotIsSet(setIsSet(), "set");
      this.set = Objects.requireNonNull(set, "set");
      initBits &= ~INIT_BIT_SET;
      return this;
    }

    /**
     * Initializes the value for the {@link RawType#map() map} attribute.
     * @param map The value for map 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder map(Map map) {
      checkNotIsSet(mapIsSet(), "map");
      this.map = Objects.requireNonNull(map, "map");
      initBits &= ~INIT_BIT_MAP;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRawType ImmutableRawType}.
     * @return An immutable instance of RawType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRawType build() {
      checkRequiredAttributes();
      return new ImmutableRawType(set, map);
    }

    private boolean setIsSet() {
      return (initBits & INIT_BIT_SET) == 0;
    }

    private boolean mapIsSet() {
      return (initBits & INIT_BIT_MAP) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of RawType is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!setIsSet()) attributes.add("set");
      if (!mapIsSet()) attributes.add("map");
      return "Cannot build RawType, some of required attributes are not set " + attributes;
    }
  }
}
