package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GenericCore.GenericAdult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGenericAdult.builder()}.
 */
@Generated(from = "GenericCore.GenericAdult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGenericAdult<T extends CharSequence>
    implements GenericCore.GenericAdult<T> {
  private final T object;
  private final int id;

  private ImmutableGenericAdult(T object, int id) {
    this.object = object;
    this.id = id;
  }

  /**
   * @return The value of the {@code object} attribute
   */
  @Override
  public T getObject() {
    return object;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public int getId() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCore.GenericAdult#getObject() object} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for object
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericAdult<T> withObject(T value) {
    if (this.object == value) return this;
    T newValue = Objects.requireNonNull(value, "object");
    return new ImmutableGenericAdult<>(newValue, this.id);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericCore.GenericAdult#getId() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericAdult<T> withId(int value) {
    if (this.id == value) return this;
    return new ImmutableGenericAdult<>(this.object, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGenericAdult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGenericAdult<?>
        && equalTo(0, (ImmutableGenericAdult<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableGenericAdult<?> another) {
    return object.equals(another.object)
        && id == another.id;
  }

  /**
   * Computes a hash code from attributes: {@code object}, {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + object.hashCode();
    h += (h << 5) + id;
    return h;
  }

  /**
   * Prints the immutable value {@code GenericAdult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GenericAdult")
        .omitNullValues()
        .add("object", object)
        .add("id", id)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GenericCore.GenericAdult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable GenericAdult instance
   */
  public static <T extends CharSequence> ImmutableGenericAdult<T> copyOf(GenericCore.GenericAdult<T> instance) {
    if (instance instanceof ImmutableGenericAdult<?>) {
      return (ImmutableGenericAdult<T>) instance;
    }
    return ImmutableGenericAdult.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGenericAdult ImmutableGenericAdult}.
   * <pre>
   * ImmutableGenericAdult.&amp;lt;T&amp;gt;builder()
   *    .object(T) // required {@link GenericCore.GenericAdult#getObject() object}
   *    .id(int) // required {@link GenericCore.GenericAdult#getId() id}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableGenericAdult builder
   */
  public static <T extends CharSequence> ImmutableGenericAdult.Builder<T> builder() {
    return new ImmutableGenericAdult.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableGenericAdult ImmutableGenericAdult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericCore.GenericAdult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T extends CharSequence> {
    private static final long INIT_BIT_OBJECT = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable T object;
    private int id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.generics.GenericCore.GenericAdult} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericCore.GenericAdult<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.generics.GenericCore.Core} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericCore.Core<T> instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    @SuppressWarnings("unchecked")
    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof GenericCore.GenericAdult<?>) {
        GenericCore.GenericAdult<T> instance = (GenericCore.GenericAdult<T>) object;
        id(instance.getId());
        if ((bits & 0x1L) == 0) {
          object(instance.getObject());
          bits |= 0x1L;
        }
      }
      if (object instanceof GenericCore.Core<?>) {
        GenericCore.Core<T> instance = (GenericCore.Core<T>) object;
        if ((bits & 0x1L) == 0) {
          object(instance.getObject());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link GenericCore.GenericAdult#getObject() object} attribute.
     * @param object The value for object 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> object(T object) {
      this.object = Objects.requireNonNull(object, "object");
      initBits &= ~INIT_BIT_OBJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link GenericCore.GenericAdult#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> id(int id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGenericAdult ImmutableGenericAdult}.
     * @return An immutable instance of GenericAdult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGenericAdult<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGenericAdult<>(object, id);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OBJECT) != 0) attributes.add("object");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build GenericAdult, some of required attributes are not set " + attributes;
    }
  }
}
