package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractValidate.Concrete2}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConcrete2.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableConcrete2.of()}.
 */
@Generated(from = "AbstractValidate.Concrete2", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConcrete2<T> extends AbstractValidate.Concrete2<T> {
  private final T reference;

  private ImmutableConcrete2(T reference) {
    this.reference = Objects.requireNonNull(reference, "reference");
  }

  private ImmutableConcrete2(ImmutableConcrete2<T> original, T reference) {
    this.reference = reference;
  }

  /**
   * @return The value of the {@code reference} attribute
   */
  @Override
  T reference() {
    return reference;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractValidate.Concrete2#reference() reference} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConcrete2<T> withReference(T value) {
    if (this.reference == value) return this;
    T newValue = Objects.requireNonNull(value, "reference");
    return validate(new ImmutableConcrete2<>(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConcrete2} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConcrete2<?>
        && equalTo(0, (ImmutableConcrete2<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableConcrete2<?> another) {
    return reference.equals(another.reference);
  }

  /**
   * Computes a hash code from attributes: {@code reference}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + reference.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Concrete2} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Concrete2")
        .omitNullValues()
        .add("reference", reference)
        .toString();
  }

  /**
   * Construct a new immutable {@code Concrete2} instance.
 * @param <T> generic parameter T
   * @param reference The value for the {@code reference} attribute
   * @return An immutable Concrete2 instance
   */
  public static <T> ImmutableConcrete2<T> of(T reference) {
    return validate(new ImmutableConcrete2<>(reference));
  }

  private static <T> ImmutableConcrete2<T> validate(ImmutableConcrete2<T> instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link AbstractValidate.Concrete2} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Concrete2 instance
   */
  public static <T> ImmutableConcrete2<T> copyOf(AbstractValidate.Concrete2<T> instance) {
    if (instance instanceof ImmutableConcrete2<?>) {
      return (ImmutableConcrete2<T>) instance;
    }
    return ImmutableConcrete2.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConcrete2 ImmutableConcrete2}.
   * <pre>
   * ImmutableConcrete2.&amp;lt;T&amp;gt;builder()
   *    .reference(T) // required {@link AbstractValidate.Concrete2#reference() reference}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableConcrete2 builder
   */
  public static <T> ImmutableConcrete2.Builder<T> builder() {
    return new ImmutableConcrete2.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableConcrete2 ImmutableConcrete2}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractValidate.Concrete2", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_REFERENCE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable T reference;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Concrete2} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(AbstractValidate.Concrete2<T> instance) {
      Objects.requireNonNull(instance, "instance");
      reference(instance.reference());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractValidate.Concrete2#reference() reference} attribute.
     * @param reference The value for reference 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> reference(T reference) {
      this.reference = Objects.requireNonNull(reference, "reference");
      initBits &= ~INIT_BIT_REFERENCE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConcrete2 ImmutableConcrete2}.
     * @return An immutable instance of Concrete2
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConcrete2<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableConcrete2.validate(new ImmutableConcrete2<>(null, reference));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REFERENCE) != 0) attributes.add("reference");
      return "Cannot build Concrete2, some of required attributes are not set " + attributes;
    }
  }
}
