package org.immutables.fixture.generics;

import com.google.common.collect.Multimap;
import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Secondie}.
 * @see ImmutableSecondie
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.generics", generator = "Gsons")
public final class GsonAdaptersSecondie implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SecondieTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SecondieTypeAdapter(type, gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSecondie(Secondie)";
  }

  @org.immutables.value.Generated(from = "Secondie", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SecondieTypeAdapter<T, V> extends TypeAdapter<Secondie<T, V>> {
    public final List<V> lstTypeSample = null;
    private final TypeAdapter<V> integerTypeAdapter;
    private final TypeAdapter<T> listTypeAdapter;
    private final TypeAdapter<V> setTypeAdapter;
    private final TypeAdapter<T> collTypeAdapter;
    private final TypeAdapter<V> collSecondaryTypeAdapter;
    private final TypeAdapter<List<V>> lstTypeAdapter;

    SecondieTypeAdapter(TypeToken<?> type, Gson gson) {
      Type[] typeArguments = getTypeArguments(type);
      this.integerTypeAdapter = gson.getAdapter( (TypeToken<V>) TypeToken.get(typeArguments[1]));
      this.listTypeAdapter = gson.getAdapter( (TypeToken<T>) TypeToken.get(typeArguments[0]));
      this.setTypeAdapter = gson.getAdapter( (TypeToken<V>) TypeToken.get(typeArguments[1]));
      this.collTypeAdapter = gson.getAdapter( (TypeToken<T>) TypeToken.get(typeArguments[0]));
      this.collSecondaryTypeAdapter = gson.getAdapter( (TypeToken<V>) TypeToken.get(typeArguments[1]));
      this.lstTypeAdapter = gson.getAdapter(
          (TypeToken<List<V>>) TypeToken.getParameterized(List.class, typeArguments[1]));
    } 

    static boolean adapts(TypeToken<?> type) {
      return Secondie.class == type.getRawType()
          || ImmutableSecondie.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Secondie<T, V> value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSecondie(out, value);
      }
    }

    @Override
    public Secondie<T, V> read(JsonReader in) throws IOException {
      return readSecondie(in);
    }

    private void writeSecondie(JsonWriter out, Secondie<T, V> instance)
        throws IOException {
      out.beginObject();
      @Nullable V integerValue = instance.integer();
      if (integerValue != null) {
        out.name("integer");
        integerTypeAdapter.write(out, integerValue);
      } else if (out.getSerializeNulls()) {
        out.name("integer");
        out.nullValue();
      }
      @Nullable List<T> listElements = instance.list();
      if (listElements != null) {
        out.name("list");
        out.beginArray();
        for (T e : listElements) {
          listTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("list");
        out.nullValue();
      }
      @Nullable Set<V> setElements = instance.set();
      if (setElements != null) {
        out.name("set");
        out.beginArray();
        for (V e : setElements) {
          setTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("set");
        out.nullValue();
      }
      Multimap<T, V> collMapping = instance.coll();
      out.name("coll");
      out.beginObject();
      for (Map.Entry<T, Collection<V>> e : collMapping.asMap().entrySet()) {
        String key = collTypeAdapter.toJsonTree(e.getKey()).getAsString();
        out.name(key);
        out.beginArray();
        for (V value : e.getValue()) {
          collSecondaryTypeAdapter.write(out, value);
        }
        out.endArray();
      }
      out.endObject();
      @Nullable List<V> lstValue = instance.lst();
      if (lstValue != null) {
        out.name("lst");
        lstTypeAdapter.write(out, lstValue);
      } else if (out.getSerializeNulls()) {
        out.name("lst");
        out.nullValue();
      }
      out.endObject();
    }

    private  Secondie<T, V> readSecondie(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableSecondie.Builder<T, V> builder = ImmutableSecondie.<T, V>builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableSecondie.Builder<T, V> builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("integer".equals(attributeName)) {
          readInInteger(in, builder);
          return;
        }
        break;
      case 'l':
        if ("list".equals(attributeName)) {
          readInList(in, builder);
          return;
        }
        break;
      case 's':
        if ("set".equals(attributeName)) {
          readInSet(in, builder);
          return;
        }
        break;
      case 'c':
        if ("coll".equals(attributeName)) {
          readInColl(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInInteger(JsonReader in, ImmutableSecondie.Builder<T, V> builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        V value = integerTypeAdapter.read(in);
        builder.integer(value);
      }
    }

    private void readInList(JsonReader in, ImmutableSecondie.Builder<T, V> builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            T value = listTypeAdapter.read(in);
            builder.addList(value);
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          T value = listTypeAdapter.read(in);
          builder.addList(value);
          empty = false;
        }
        if (empty) {
          builder.addAllList(Collections.<T>emptyList());
        }
      }
    }

    private void readInSet(JsonReader in, ImmutableSecondie.Builder<T, V> builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        builder.set(null);
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            V value = setTypeAdapter.read(in);
            builder.addSet(value);
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          V value = setTypeAdapter.read(in);
          builder.addSet(value);
          empty = false;
        }
        if (empty) {
          builder.addAllSet(Collections.<V>emptyList());
        }
      }
    }

    private void readInColl(JsonReader in, ImmutableSecondie.Builder<T, V> builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          T key = collTypeAdapter.fromJsonTree(new JsonPrimitive(rawKey));
          if (in.peek() == JsonToken.BEGIN_ARRAY) {
            in.beginArray();
            while(in.hasNext()) {
              V value = collSecondaryTypeAdapter.read(in);
              builder.putColl(key, value);
            }
            in.endArray();
          } else {
            V value = collSecondaryTypeAdapter.read(in);
            builder.putColl(key, value);
          }
        }
        in.endObject();
      }
    }
  }

  private static Type[] getTypeArguments(TypeToken<?> type) {
    if (type.getType() instanceof ParameterizedType) {
      return ((ParameterizedType) type.getType()).getActualTypeArguments();
    }
    throw new IllegalStateException("Please supply Type with actual type parameters to serialize "
        + type.getType() + " instance using method overloads like toJson(instance, type)."
        + " Runtime raw type alone is not enough."
        + " You can use TypeToken class or reflection to construct Type with type arguments");
  }
}
