package org.immutables.fixture.encoding.defs;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.fixture.encoding.defs.OptionalMap",
  imports = {
  },
  typeParams = {"K", "V"},
  elements = {
    @EncodingMetadata.Element(
      name = "map",
      tags = {"IMPL", "PRIVATE", "FINAL", "FIELD"},
      naming = "*",
      stdNaming = "NONE",
      type = "com.google.common.collect.ImmutableMap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "null",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "init",
      tags = {"STATIC", "PRIVATE", "FROM"},
      naming = "*_init",
      stdNaming = "NONE",
      type = "com.google.common.collect.ImmutableMap<K, V>",
      typeParams = {},
      params = {"map: java.util.Optional<? extends java.util.Map<K, V>>"},
      doc = {},
      annotations = {"@javax.annotation.Nullable"},
      code = "{\nreturn @^map.isPresent()\n? com.google.common.collect.ImmutableMap.copyOf(@^map.get())\n: null;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:get().toString();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn java.util.Objects.hashCode(@@map);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "boolean",
      typeParams = {},
      params = {"obj: org.immutables.fixture.encoding.defs.OptionalMap<K, V>"},
      doc = {},
      annotations = {},
      code = "{\nreturn java.util.Objects.equals(this.@@map, @^obj.@@map);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "build",
      tags = {"BUILDER", "PRIVATE", "BUILD"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "com.google.common.collect.ImmutableMap<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {"@javax.annotation.Nullable"},
      code = "{\nreturn @@builder != null ? @@builder.build() : null;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "get",
      tags = {"EXPOSE"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.Optional<java.util.Map<K, V>>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn java.util.Optional.<java.util.Map<@^K, @^V>>ofNullable(@@map);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "getImmutable",
      tags = {"EXPOSE"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.Optional<com.google.common.collect.ImmutableMap<K, V>>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn java.util.Optional.ofNullable(@@map);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "optionalMap_copy",
      tags = {"COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "com.google.common.collect.ImmutableMap<K, V>",
      typeParams = {},
      params = {"value: java.util.Optional<? extends java.util.Map<K, V>>"},
      doc = {},
      annotations = {},
      code = "{\nreturn @:init(@^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "builder",
      tags = {"BUILDER", "PRIVATE", "FIELD"},
      naming = "*_builder",
      stdNaming = "NONE",
      type = "com.google.common.collect.ImmutableMap.Builder<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {"@javax.annotation.Nullable"},
      code = "null",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "nonnullBuilder",
      tags = {"BUILDER", "PRIVATE", "HELPER"},
      naming = "*_nonnullBuilder",
      stdNaming = "NONE",
      type = "com.google.common.collect.ImmutableMap.Builder<K, V>",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @@builder == null ? @@builder = com.google.common.collect.ImmutableMap.<@^K, @^V>builder() : @@builder;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "put",
      tags = {"BUILDER", "INIT"},
      naming = "put*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"row: K", "value: V"},
      doc = {},
      annotations = {},
      code = "{\n@:nonnullBuilder().put(@^row, @^value);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "putAll",
      tags = {"BUILDER", "INIT"},
      naming = "putAll*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"entries: java.util.Map<? extends K, ? extends V>"},
      doc = {},
      annotations = {},
      code = "{\n@:nonnullBuilder().putAll(@^entries);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "set",
      tags = {"BUILDER", "INIT", "COPY"},
      naming = "set*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"entries: java.util.Optional<? extends java.util.Map<K, V>>"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@builder = null;\nif (@^entries.isPresent()) {\n@:nonnullBuilder().putAll(@^entries.get());\n}\n}",
      thrown = {}
    )
  }
)
public @interface OptionalMapEnabled {}
