package org.immutables.fixture.encoding.defs;

import org.immutables.encode.EncodingMetadata;

@EncodingMetadata(
  name = "org.immutables.fixture.encoding.defs.CompactDate",
  imports = {
  },
  typeParams = {},
  elements = {
    @EncodingMetadata.Element(
      name = "time",
      tags = {"IMPL", "PRIVATE", "FINAL", "FIELD"},
      naming = "*",
      stdNaming = "NONE",
      type = "long",
      typeParams = {},
      params = {},
      doc = {" Some", " Java", " Doc"},
      annotations = {},
      code = "",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "fromDate",
      tags = {"STATIC", "PRIVATE", "FROM"},
      naming = "*_fromDate",
      stdNaming = "NONE",
      type = "long",
      typeParams = {},
      params = {"date: java.util.Date"},
      doc = {},
      annotations = {},
      code = "{\nreturn @^date == null ? 0L : @^date.getTime();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toString",
      tags = {"PRIVATE", "TO_STRING", "SYNTH"},
      naming = "*_toString",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:get().toString();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "hashCode",
      tags = {"PRIVATE", "HASH_CODE", "SYNTH"},
      naming = "*_hashCode",
      stdNaming = "NONE",
      type = "int",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn @:get().hashCode();\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "equals",
      tags = {"PRIVATE", "EQUALS", "SYNTH"},
      naming = "*_equals",
      stdNaming = "NONE",
      type = "java.lang.String",
      typeParams = {},
      params = {"other: org.immutables.fixture.encoding.defs.CompactDate"},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@:get().equals(@^other.@:get())\n;}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "compactDate_build",
      tags = {"BUILDER", "PRIVATE", "BUILD", "SYNTH"},
      naming = "*_build",
      stdNaming = "NONE",
      type = "long",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nif (@@compactDate_builder == null) throw new java.lang.IllegalStateException(\"\'<*>\' is not initialized\");\nreturn @@compactDate_builder;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "compactDate_isSet",
      tags = {"BUILDER", "PRIVATE", "SYNTH", "IS_INIT"},
      naming = "*_isSet",
      stdNaming = "NONE",
      type = "boolean",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "{\nreturn this.@@compactDate_builder != null;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "get",
      tags = {"EXPOSE"},
      naming = "*",
      stdNaming = "NONE",
      type = "java.util.Date",
      typeParams = {},
      params = {},
      doc = {"Have random annotations. "},
      annotations = {"@com.fasterxml.jackson.annotation.JsonAnyGetter", "@java.lang.SuppressWarnings(\"deprecation\")"},
      code = "{\nreturn @:toDate(@@time);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "with",
      tags = {"COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "long",
      typeParams = {},
      params = {"x: java.util.Date"},
      doc = {},
      annotations = {},
      code = "{\njava.util.Objects.requireNonNull(@^x);\nreturn @^x.getTime() + @@time;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "withL",
      tags = {"COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "long",
      typeParams = {},
      params = {"x: long"},
      doc = {},
      annotations = {},
      code = "{\nlong uu = @^x + 42;\nreturn uu;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "withI",
      tags = {"COPY"},
      naming = "*",
      stdNaming = "NONE",
      type = "long",
      typeParams = {},
      params = {"x: int"},
      doc = {},
      annotations = {},
      code = "{\nreturn @@time + @^x;\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "toDate",
      tags = {"STATIC", "PRIVATE", "HELPER"},
      naming = "*_toDate",
      stdNaming = "NONE",
      type = "java.util.Date",
      typeParams = {},
      params = {"time: long"},
      doc = {"Copy It "},
      annotations = {"@java.lang.Deprecated"},
      code = "{\nreturn @^time == 0L ? null : new java.util.Date(@^time);\n}",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "compactDate_builder",
      tags = {"BUILDER", "PRIVATE", "FIELD", "SYNTH"},
      naming = "*_builder",
      stdNaming = "NONE",
      type = "java.lang.Long",
      typeParams = {},
      params = {},
      doc = {},
      annotations = {},
      code = "",
      thrown = {}
    ),
    @EncodingMetadata.Element(
      name = "compactDate_set",
      tags = {"BUILDER", "INIT", "COPY", "SYNTH"},
      naming = "*",
      stdNaming = "NONE",
      type = "void",
      typeParams = {},
      params = {"value: java.util.Date"},
      doc = {},
      annotations = {},
      code = "{\nthis.@@compactDate_builder = @:fromDate(@^value);\n}",
      thrown = {}
    )
  }
)
public @interface CompactDateEnabled {}
