package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Canvas.Line Line} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableLine is not thread-safe</em>
 * @see ImmutableLine
 */
@Generated(from = "Canvas.Line", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Canvas.Line"})
@NotThreadSafe
public final class ModifiableLine implements Canvas.Line {
  private static final long INIT_BIT_COLOR = 0x1L;
  private long initBits = 0x1L;

  private final ArrayList<Canvas.Point> points = new ArrayList<Canvas.Point>();
  private ModifiableColor color;
  private Optional<Canvas.Color> shadow = Optional.empty();

  private ModifiableLine() {}

  /**
   * Construct a modifiable instance of {@code Line}.
   * @return A new modifiable instance
   */
  public static ModifiableLine create() {
    return new ModifiableLine();
  }

  /**
   * @return modifiable list {@code points}
   */
  @Override
  public final List<Canvas.Point> points() {
    return points;
  }

  /**
   * @return value of {@code color} attribute
   */
  @Override
  public final ModifiableColor color() {
    if (!colorIsSet()) {
      checkRequiredAttributes();
    }
    return color;
  }

  /**
   * @return value of {@code shadow} attribute
   */
  @Override
  public final Optional<Canvas.Color> shadow() {
    return shadow;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableLine clear() {
    initBits = 0x1L;
    points.clear();
    color = null;
    shadow = Optional.empty();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Canvas.Line} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableLine from(Canvas.Line instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableLine) {
      from((ModifiableLine) instance);
      return this;
    }
    addAllPoints(instance.points());
    setColor(instance.color());
    Optional<Canvas.Color> shadowOptional = instance.shadow();
    if (shadowOptional.isPresent()) {
      setShadow(shadowOptional);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Canvas.Line} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableLine from(ModifiableLine instance) {
    Objects.requireNonNull(instance, "instance");
    addAllPoints(instance.points());
    if (instance.colorIsSet()) {
      setColor(instance.color());
    }
    Optional<Canvas.Color> shadowOptional = instance.shadow();
    if (shadowOptional.isPresent()) {
      setShadow(shadowOptional);
    }
    return this;
  }

  /**
   * Adds one element to {@link Canvas.Line#points() points} list.
   * @param element The points element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableLine addPoint(Canvas.Point element) {
    Objects.requireNonNull(element, "points element");
    this.points.add(element instanceof ModifiablePoint ? element : ModifiablePoint.create().from(element));
    return this;
  }

  /**
   * Adds elements to {@link Canvas.Line#points() points} list.
   * @param elements An array of points elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableLine addPoints(Canvas.Point... elements) {
    for (Canvas.Point e : elements) {
      addPoint(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Canvas.Line#points() points} list.
   * @param elements An iterable of points elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableLine setPoints(Iterable<? extends Canvas.Point> elements) {
    this.points.clear();
    addAllPoints(elements);
    return this;
  }

  /**
   * Adds elements to {@link Canvas.Line#points() points} list.
   * @param elements An iterable of points elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableLine addAllPoints(Iterable<? extends Canvas.Point> elements) {
    for (Canvas.Point e : elements) {
      addPoint(e);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Canvas.Line#color() color} attribute.
   * @param color The value for color
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableLine setColor(Canvas.Color color) {
    this.color = (color instanceof ModifiableColor ? (ModifiableColor) color : ModifiableColor.create().from(color));
    initBits &= ~INIT_BIT_COLOR;
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@link Canvas.Line#shadow() shadow} attribute.
   * @param shadow A value for shadow
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableLine setShadow(Canvas.Color shadow) {
    this.shadow = Optional.of(shadow);
    return this;
  }

  /**
   * Assigns an optional value for {@link Canvas.Line#shadow() shadow}.
   * @param shadow A value for shadow
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableLine setShadow(Optional<Canvas.Color> shadow) {
    this.shadow = Objects.requireNonNull(shadow, "shadow");
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link Canvas.Line#color() color} is set.
   * @return {@code true} if set
   */
  public final boolean colorIsSet() {
    return (initBits & INIT_BIT_COLOR) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableLine unsetColor() {
    initBits |= INIT_BIT_COLOR;
    color = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!colorIsSet()) attributes.add("color");
    return "Line is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableLine ImmutableLine}.
   * @return An immutable instance of Line
   */
  public final ImmutableLine toImmutable() {
    checkRequiredAttributes();
    return ImmutableLine.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableLine} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableLine)) return false;
    ModifiableLine other = (ModifiableLine) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableLine another) {
    return points.equals(another.points)
        && color.equals(another.color)
        && Objects.equals(shadow, another.shadow);
  }

  /**
   * Computes a hash code from attributes: {@code points}, {@code color}, {@code shadow}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + points.hashCode();
    h += (h << 5) + color.hashCode();
    h += (h << 5) + shadow.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Line}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableLine")
        .add("points", points())
        .add("color", colorIsSet() ? color() : "?")
        .add("shadow", shadow())
        .toString();
  }
}
