package org.immutables.fixture.deep;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeepStepChild}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeepStepChild.builder()}.
 */
@Generated(from = "DeepStepChild", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDeepStepChild implements DeepStepChild {

  private ImmutableDeepStepChild(ImmutableDeepStepChild.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeepStepChild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeepStepChild
        && equalTo(0, (ImmutableDeepStepChild) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableDeepStepChild another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -2054225415;
  }

  /**
   * Prints the immutable value {@code DeepStepChild}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeepStepChild{}";
  }

  /**
   * Creates an immutable copy of a {@link DeepStepChild} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeepStepChild instance
   */
  public static ImmutableDeepStepChild copyOf(DeepStepChild instance) {
    if (instance instanceof ImmutableDeepStepChild) {
      return (ImmutableDeepStepChild) instance;
    }
    return ImmutableDeepStepChild.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeepStepChild ImmutableDeepStepChild}.
   * <pre>
   * ImmutableDeepStepChild.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableDeepStepChild builder
   */
  public static ImmutableDeepStepChild.Builder builder() {
    return new ImmutableDeepStepChild.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeepStepChild ImmutableDeepStepChild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeepStepChild", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeepStepChild} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DeepStepChild instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeepStepChild ImmutableDeepStepChild}.
     * @return An immutable instance of DeepStepChild
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeepStepChild build() {
      return new ImmutableDeepStepChild(this);
    }
  }
}
