package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Canvas.Color}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableColor.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableColor.of()}.
 */
@Generated(from = "Canvas.Color", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableColor implements Canvas.Color {
  private final double red;
  private final double green;
  private final double blue;

  private ImmutableColor(double red, double green, double blue) {
    this.red = red;
    this.green = green;
    this.blue = blue;
  }

  private ImmutableColor(ImmutableColor original, double red, double green, double blue) {
    this.red = red;
    this.green = green;
    this.blue = blue;
  }

  /**
   * @return The value of the {@code red} attribute
   */
  @Override
  public double red() {
    return red;
  }

  /**
   * @return The value of the {@code green} attribute
   */
  @Override
  public double green() {
    return green;
  }

  /**
   * @return The value of the {@code blue} attribute
   */
  @Override
  public double blue() {
    return blue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Canvas.Color#red() red} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for red
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColor withRed(double value) {
    if (Double.doubleToLongBits(this.red) == Double.doubleToLongBits(value)) return this;
    return new ImmutableColor(this, value, this.green, this.blue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Canvas.Color#green() green} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for green
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColor withGreen(double value) {
    if (Double.doubleToLongBits(this.green) == Double.doubleToLongBits(value)) return this;
    return new ImmutableColor(this, this.red, value, this.blue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Canvas.Color#blue() blue} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableColor withBlue(double value) {
    if (Double.doubleToLongBits(this.blue) == Double.doubleToLongBits(value)) return this;
    return new ImmutableColor(this, this.red, this.green, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableColor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableColor
        && equalTo(0, (ImmutableColor) another);
  }

  private boolean equalTo(int synthetic, ImmutableColor another) {
    return Double.doubleToLongBits(red) == Double.doubleToLongBits(another.red)
        && Double.doubleToLongBits(green) == Double.doubleToLongBits(another.green)
        && Double.doubleToLongBits(blue) == Double.doubleToLongBits(another.blue);
  }

  /**
   * Computes a hash code from attributes: {@code red}, {@code green}, {@code blue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Doubles.hashCode(red);
    h += (h << 5) + Doubles.hashCode(green);
    h += (h << 5) + Doubles.hashCode(blue);
    return h;
  }

  /**
   * Prints the immutable value {@code Color} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Color")
        .omitNullValues()
        .add("red", red)
        .add("green", green)
        .add("blue", blue)
        .toString();
  }

  /**
   * Construct a new immutable {@code Color} instance.
   * @param red The value for the {@code red} attribute
   * @param green The value for the {@code green} attribute
   * @param blue The value for the {@code blue} attribute
   * @return An immutable Color instance
   */
  public static ImmutableColor of(double red, double green, double blue) {
    return new ImmutableColor(red, green, blue);
  }

  /**
   * Creates an immutable copy of a {@link Canvas.Color} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Color instance
   */
  public static ImmutableColor copyOf(Canvas.Color instance) {
    if (instance instanceof ImmutableColor) {
      return (ImmutableColor) instance;
    }
    return ImmutableColor.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableColor ImmutableColor}.
   * <pre>
   * ImmutableColor.builder()
   *    .red(double) // required {@link Canvas.Color#red() red}
   *    .green(double) // required {@link Canvas.Color#green() green}
   *    .blue(double) // required {@link Canvas.Color#blue() blue}
   *    .build();
   * </pre>
   * @return A new ImmutableColor builder
   */
  public static ImmutableColor.Builder builder() {
    return new ImmutableColor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableColor ImmutableColor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Canvas.Color", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_RED = 0x1L;
    private static final long INIT_BIT_GREEN = 0x2L;
    private static final long INIT_BIT_BLUE = 0x4L;
    private long initBits = 0x7L;

    private double red;
    private double green;
    private double blue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableColor} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableColor instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.redIsSet()) {
        red(instance.red());
      }
      if (instance.greenIsSet()) {
        green(instance.green());
      }
      if (instance.blueIsSet()) {
        blue(instance.blue());
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Color} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Canvas.Color instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableColor) {
        return from((ModifiableColor) instance);
      }
      red(instance.red());
      green(instance.green());
      blue(instance.blue());
      return this;
    }

    /**
     * Initializes the value for the {@link Canvas.Color#red() red} attribute.
     * @param red The value for red 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder red(double red) {
      this.red = red;
      initBits &= ~INIT_BIT_RED;
      return this;
    }

    /**
     * Initializes the value for the {@link Canvas.Color#green() green} attribute.
     * @param green The value for green 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder green(double green) {
      this.green = green;
      initBits &= ~INIT_BIT_GREEN;
      return this;
    }

    /**
     * Initializes the value for the {@link Canvas.Color#blue() blue} attribute.
     * @param blue The value for blue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blue(double blue) {
      this.blue = blue;
      initBits &= ~INIT_BIT_BLUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableColor ImmutableColor}.
     * @return An immutable instance of Color
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableColor build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableColor(null, red, green, blue);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RED) != 0) attributes.add("red");
      if ((initBits & INIT_BIT_GREEN) != 0) attributes.add("green");
      if ((initBits & INIT_BIT_BLUE) != 0) attributes.add("blue");
      return "Cannot build Color, some of required attributes are not set " + attributes;
    }
  }
}
