package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableCircular} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link Circular}.
 * @see ImmutableCircular.A
 * @see ImmutableCircular.B
 */
@Generated(from = "Circular", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCircular {
  private ImmutableCircular() {}

  /**
   * Immutable implementation of {@link Circular.A}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableCircular.A.builder()}.
   */
  @Generated(from = "Circular.A", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class A implements Circular.A {
    private final ImmutableCircular.B b;

    private A(ImmutableCircular.B b) {
      this.b = b;
    }

    /**
     * @return The value of the {@code b} attribute
     */
    @Override
    public ImmutableCircular.B getB() {
      return b;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Circular.A#getB() b} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for b
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableCircular.A withB(Circular.B value) {
      if (this.b == value) return this;
      ImmutableCircular.B newValue = ImmutableCircular.B.copyOf(value);
      return new ImmutableCircular.A(newValue);
    }

    /**
     * This instance is equal to all instances of {@code A} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableCircular.A
          && equalTo(0, (ImmutableCircular.A) another);
    }

    private boolean equalTo(int synthetic, ImmutableCircular.A another) {
      return b.equals(another.b);
    }

    /**
     * Computes a hash code from attributes: {@code b}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + b.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code A} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("A")
          .omitNullValues()
          .add("b", b)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Circular.A} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable A instance
     */
    public static ImmutableCircular.A copyOf(Circular.A instance) {
      if (instance instanceof ImmutableCircular.A) {
        return (ImmutableCircular.A) instance;
      }
      return ImmutableCircular.A.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableCircular.A A}.
     * <pre>
     * ImmutableCircular.A.builder()
     *    .b(org.immutables.fixture.deep.Circular.B) // required {@link Circular.A#getB() b}
     *    .build();
     * </pre>
     * @return A new A builder
     */
    public static ImmutableCircular.A.Builder builder() {
      return new ImmutableCircular.A.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableCircular.A A}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Circular.A", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_B = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Circular.B b;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code A} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(Circular.A instance) {
        Objects.requireNonNull(instance, "instance");
        b(instance.getB());
        return this;
      }

      /**
       * Initializes the value for the {@link Circular.A#getB() b} attribute.
       * @param b The value for b 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder b(Circular.B b) {
        this.b = ImmutableCircular.B.copyOf(b);
        initBits &= ~INIT_BIT_B;
        return this;
      }

      /**
       * Builds a new {@link ImmutableCircular.A A}.
       * @return An immutable instance of A
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableCircular.A build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableCircular.A(ImmutableCircular.B.copyOf(b));
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
        return "Cannot build A, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Circular.B}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableCircular.B.builder()}.
   */
  @Generated(from = "Circular.B", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class B implements Circular.B {
    private final ImmutableCircular.A a;

    private B(ImmutableCircular.A a) {
      this.a = a;
    }

    /**
     * @return The value of the {@code a} attribute
     */
    @Override
    public ImmutableCircular.A getA() {
      return a;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Circular.B#getA() a} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableCircular.B withA(Circular.A value) {
      if (this.a == value) return this;
      ImmutableCircular.A newValue = ImmutableCircular.A.copyOf(value);
      return new ImmutableCircular.B(newValue);
    }

    /**
     * This instance is equal to all instances of {@code B} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableCircular.B
          && equalTo(0, (ImmutableCircular.B) another);
    }

    private boolean equalTo(int synthetic, ImmutableCircular.B another) {
      return a.equals(another.a);
    }

    /**
     * Computes a hash code from attributes: {@code a}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + a.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code B} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("B")
          .omitNullValues()
          .add("a", a)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Circular.B} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable B instance
     */
    public static ImmutableCircular.B copyOf(Circular.B instance) {
      if (instance instanceof ImmutableCircular.B) {
        return (ImmutableCircular.B) instance;
      }
      return ImmutableCircular.B.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableCircular.B B}.
     * <pre>
     * ImmutableCircular.B.builder()
     *    .a(org.immutables.fixture.deep.Circular.A) // required {@link Circular.B#getA() a}
     *    .build();
     * </pre>
     * @return A new B builder
     */
    public static ImmutableCircular.B.Builder builder() {
      return new ImmutableCircular.B.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableCircular.B B}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Circular.B", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_A = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Circular.A a;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code B} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder from(Circular.B instance) {
        Objects.requireNonNull(instance, "instance");
        a(instance.getA());
        return this;
      }

      /**
       * Initializes the value for the {@link Circular.B#getA() a} attribute.
       * @param a The value for a 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Builder a(Circular.A a) {
        this.a = ImmutableCircular.A.copyOf(a);
        initBits &= ~INIT_BIT_A;
        return this;
      }

      /**
       * Builds a new {@link ImmutableCircular.B B}.
       * @return An immutable instance of B
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableCircular.B build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableCircular.B(ImmutableCircular.A.copyOf(a));
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
        return "Cannot build B, some of required attributes are not set " + attributes;
      }
    }
  }
}
