package org.immutables.fixture.couse.sub;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HasEnumOtherPackage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHasEnumOtherPackage.builder()}.
 */
@Generated(from = "HasEnumOtherPackage", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHasEnumOtherPackage
    implements HasEnumOtherPackage {
  private final HasEnumOtherPackage.Type type;

  private ImmutableHasEnumOtherPackage(HasEnumOtherPackage.Type type) {
    this.type = type;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public HasEnumOtherPackage.Type getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HasEnumOtherPackage#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHasEnumOtherPackage withType(HasEnumOtherPackage.Type value) {
    HasEnumOtherPackage.Type newValue = Objects.requireNonNull(value, "type");
    if (this.type == newValue) return this;
    return new ImmutableHasEnumOtherPackage(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHasEnumOtherPackage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHasEnumOtherPackage
        && equalTo(0, (ImmutableHasEnumOtherPackage) another);
  }

  private boolean equalTo(int synthetic, ImmutableHasEnumOtherPackage another) {
    return type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HasEnumOtherPackage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HasEnumOtherPackage")
        .omitNullValues()
        .add("type", type)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link HasEnumOtherPackage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HasEnumOtherPackage instance
   */
  public static ImmutableHasEnumOtherPackage copyOf(HasEnumOtherPackage instance) {
    if (instance instanceof ImmutableHasEnumOtherPackage) {
      return (ImmutableHasEnumOtherPackage) instance;
    }
    return ImmutableHasEnumOtherPackage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHasEnumOtherPackage ImmutableHasEnumOtherPackage}.
   * <pre>
   * ImmutableHasEnumOtherPackage.builder()
   *    .type(org.immutables.fixture.couse.sub.HasEnumOtherPackage.Type) // required {@link HasEnumOtherPackage#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableHasEnumOtherPackage builder
   */
  public static ImmutableHasEnumOtherPackage.Builder builder() {
    return new ImmutableHasEnumOtherPackage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHasEnumOtherPackage ImmutableHasEnumOtherPackage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HasEnumOtherPackage", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable HasEnumOtherPackage.Type type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HasEnumOtherPackage} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HasEnumOtherPackage instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link HasEnumOtherPackage#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(HasEnumOtherPackage.Type type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHasEnumOtherPackage ImmutableHasEnumOtherPackage}.
     * @return An immutable instance of HasEnumOtherPackage
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHasEnumOtherPackage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHasEnumOtherPackage(type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build HasEnumOtherPackage, some of required attributes are not set " + attributes;
    }
  }
}
