package org.immutables.fixture.couse;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NotYetGeneratedGenericsInDefaultInitializer.ToBeGenX}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableToBeGenX.builder()}.
 */
@Generated(from = "NotYetGeneratedGenericsInDefaultInitializer.ToBeGenX", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableToBeGenX<X, Y>
    implements NotYetGeneratedGenericsInDefaultInitializer.ToBeGenX<X, Y> {

  private ImmutableToBeGenX(ImmutableToBeGenX.Builder<X, Y> builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableToBeGenX} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableToBeGenX<?, ?>
        && equalTo(0, (ImmutableToBeGenX<?, ?>) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableToBeGenX<?, ?> another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 131777410;
  }

  /**
   * Prints the immutable value {@code ToBeGenX}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ToBeGenX{}";
  }

  /**
   * Creates an immutable copy of a {@link NotYetGeneratedGenericsInDefaultInitializer.ToBeGenX} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <X> generic parameter X
   * @param <Y> generic parameter Y
   * @param instance The instance to copy
   * @return A copied immutable ToBeGenX instance
   */
  public static <X, Y> ImmutableToBeGenX<X, Y> copyOf(NotYetGeneratedGenericsInDefaultInitializer.ToBeGenX<X, Y> instance) {
    if (instance instanceof ImmutableToBeGenX<?, ?>) {
      return (ImmutableToBeGenX<X, Y>) instance;
    }
    return ImmutableToBeGenX.<X, Y>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableToBeGenX ImmutableToBeGenX}.
   * <pre>
   * ImmutableToBeGenX.&amp;lt;X, Y&amp;gt;builder()
   *    .build();
   * </pre>
   * @param <X> generic parameter X
   * @param <Y> generic parameter Y
   * @return A new ImmutableToBeGenX builder
   */
  public static <X, Y> ImmutableToBeGenX.Builder<X, Y> builder() {
    return new ImmutableToBeGenX.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableToBeGenX ImmutableToBeGenX}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NotYetGeneratedGenericsInDefaultInitializer.ToBeGenX", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<X, Y> {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ToBeGenX} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<X, Y> from(NotYetGeneratedGenericsInDefaultInitializer.ToBeGenX<X, Y> instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableToBeGenX ImmutableToBeGenX}.
     * @return An immutable instance of ToBeGenX
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableToBeGenX<X, Y> build() {
      return new ImmutableToBeGenX<X, Y>(this);
    }
  }
}
