package org.immutables.fixture.builder.attribute_builders;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.functional.AttributeBuilderValueI;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SamePackageVanillaAttributeBuilderParent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new SamePackageVanillaAttributeBuilderParent.Builder()}.
 */
@Generated(from = "SamePackageVanillaAttributeBuilderParent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSamePackageVanillaAttributeBuilderParent
    extends SamePackageVanillaAttributeBuilderParent {
  private final ImmutableFirstPartyImmutable firstPartyImmutable;
  private final ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle;
  private final ImmutableList<FirstPartyImmutable> firstPartyImmutableList;
  private final ThirdPartyImmutable thirdPartyImmutable;
  private final ImmutableList<ThirdPartyImmutable> thirdPartyImmutableList;
  private final ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive;
  private final @Nullable FirstPartyImmutable optionalFirstPartyImmutable;
  private final @Nullable ImmutableFirstPartyImmutable nullableFirstPartyImmutable;

  private ImmutableSamePackageVanillaAttributeBuilderParent(
      ImmutableFirstPartyImmutable firstPartyImmutable,
      ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle,
      ImmutableList<FirstPartyImmutable> firstPartyImmutableList,
      ThirdPartyImmutable thirdPartyImmutable,
      ImmutableList<ThirdPartyImmutable> thirdPartyImmutableList,
      ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive,
      @Nullable FirstPartyImmutable optionalFirstPartyImmutable,
      @Nullable ImmutableFirstPartyImmutable nullableFirstPartyImmutable) {
    this.firstPartyImmutable = firstPartyImmutable;
    this.firstPartyImmutableWithDifferentStyle = firstPartyImmutableWithDifferentStyle;
    this.firstPartyImmutableList = firstPartyImmutableList;
    this.thirdPartyImmutable = thirdPartyImmutable;
    this.thirdPartyImmutableList = thirdPartyImmutableList;
    this.thirdPartyImmutableWithPrimitive = thirdPartyImmutableWithPrimitive;
    this.optionalFirstPartyImmutable = optionalFirstPartyImmutable;
    this.nullableFirstPartyImmutable = nullableFirstPartyImmutable;
  }

  /**
   * @return The value of the {@code firstPartyImmutable} attribute
   */
  @Override
  public ImmutableFirstPartyImmutable firstPartyImmutable() {
    return firstPartyImmutable;
  }

  /**
   * @return The value of the {@code firstPartyImmutableWithDifferentStyle} attribute
   */
  @Override
  public ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle() {
    return firstPartyImmutableWithDifferentStyle;
  }

  /**
   * @return The value of the {@code firstPartyImmutableList} attribute
   */
  @Override
  public ImmutableList<FirstPartyImmutable> firstPartyImmutableList() {
    return firstPartyImmutableList;
  }

  /**
   * @return The value of the {@code thirdPartyImmutable} attribute
   */
  @Override
  public ThirdPartyImmutable thirdPartyImmutable() {
    return thirdPartyImmutable;
  }

  /**
   * @return The value of the {@code thirdPartyImmutableList} attribute
   */
  @Override
  public ImmutableList<ThirdPartyImmutable> thirdPartyImmutableList() {
    return thirdPartyImmutableList;
  }

  /**
   * @return The value of the {@code thirdPartyImmutableWithPrimitive} attribute
   */
  @Override
  public ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive() {
    return thirdPartyImmutableWithPrimitive;
  }

  /**
   * @return The value of the {@code optionalFirstPartyImmutable} attribute
   */
  @Override
  public Optional<FirstPartyImmutable> optionalFirstPartyImmutable() {
    return Optional.ofNullable(optionalFirstPartyImmutable);
  }

  /**
   * @return The value of the {@code nullableFirstPartyImmutable} attribute
   */
  @Override
  public @Nullable ImmutableFirstPartyImmutable nullableFirstPartyImmutable() {
    return nullableFirstPartyImmutable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstPartyImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withFirstPartyImmutable(FirstPartyImmutable value) {
    if (this.firstPartyImmutable == value) return this;
    ImmutableFirstPartyImmutable newValue = ImmutableFirstPartyImmutable.builder().from(value).build();
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        newValue,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstPartyImmutableWithDifferentStyle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withFirstPartyImmutableWithDifferentStyle(FirstPartyImmutableWithDifferentStyle value) {
    if (this.firstPartyImmutableWithDifferentStyle == value) return this;
    ImmutableFirstPartyImmutableWithDifferentStyle newValue = ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        newValue,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withFirstPartyImmutableList(FirstPartyImmutable... elements) {
    ImmutableList<FirstPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        newValue,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of firstPartyImmutableList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withFirstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
    if (this.firstPartyImmutableList == elements) return this;
    ImmutableList<FirstPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        newValue,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdPartyImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withThirdPartyImmutable(ThirdPartyImmutable value) {
    if (this.thirdPartyImmutable == value) return this;
    ThirdPartyImmutable newValue = Objects.requireNonNull(value, "thirdPartyImmutable");
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        newValue,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withThirdPartyImmutableList(ThirdPartyImmutable... elements) {
    ImmutableList<ThirdPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        newValue,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of thirdPartyImmutableList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withThirdPartyImmutableList(Iterable<? extends ThirdPartyImmutable> elements) {
    if (this.thirdPartyImmutableList == elements) return this;
    ImmutableList<ThirdPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        newValue,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdPartyImmutableWithPrimitive
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withThirdPartyImmutableWithPrimitive(ThirdPartyImmutableWithPrimitive value) {
    if (this.thirdPartyImmutableWithPrimitive == value) return this;
    ThirdPartyImmutableWithPrimitive newValue = Objects.requireNonNull(value, "thirdPartyImmutableWithPrimitive");
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        newValue,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SamePackageVanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} attribute.
   * @param value The value for optionalFirstPartyImmutable
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withOptionalFirstPartyImmutable(FirstPartyImmutable value) {
    FirstPartyImmutable newValue = Objects.requireNonNull(value, "optionalFirstPartyImmutable");
    if (this.optionalFirstPartyImmutable == newValue) return this;
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        newValue,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SamePackageVanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optionalFirstPartyImmutable
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableSamePackageVanillaAttributeBuilderParent withOptionalFirstPartyImmutable(Optional<? extends FirstPartyImmutable> optional) {
    @Nullable FirstPartyImmutable value = optional.orElse(null);
    if (this.optionalFirstPartyImmutable == value) return this;
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        value,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SamePackageVanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullableFirstPartyImmutable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSamePackageVanillaAttributeBuilderParent withNullableFirstPartyImmutable(@Nullable FirstPartyImmutable value) {
    if (this.nullableFirstPartyImmutable == value) return this;
    @Nullable ImmutableFirstPartyImmutable newValue = ImmutableFirstPartyImmutable.builder().from(value).build();
    return new ImmutableSamePackageVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSamePackageVanillaAttributeBuilderParent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSamePackageVanillaAttributeBuilderParent
        && equalTo(0, (ImmutableSamePackageVanillaAttributeBuilderParent) another);
  }

  private boolean equalTo(int synthetic, ImmutableSamePackageVanillaAttributeBuilderParent another) {
    return firstPartyImmutable.equals(another.firstPartyImmutable)
        && firstPartyImmutableWithDifferentStyle.equals(another.firstPartyImmutableWithDifferentStyle)
        && firstPartyImmutableList.equals(another.firstPartyImmutableList)
        && thirdPartyImmutable.equals(another.thirdPartyImmutable)
        && thirdPartyImmutableList.equals(another.thirdPartyImmutableList)
        && thirdPartyImmutableWithPrimitive.equals(another.thirdPartyImmutableWithPrimitive)
        && Objects.equals(optionalFirstPartyImmutable, another.optionalFirstPartyImmutable)
        && Objects.equals(nullableFirstPartyImmutable, another.nullableFirstPartyImmutable);
  }

  /**
   * Computes a hash code from attributes: {@code firstPartyImmutable}, {@code firstPartyImmutableWithDifferentStyle}, {@code firstPartyImmutableList}, {@code thirdPartyImmutable}, {@code thirdPartyImmutableList}, {@code thirdPartyImmutableWithPrimitive}, {@code optionalFirstPartyImmutable}, {@code nullableFirstPartyImmutable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + firstPartyImmutable.hashCode();
    h += (h << 5) + firstPartyImmutableWithDifferentStyle.hashCode();
    h += (h << 5) + firstPartyImmutableList.hashCode();
    h += (h << 5) + thirdPartyImmutable.hashCode();
    h += (h << 5) + thirdPartyImmutableList.hashCode();
    h += (h << 5) + thirdPartyImmutableWithPrimitive.hashCode();
    h += (h << 5) + Objects.hashCode(optionalFirstPartyImmutable);
    h += (h << 5) + Objects.hashCode(nullableFirstPartyImmutable);
    return h;
  }

  /**
   * Prints the immutable value {@code SamePackageVanillaAttributeBuilderParent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SamePackageVanillaAttributeBuilderParent")
        .omitNullValues()
        .add("firstPartyImmutable", firstPartyImmutable)
        .add("firstPartyImmutableWithDifferentStyle", firstPartyImmutableWithDifferentStyle)
        .add("firstPartyImmutableList", firstPartyImmutableList)
        .add("thirdPartyImmutable", thirdPartyImmutable)
        .add("thirdPartyImmutableList", thirdPartyImmutableList)
        .add("thirdPartyImmutableWithPrimitive", thirdPartyImmutableWithPrimitive)
        .add("optionalFirstPartyImmutable", optionalFirstPartyImmutable)
        .add("nullableFirstPartyImmutable", nullableFirstPartyImmutable)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SamePackageVanillaAttributeBuilderParent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SamePackageVanillaAttributeBuilderParent instance
   */
  public static ImmutableSamePackageVanillaAttributeBuilderParent copyOf(SamePackageVanillaAttributeBuilderParent instance) {
    if (instance instanceof ImmutableSamePackageVanillaAttributeBuilderParent) {
      return (ImmutableSamePackageVanillaAttributeBuilderParent) instance;
    }
    return new SamePackageVanillaAttributeBuilderParent.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableSamePackageVanillaAttributeBuilderParent ImmutableSamePackageVanillaAttributeBuilderParent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SamePackageVanillaAttributeBuilderParent", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_FIRST_PARTY_IMMUTABLE = 0x1L;
    private static final long INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE = 0x2L;
    private static final long INIT_BIT_THIRD_PARTY_IMMUTABLE = 0x4L;
    private static final long INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable ImmutableFirstPartyImmutable.Builder firstPartyImmutable;
    private @Nullable ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyle;
    private ImmutableList.Builder<ImmutableFirstPartyImmutable.Builder> firstPartyImmutableList = ImmutableList.builder();
    private @Nullable ThirdPartyImmutable.Builder thirdPartyImmutable;
    private ImmutableList.Builder<ThirdPartyImmutable.Builder> thirdPartyImmutableList = ImmutableList.builder();
    private @Nullable ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitive;
    private @Nullable ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutable;
    private @Nullable ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutable;

    /**
     * Creates a builder for {@link ImmutableSamePackageVanillaAttributeBuilderParent ImmutableSamePackageVanillaAttributeBuilderParent} instances.
     * <pre>
     * new SamePackageVanillaAttributeBuilderParent.Builder()
     *    .firstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // required {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable}
     *    .firstPartyImmutableWithDifferentStyle(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutableWithDifferentStyle) // required {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle}
     *    .addFirstPartyImmutable|addAllFirstPartyImmutableList(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} elements
     *    .thirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable) // required {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable}
     *    .addThirdPartyImmutable|addAllThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable) // {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} elements
     *    .thirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive) // required {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive}
     *    .optionalFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // optional {@link SamePackageVanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable}
     *    .nullableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable | null) // nullable {@link SamePackageVanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof SamePackageVanillaAttributeBuilderParent.Builder)) {
        throw new UnsupportedOperationException("Use: new SamePackageVanillaAttributeBuilderParent.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.functional.AttributeBuilderValueI} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder from(AttributeBuilderValueI instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.attribute_builders.SamePackageVanillaAttributeBuilderParent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder from(SamePackageVanillaAttributeBuilderParent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof AttributeBuilderValueI) {
        AttributeBuilderValueI instance = (AttributeBuilderValueI) object;
        firstPartyImmutableWithDifferentStyle(instance.firstPartyImmutableWithDifferentStyle());
        thirdPartyImmutableWithPrimitive(instance.thirdPartyImmutableWithPrimitive());
        firstPartyImmutable(instance.firstPartyImmutable());
        @Nullable FirstPartyImmutable nullableFirstPartyImmutableValue = instance.nullableFirstPartyImmutable();
        if (nullableFirstPartyImmutableValue != null) {
          nullableFirstPartyImmutable(nullableFirstPartyImmutableValue);
        }
        addAllThirdPartyImmutableList(instance.thirdPartyImmutableList());
        addAllFirstPartyImmutableList(instance.firstPartyImmutableList());
        thirdPartyImmutable(instance.thirdPartyImmutable());
        Optional<FirstPartyImmutable> optionalFirstPartyImmutableOptional = instance.optionalFirstPartyImmutable();
        if (optionalFirstPartyImmutableOptional.isPresent()) {
          optionalFirstPartyImmutable(optionalFirstPartyImmutableOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} attribute.
     * @param firstPartyImmutable The value for firstPartyImmutable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder firstPartyImmutable(FirstPartyImmutable firstPartyImmutable) {
      this.firstPartyImmutable = ImmutableFirstPartyImmutable.builder().from(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutable));
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final ImmutableFirstPartyImmutable.Builder firstPartyImmutableBuilder() {
      if (this.firstPartyImmutable == null) {
        this.firstPartyImmutable = ImmutableFirstPartyImmutable.builder();
      }
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;

      return this.firstPartyImmutable;
    }

    /**
     * Sets {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder firstPartyImmutableBuilder(ImmutableFirstPartyImmutable.Builder firstPartyImmutable) {
      this.firstPartyImmutable = firstPartyImmutable;
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} attribute.
     * @param firstPartyImmutableWithDifferentStyle The value for firstPartyImmutableWithDifferentStyle 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder firstPartyImmutableWithDifferentStyle(FirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle) {
      this.firstPartyImmutableWithDifferentStyle = ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(firstPartyImmutableWithDifferentStyle));
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyleBuilder() {
      if (this.firstPartyImmutableWithDifferentStyle == null) {
        this.firstPartyImmutableWithDifferentStyle = ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder();
      }
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;

      return this.firstPartyImmutableWithDifferentStyle;
    }

    /**
     * Sets {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder firstPartyImmutableWithDifferentStyleBuilder(ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyle) {
      this.firstPartyImmutableWithDifferentStyle = firstPartyImmutableWithDifferentStyle;
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds one element to {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param element A firstPartyImmutableList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addFirstPartyImmutable(FirstPartyImmutable element) {
      element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
      this.firstPartyImmutableList.add(ImmutableFirstPartyImmutable.builder().from(element));
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An array of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addFirstPartyImmutableList(FirstPartyImmutable... elements) {
      for (FirstPartyImmutable element : elements) {
        element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
        this.firstPartyImmutableList.add(ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      }
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds a new builder to the {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list and returns
     * the builder.
     */
    @CanIgnoreReturnValue 
    public final ImmutableFirstPartyImmutable.Builder addFirstPartyImmutableBuilder() {
      ImmutableFirstPartyImmutable.Builder builder = ImmutableFirstPartyImmutable.builder();
      this.firstPartyImmutableList.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An array of firstPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addAllFirstPartyImmutableBuilders(ImmutableFirstPartyImmutable.Builder... elements) {
      for (ImmutableFirstPartyImmutable.Builder element : elements) {
        this.firstPartyImmutableList.add(Objects.requireNonNull(element, "firstPartyImmutableList element"));
      }
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Gets the builder elements to {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableFirstPartyImmutable.Builder> firstPartyImmutableBuilders() {
      return this.firstPartyImmutableList.build();
    }

    /**
     * Sets or replaces all elements for {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder firstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
      this.firstPartyImmutableList = ImmutableList.builder();
      return addAllFirstPartyImmutableList(elements);
    }

    /**
     * Adds elements to {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addAllFirstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
      for (FirstPartyImmutable element : elements) {
        element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
        this.firstPartyImmutableList.add(ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      }
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link SamePackageVanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addAllFirstPartyImmutableBuilders(Iterable<ImmutableFirstPartyImmutable.Builder> elements) {
      for (ImmutableFirstPartyImmutable.Builder element : elements) {
        this.firstPartyImmutableList.add(Objects.requireNonNull(element, "firstPartyImmutableList element"));
      }
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} attribute.
     * @param thirdPartyImmutable The value for thirdPartyImmutable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder thirdPartyImmutable(ThirdPartyImmutable thirdPartyImmutable) {
      this.thirdPartyImmutable = ThirdPartyImmutable.generateNewBuilder(Objects.requireNonNull(thirdPartyImmutable, "thirdPartyImmutable"));
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final ThirdPartyImmutable.Builder thirdPartyImmutableBuilder() {
      if (this.thirdPartyImmutable == null) {
        this.thirdPartyImmutable = ThirdPartyImmutable.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;

      return this.thirdPartyImmutable;
    }

    /**
     * Sets {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder thirdPartyImmutableBuilder(ThirdPartyImmutable.Builder thirdPartyImmutable) {
      this.thirdPartyImmutable = thirdPartyImmutable;
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds one element to {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param element A thirdPartyImmutableList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addThirdPartyImmutable(ThirdPartyImmutable element) {
      this.thirdPartyImmutableList.add(ThirdPartyImmutable.generateNewBuilder(element));
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An array of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addThirdPartyImmutableList(ThirdPartyImmutable... elements) {
      this.thirdPartyImmutableList.addAll(convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(elements));
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds a new builder to the {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list and returns
     * the builder.
     */
    @CanIgnoreReturnValue 
    public final ThirdPartyImmutable.Builder addThirdPartyImmutableBuilder() {
      ThirdPartyImmutable.Builder builder = ThirdPartyImmutable.generateNewBuilder();
      this.thirdPartyImmutableList.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An array of thirdPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addAllThirdPartyImmutableBuilders(ThirdPartyImmutable.Builder... elements) {
      this.thirdPartyImmutableList.add(elements);
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Gets the builder elements to {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ThirdPartyImmutable.Builder> thirdPartyImmutableBuilders() {
      return this.thirdPartyImmutableList.build();
    }

    /**
     * Sets or replaces all elements for {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder thirdPartyImmutableList(Iterable<? extends ThirdPartyImmutable> elements) {
      this.thirdPartyImmutableList = ImmutableList.builder();
      return addAllThirdPartyImmutableList(elements);
    }

    /**
     * Adds elements to {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addAllThirdPartyImmutableList(Iterable<? extends ThirdPartyImmutable> elements) {
      this.thirdPartyImmutableList.addAll(convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(elements));
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder addAllThirdPartyImmutableBuilders(Iterable<ThirdPartyImmutable.Builder> elements) {
      this.thirdPartyImmutableList.addAll(elements);
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} attribute.
     * @param thirdPartyImmutableWithPrimitive The value for thirdPartyImmutableWithPrimitive 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder thirdPartyImmutableWithPrimitive(ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive) {
      this.thirdPartyImmutableWithPrimitive = ThirdPartyImmutableWithPrimitive.generateNewBuilder(Objects.requireNonNull(thirdPartyImmutableWithPrimitive, "thirdPartyImmutableWithPrimitive"));
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitiveBuilder() {
      if (this.thirdPartyImmutableWithPrimitive == null) {
        this.thirdPartyImmutableWithPrimitive = ThirdPartyImmutableWithPrimitive.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;

      return this.thirdPartyImmutableWithPrimitive;
    }

    /**
     * Sets {@link SamePackageVanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder thirdPartyImmutableWithPrimitiveBuilder(ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitive) {
      this.thirdPartyImmutableWithPrimitive = thirdPartyImmutableWithPrimitive;
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the optional value {@link SamePackageVanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to optionalFirstPartyImmutable.
     * @param optionalFirstPartyImmutable The value for optionalFirstPartyImmutable
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder optionalFirstPartyImmutable(FirstPartyImmutable optionalFirstPartyImmutable) {
      this.optionalFirstPartyImmutable = ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(optionalFirstPartyImmutable, "optionalFirstPartyImmutable"));
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

      /**
       * Returns a builder for {@link SamePackageVanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable}.
       *
       * Once called, the attribute builder field is set to a new instance of the builder.
       * If called more than once, returns the same builder instance.
       */
      public final ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutableBuilder() {
        if (this.optionalFirstPartyImmutable == null) {
          this.optionalFirstPartyImmutable = ImmutableFirstPartyImmutable.builder();
        }

        return this.optionalFirstPartyImmutable;
      }

      /**
       * Sets {@link SamePackageVanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to the provided builder.
       */
      @CanIgnoreReturnValue 
      public final SamePackageVanillaAttributeBuilderParent.Builder optionalFirstPartyImmutableBuilder(ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutable) {
        this.optionalFirstPartyImmutable = optionalFirstPartyImmutable;
        return (SamePackageVanillaAttributeBuilderParent.Builder) this;
      }

    /**
     * Initializes the optional value {@link SamePackageVanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to optionalFirstPartyImmutable.
     * @param optionalFirstPartyImmutable The value for optionalFirstPartyImmutable
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder optionalFirstPartyImmutable(Optional<? extends FirstPartyImmutable> optionalFirstPartyImmutable) {
      this.optionalFirstPartyImmutable = convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(optionalFirstPartyImmutable.orElse(null));
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link SamePackageVanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} attribute.
     * @param nullableFirstPartyImmutable The value for nullableFirstPartyImmutable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder nullableFirstPartyImmutable(@Nullable FirstPartyImmutable nullableFirstPartyImmutable) {
      this.nullableFirstPartyImmutable = ImmutableFirstPartyImmutable.builder().from(nullableFirstPartyImmutable == null ? null : convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(nullableFirstPartyImmutable));
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link SamePackageVanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutableBuilder() {
      if (this.nullableFirstPartyImmutable == null) {
        this.nullableFirstPartyImmutable = ImmutableFirstPartyImmutable.builder();
      }

      return this.nullableFirstPartyImmutable;
    }

    /**
     * Sets {@link SamePackageVanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final SamePackageVanillaAttributeBuilderParent.Builder nullableFirstPartyImmutableBuilder(@Nullable ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutable) {
      this.nullableFirstPartyImmutable = nullableFirstPartyImmutable;
      return (SamePackageVanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableSamePackageVanillaAttributeBuilderParent ImmutableSamePackageVanillaAttributeBuilderParent}.
     * @return An immutable instance of SamePackageVanillaAttributeBuilderParent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSamePackageVanillaAttributeBuilderParent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSamePackageVanillaAttributeBuilderParent(
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutable),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(firstPartyImmutableWithDifferentStyle),
          ImmutableList.copyOf(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutableList.build())),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(thirdPartyImmutable),
          ImmutableList.copyOf(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(thirdPartyImmutableList.build())),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(thirdPartyImmutableWithPrimitive),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(optionalFirstPartyImmutable),
          nullableFirstPartyImmutable == null ? null : convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(nullableFirstPartyImmutable));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIRST_PARTY_IMMUTABLE) != 0) attributes.add("firstPartyImmutable");
      if ((initBits & INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE) != 0) attributes.add("firstPartyImmutableWithDifferentStyle");
      if ((initBits & INIT_BIT_THIRD_PARTY_IMMUTABLE) != 0) attributes.add("thirdPartyImmutable");
      if ((initBits & INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE) != 0) attributes.add("thirdPartyImmutableWithPrimitive");
      return "Cannot build SamePackageVanillaAttributeBuilderParent, some of required attributes are not set " + attributes;
    }



    @Nullable 
    private static ImmutableFirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  ImmutableFirstPartyImmutable.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static FirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
      if (value == null) return null;
      return ImmutableFirstPartyImmutable.builder().from(value).build();
    }

    @Nullable 
    private static ImmutableFirstPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
      if (value == null) return null;
      return ImmutableFirstPartyImmutable.builder().from(value);
    }

    @Nullable 
    private static ImmutableFirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon builder) {
      if (builder == null) return null;
      return builder.doIIT();
    }

    @Nullable 
    private static FirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
      if (value == null) return null;
      return ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
    }

    @Nullable 
    private static ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
      if (value == null) return null;
      return ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value);
    }

    @Nullable 
    private static ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  ThirdPartyImmutable.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  ThirdPartyImmutable value) {
      if (value == null) return null;
      return ThirdPartyImmutable.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static ThirdPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  ThirdPartyImmutable value) {
      if (value == null) return null;
      return ThirdPartyImmutable.generateNewBuilder(value);
    }

    @Nullable 
    private static ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  ThirdPartyImmutableWithPrimitive.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  ThirdPartyImmutableWithPrimitive value) {
      if (value == null) return null;
      return ThirdPartyImmutableWithPrimitive.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static ThirdPartyImmutableWithPrimitive.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  ThirdPartyImmutableWithPrimitive value) {
      if (value == null) return null;
      return ThirdPartyImmutableWithPrimitive.generateNewBuilder(value);
    }

    private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends ImmutableFirstPartyImmutable.Builder> builderList) {
      ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
      for (ImmutableFirstPartyImmutable.Builder element : builderList) {
        list.add(element.build());
      }
      return list.build();
    }

    private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(ImmutableFirstPartyImmutable.Builder... builderArray) {
      ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
      for (ImmutableFirstPartyImmutable.Builder element : builderArray) {
        list.add(element.build());
      }
      return list.build();
    }

    private static List<ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends ImmutableFirstPartyImmutable> valueList) {
      ImmutableList.Builder<ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
      for (ImmutableFirstPartyImmutable element : valueList) {
        list.add(ImmutableFirstPartyImmutable.builder().from(element));
      }
      return list.build();
    }

    private static List<ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(ImmutableFirstPartyImmutable... valueArray) {
      ImmutableList.Builder<ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
      for (ImmutableFirstPartyImmutable element : valueArray) {
        list.add(ImmutableFirstPartyImmutable.builder().from(element));
      }
      return list.build();
    }
    private static List<ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends ThirdPartyImmutable.Builder> builderList) {
      ImmutableList.Builder<ThirdPartyImmutable> list = ImmutableList.builder();
      for (ThirdPartyImmutable.Builder element : builderList) {
        list.add(element.doTheBuild());
      }
      return list.build();
    }

    private static List<ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(ThirdPartyImmutable.Builder... builderArray) {
      ImmutableList.Builder<ThirdPartyImmutable> list = ImmutableList.builder();
      for (ThirdPartyImmutable.Builder element : builderArray) {
        list.add(element.doTheBuild());
      }
      return list.build();
    }

    private static List<ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends ThirdPartyImmutable> valueList) {
      ImmutableList.Builder<ThirdPartyImmutable.Builder> list = ImmutableList.builder();
      for (ThirdPartyImmutable element : valueList) {
        list.add(ThirdPartyImmutable.generateNewBuilder(element));
      }
      return list.build();
    }

    private static List<ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(ThirdPartyImmutable... valueArray) {
      ImmutableList.Builder<ThirdPartyImmutable.Builder> list = ImmutableList.builder();
      for (ThirdPartyImmutable element : valueArray) {
        list.add(ThirdPartyImmutable.generateNewBuilder(element));
      }
      return list.build();
    }
  }



  @Nullable 
  private static ImmutableFirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  ImmutableFirstPartyImmutable.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static FirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
    if (value == null) return null;
    return ImmutableFirstPartyImmutable.builder().from(value).build();
  }

  @Nullable 
  private static ImmutableFirstPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
    if (value == null) return null;
    return ImmutableFirstPartyImmutable.builder().from(value);
  }

  @Nullable 
  private static ImmutableFirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon builder) {
    if (builder == null) return null;
    return builder.doIIT();
  }

  @Nullable 
  private static FirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
    if (value == null) return null;
    return ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
  }

  @Nullable 
  private static ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
    if (value == null) return null;
    return ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value);
  }

  @Nullable 
  private static ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  ThirdPartyImmutable.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  ThirdPartyImmutable value) {
    if (value == null) return null;
    return ThirdPartyImmutable.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static ThirdPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  ThirdPartyImmutable value) {
    if (value == null) return null;
    return ThirdPartyImmutable.generateNewBuilder(value);
  }

  @Nullable 
  private static ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  ThirdPartyImmutableWithPrimitive.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  ThirdPartyImmutableWithPrimitive value) {
    if (value == null) return null;
    return ThirdPartyImmutableWithPrimitive.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static ThirdPartyImmutableWithPrimitive.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  ThirdPartyImmutableWithPrimitive value) {
    if (value == null) return null;
    return ThirdPartyImmutableWithPrimitive.generateNewBuilder(value);
  }

  private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends ImmutableFirstPartyImmutable.Builder> builderList) {
    ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
    for (ImmutableFirstPartyImmutable.Builder element : builderList) {
      list.add(element.build());
    }
    return list.build();
  }

  private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(ImmutableFirstPartyImmutable.Builder... builderArray) {
    ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
    for (ImmutableFirstPartyImmutable.Builder element : builderArray) {
      list.add(element.build());
    }
    return list.build();
  }

  private static List<ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends ImmutableFirstPartyImmutable> valueList) {
    ImmutableList.Builder<ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
    for (ImmutableFirstPartyImmutable element : valueList) {
      list.add(ImmutableFirstPartyImmutable.builder().from(element));
    }
    return list.build();
  }

  private static List<ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(ImmutableFirstPartyImmutable... valueArray) {
    ImmutableList.Builder<ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
    for (ImmutableFirstPartyImmutable element : valueArray) {
      list.add(ImmutableFirstPartyImmutable.builder().from(element));
    }
    return list.build();
  }
  private static List<ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends ThirdPartyImmutable.Builder> builderList) {
    ImmutableList.Builder<ThirdPartyImmutable> list = ImmutableList.builder();
    for (ThirdPartyImmutable.Builder element : builderList) {
      list.add(element.doTheBuild());
    }
    return list.build();
  }

  private static List<ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(ThirdPartyImmutable.Builder... builderArray) {
    ImmutableList.Builder<ThirdPartyImmutable> list = ImmutableList.builder();
    for (ThirdPartyImmutable.Builder element : builderArray) {
      list.add(element.doTheBuild());
    }
    return list.build();
  }

  private static List<ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends ThirdPartyImmutable> valueList) {
    ImmutableList.Builder<ThirdPartyImmutable.Builder> list = ImmutableList.builder();
    for (ThirdPartyImmutable element : valueList) {
      list.add(ThirdPartyImmutable.generateNewBuilder(element));
    }
    return list.build();
  }

  private static List<ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(ThirdPartyImmutable... valueArray) {
    ImmutableList.Builder<ThirdPartyImmutable.Builder> list = ImmutableList.builder();
    for (ThirdPartyImmutable element : valueArray) {
      list.add(ThirdPartyImmutable.generateNewBuilder(element));
    }
    return list.build();
  }
}
