package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable;
import org.immutables.fixture.builder.attribute_builders.FirstPartyImmutableWithDifferentStyle;
import org.immutables.fixture.builder.functional.AttributeBuilderValueI;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VanillaAttributeBuilderParent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new VanillaAttributeBuilderParent.Builder()}.
 */
@Generated(from = "VanillaAttributeBuilderParent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableVanillaAttributeBuilderParent
    extends VanillaAttributeBuilderParent {
  private final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable;
  private final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle;
  private final ImmutableList<FirstPartyImmutable> firstPartyImmutableList;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable;
  private final ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive;
  private final @Nullable FirstPartyImmutable optionalFirstPartyImmutable;
  private final @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable;

  private ImmutableVanillaAttributeBuilderParent(
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable,
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle,
      ImmutableList<FirstPartyImmutable> firstPartyImmutableList,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable,
      ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive,
      @Nullable FirstPartyImmutable optionalFirstPartyImmutable,
      @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable) {
    this.firstPartyImmutable = firstPartyImmutable;
    this.firstPartyImmutableWithDifferentStyle = firstPartyImmutableWithDifferentStyle;
    this.firstPartyImmutableList = firstPartyImmutableList;
    this.thirdPartyImmutable = thirdPartyImmutable;
    this.thirdPartyImmutableList = thirdPartyImmutableList;
    this.thirdPartyImmutableWithPrimitive = thirdPartyImmutableWithPrimitive;
    this.optionalFirstPartyImmutable = optionalFirstPartyImmutable;
    this.nullableFirstPartyImmutable = nullableFirstPartyImmutable;
  }

  /**
   * @return The value of the {@code firstPartyImmutable} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable() {
    return firstPartyImmutable;
  }

  /**
   * @return The value of the {@code firstPartyImmutableWithDifferentStyle} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle() {
    return firstPartyImmutableWithDifferentStyle;
  }

  /**
   * @return The value of the {@code firstPartyImmutableList} attribute
   */
  @Override
  public ImmutableList<FirstPartyImmutable> firstPartyImmutableList() {
    return firstPartyImmutableList;
  }

  /**
   * @return The value of the {@code thirdPartyImmutable} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable() {
    return thirdPartyImmutable;
  }

  /**
   * @return The value of the {@code thirdPartyImmutableList} attribute
   */
  @Override
  public ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList() {
    return thirdPartyImmutableList;
  }

  /**
   * @return The value of the {@code thirdPartyImmutableWithPrimitive} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive() {
    return thirdPartyImmutableWithPrimitive;
  }

  /**
   * @return The value of the {@code optionalFirstPartyImmutable} attribute
   */
  @Override
  public Optional<FirstPartyImmutable> optionalFirstPartyImmutable() {
    return Optional.ofNullable(optionalFirstPartyImmutable);
  }

  /**
   * @return The value of the {@code nullableFirstPartyImmutable} attribute
   */
  @Override
  public @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable() {
    return nullableFirstPartyImmutable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstPartyImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withFirstPartyImmutable(FirstPartyImmutable value) {
    if (this.firstPartyImmutable == value) return this;
    org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    return new ImmutableVanillaAttributeBuilderParent(
        newValue,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstPartyImmutableWithDifferentStyle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withFirstPartyImmutableWithDifferentStyle(FirstPartyImmutableWithDifferentStyle value) {
    if (this.firstPartyImmutableWithDifferentStyle == value) return this;
    org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        newValue,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withFirstPartyImmutableList(FirstPartyImmutable... elements) {
    ImmutableList<FirstPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        newValue,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of firstPartyImmutableList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withFirstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
    if (this.firstPartyImmutableList == elements) return this;
    ImmutableList<FirstPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        newValue,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdPartyImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (this.thirdPartyImmutable == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable newValue = Objects.requireNonNull(value, "thirdPartyImmutable");
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        newValue,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... elements) {
    ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        newValue,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of thirdPartyImmutableList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withThirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
    if (this.thirdPartyImmutableList == elements) return this;
    ImmutableList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> newValue = ImmutableList.copyOf(elements);
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        newValue,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdPartyImmutableWithPrimitive
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withThirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (this.thirdPartyImmutableWithPrimitive == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive newValue = Objects.requireNonNull(value, "thirdPartyImmutableWithPrimitive");
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        newValue,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link VanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} attribute.
   * @param value The value for optionalFirstPartyImmutable
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withOptionalFirstPartyImmutable(FirstPartyImmutable value) {
    FirstPartyImmutable newValue = Objects.requireNonNull(value, "optionalFirstPartyImmutable");
    if (this.optionalFirstPartyImmutable == newValue) return this;
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        newValue,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link VanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optionalFirstPartyImmutable
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableVanillaAttributeBuilderParent withOptionalFirstPartyImmutable(Optional<? extends FirstPartyImmutable> optional) {
    @Nullable FirstPartyImmutable value = optional.orElse(null);
    if (this.optionalFirstPartyImmutable == value) return this;
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        value,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullableFirstPartyImmutable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVanillaAttributeBuilderParent withNullableFirstPartyImmutable(@Nullable FirstPartyImmutable value) {
    if (this.nullableFirstPartyImmutable == value) return this;
    @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    return new ImmutableVanillaAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVanillaAttributeBuilderParent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVanillaAttributeBuilderParent
        && equalTo(0, (ImmutableVanillaAttributeBuilderParent) another);
  }

  private boolean equalTo(int synthetic, ImmutableVanillaAttributeBuilderParent another) {
    return firstPartyImmutable.equals(another.firstPartyImmutable)
        && firstPartyImmutableWithDifferentStyle.equals(another.firstPartyImmutableWithDifferentStyle)
        && firstPartyImmutableList.equals(another.firstPartyImmutableList)
        && thirdPartyImmutable.equals(another.thirdPartyImmutable)
        && thirdPartyImmutableList.equals(another.thirdPartyImmutableList)
        && thirdPartyImmutableWithPrimitive.equals(another.thirdPartyImmutableWithPrimitive)
        && Objects.equals(optionalFirstPartyImmutable, another.optionalFirstPartyImmutable)
        && Objects.equals(nullableFirstPartyImmutable, another.nullableFirstPartyImmutable);
  }

  /**
   * Computes a hash code from attributes: {@code firstPartyImmutable}, {@code firstPartyImmutableWithDifferentStyle}, {@code firstPartyImmutableList}, {@code thirdPartyImmutable}, {@code thirdPartyImmutableList}, {@code thirdPartyImmutableWithPrimitive}, {@code optionalFirstPartyImmutable}, {@code nullableFirstPartyImmutable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + firstPartyImmutable.hashCode();
    h += (h << 5) + firstPartyImmutableWithDifferentStyle.hashCode();
    h += (h << 5) + firstPartyImmutableList.hashCode();
    h += (h << 5) + thirdPartyImmutable.hashCode();
    h += (h << 5) + thirdPartyImmutableList.hashCode();
    h += (h << 5) + thirdPartyImmutableWithPrimitive.hashCode();
    h += (h << 5) + Objects.hashCode(optionalFirstPartyImmutable);
    h += (h << 5) + Objects.hashCode(nullableFirstPartyImmutable);
    return h;
  }

  /**
   * Prints the immutable value {@code VanillaAttributeBuilderParent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("VanillaAttributeBuilderParent")
        .omitNullValues()
        .add("firstPartyImmutable", firstPartyImmutable)
        .add("firstPartyImmutableWithDifferentStyle", firstPartyImmutableWithDifferentStyle)
        .add("firstPartyImmutableList", firstPartyImmutableList)
        .add("thirdPartyImmutable", thirdPartyImmutable)
        .add("thirdPartyImmutableList", thirdPartyImmutableList)
        .add("thirdPartyImmutableWithPrimitive", thirdPartyImmutableWithPrimitive)
        .add("optionalFirstPartyImmutable", optionalFirstPartyImmutable)
        .add("nullableFirstPartyImmutable", nullableFirstPartyImmutable)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link VanillaAttributeBuilderParent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VanillaAttributeBuilderParent instance
   */
  public static ImmutableVanillaAttributeBuilderParent copyOf(VanillaAttributeBuilderParent instance) {
    if (instance instanceof ImmutableVanillaAttributeBuilderParent) {
      return (ImmutableVanillaAttributeBuilderParent) instance;
    }
    return new VanillaAttributeBuilderParent.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableVanillaAttributeBuilderParent ImmutableVanillaAttributeBuilderParent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VanillaAttributeBuilderParent", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_FIRST_PARTY_IMMUTABLE = 0x1L;
    private static final long INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE = 0x2L;
    private static final long INIT_BIT_THIRD_PARTY_IMMUTABLE = 0x4L;
    private static final long INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutable;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyle;
    private ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> firstPartyImmutableList = ImmutableList.builder();
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutable;
    private ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> thirdPartyImmutableList = ImmutableList.builder();
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitive;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutable;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutable;

    /**
     * Creates a builder for {@link ImmutableVanillaAttributeBuilderParent ImmutableVanillaAttributeBuilderParent} instances.
     * <pre>
     * new VanillaAttributeBuilderParent.Builder()
     *    .firstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // required {@link VanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable}
     *    .firstPartyImmutableWithDifferentStyle(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutableWithDifferentStyle) // required {@link VanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle}
     *    .addFirstPartyImmutable|addAllFirstPartyImmutableList(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} elements
     *    .thirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable) // required {@link VanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable}
     *    .addThirdPartyImmutable|addAllThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable) // {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} elements
     *    .thirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive) // required {@link VanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive}
     *    .optionalFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // optional {@link VanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable}
     *    .nullableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable | null) // nullable {@link VanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof VanillaAttributeBuilderParent.Builder)) {
        throw new UnsupportedOperationException("Use: new VanillaAttributeBuilderParent.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.functional.AttributeBuilderValueI} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder from(AttributeBuilderValueI instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.VanillaAttributeBuilderParent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder from(VanillaAttributeBuilderParent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof AttributeBuilderValueI) {
        AttributeBuilderValueI instance = (AttributeBuilderValueI) object;
        firstPartyImmutableWithDifferentStyle(instance.firstPartyImmutableWithDifferentStyle());
        thirdPartyImmutableWithPrimitive(instance.thirdPartyImmutableWithPrimitive());
        firstPartyImmutable(instance.firstPartyImmutable());
        @Nullable FirstPartyImmutable nullableFirstPartyImmutableValue = instance.nullableFirstPartyImmutable();
        if (nullableFirstPartyImmutableValue != null) {
          nullableFirstPartyImmutable(nullableFirstPartyImmutableValue);
        }
        addAllThirdPartyImmutableList(instance.thirdPartyImmutableList());
        addAllFirstPartyImmutableList(instance.firstPartyImmutableList());
        thirdPartyImmutable(instance.thirdPartyImmutable());
        Optional<FirstPartyImmutable> optionalFirstPartyImmutableOptional = instance.optionalFirstPartyImmutable();
        if (optionalFirstPartyImmutableOptional.isPresent()) {
          optionalFirstPartyImmutable(optionalFirstPartyImmutableOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link VanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} attribute.
     * @param firstPartyImmutable The value for firstPartyImmutable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder firstPartyImmutable(FirstPartyImmutable firstPartyImmutable) {
      this.firstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutable));
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link VanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutableBuilder() {
      if (this.firstPartyImmutable == null) {
        this.firstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      }
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;

      return this.firstPartyImmutable;
    }

    /**
     * Sets {@link VanillaAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder firstPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutable) {
      this.firstPartyImmutable = firstPartyImmutable;
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link VanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} attribute.
     * @param firstPartyImmutableWithDifferentStyle The value for firstPartyImmutableWithDifferentStyle 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder firstPartyImmutableWithDifferentStyle(FirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle) {
      this.firstPartyImmutableWithDifferentStyle = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(firstPartyImmutableWithDifferentStyle));
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link VanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyleBuilder() {
      if (this.firstPartyImmutableWithDifferentStyle == null) {
        this.firstPartyImmutableWithDifferentStyle = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder();
      }
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;

      return this.firstPartyImmutableWithDifferentStyle;
    }

    /**
     * Sets {@link VanillaAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder firstPartyImmutableWithDifferentStyleBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyle) {
      this.firstPartyImmutableWithDifferentStyle = firstPartyImmutableWithDifferentStyle;
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds one element to {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param element A firstPartyImmutableList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addFirstPartyImmutable(FirstPartyImmutable element) {
      element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
      this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An array of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addFirstPartyImmutableList(FirstPartyImmutable... elements) {
      for (FirstPartyImmutable element : elements) {
        element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
        this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      }
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds a new builder to the {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list and returns
     * the builder.
     */
    @CanIgnoreReturnValue 
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder addFirstPartyImmutableBuilder() {
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      this.firstPartyImmutableList.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An array of firstPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addAllFirstPartyImmutableBuilders(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... elements) {
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : elements) {
        this.firstPartyImmutableList.add(Objects.requireNonNull(element, "firstPartyImmutableList element"));
      }
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Gets the builder elements to {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> firstPartyImmutableBuilders() {
      return this.firstPartyImmutableList.build();
    }

    /**
     * Sets or replaces all elements for {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder firstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
      this.firstPartyImmutableList = ImmutableList.builder();
      return addAllFirstPartyImmutableList(elements);
    }

    /**
     * Adds elements to {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addAllFirstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
      for (FirstPartyImmutable element : elements) {
        element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
        this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      }
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link VanillaAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addAllFirstPartyImmutableBuilders(Iterable<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> elements) {
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : elements) {
        this.firstPartyImmutableList.add(Objects.requireNonNull(element, "firstPartyImmutableList element"));
      }
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link VanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} attribute.
     * @param thirdPartyImmutable The value for thirdPartyImmutable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder thirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable) {
      this.thirdPartyImmutable = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(Objects.requireNonNull(thirdPartyImmutable, "thirdPartyImmutable"));
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link VanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutableBuilder() {
      if (this.thirdPartyImmutable == null) {
        this.thirdPartyImmutable = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;

      return this.thirdPartyImmutable;
    }

    /**
     * Sets {@link VanillaAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder thirdPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutable) {
      this.thirdPartyImmutable = thirdPartyImmutable;
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds one element to {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param element A thirdPartyImmutableList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element) {
      this.thirdPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An array of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... elements) {
      this.thirdPartyImmutableList.addAll(convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(elements));
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds a new builder to the {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list and returns
     * the builder.
     */
    @CanIgnoreReturnValue 
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder addThirdPartyImmutableBuilder() {
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder();
      this.thirdPartyImmutableList.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An array of thirdPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addAllThirdPartyImmutableBuilders(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... elements) {
      this.thirdPartyImmutableList.add(elements);
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Gets the builder elements to {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> thirdPartyImmutableBuilders() {
      return this.thirdPartyImmutableList.build();
    }

    /**
     * Sets or replaces all elements for {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder thirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
      this.thirdPartyImmutableList = ImmutableList.builder();
      return addAllThirdPartyImmutableList(elements);
    }

    /**
     * Adds elements to {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addAllThirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
      this.thirdPartyImmutableList.addAll(convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(elements));
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link VanillaAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder addAllThirdPartyImmutableBuilders(Iterable<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> elements) {
      this.thirdPartyImmutableList.addAll(elements);
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link VanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} attribute.
     * @param thirdPartyImmutableWithPrimitive The value for thirdPartyImmutableWithPrimitive 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder thirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive) {
      this.thirdPartyImmutableWithPrimitive = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(Objects.requireNonNull(thirdPartyImmutableWithPrimitive, "thirdPartyImmutableWithPrimitive"));
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link VanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitiveBuilder() {
      if (this.thirdPartyImmutableWithPrimitive == null) {
        this.thirdPartyImmutableWithPrimitive = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;

      return this.thirdPartyImmutableWithPrimitive;
    }

    /**
     * Sets {@link VanillaAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder thirdPartyImmutableWithPrimitiveBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitive) {
      this.thirdPartyImmutableWithPrimitive = thirdPartyImmutableWithPrimitive;
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the optional value {@link VanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to optionalFirstPartyImmutable.
     * @param optionalFirstPartyImmutable The value for optionalFirstPartyImmutable
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder optionalFirstPartyImmutable(FirstPartyImmutable optionalFirstPartyImmutable) {
      this.optionalFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(optionalFirstPartyImmutable, "optionalFirstPartyImmutable"));
      return (VanillaAttributeBuilderParent.Builder) this;
    }

      /**
       * Returns a builder for {@link VanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable}.
       *
       * Once called, the attribute builder field is set to a new instance of the builder.
       * If called more than once, returns the same builder instance.
       */
      public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutableBuilder() {
        if (this.optionalFirstPartyImmutable == null) {
          this.optionalFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
        }

        return this.optionalFirstPartyImmutable;
      }

      /**
       * Sets {@link VanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to the provided builder.
       */
      @CanIgnoreReturnValue 
      public final VanillaAttributeBuilderParent.Builder optionalFirstPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutable) {
        this.optionalFirstPartyImmutable = optionalFirstPartyImmutable;
        return (VanillaAttributeBuilderParent.Builder) this;
      }

    /**
     * Initializes the optional value {@link VanillaAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to optionalFirstPartyImmutable.
     * @param optionalFirstPartyImmutable The value for optionalFirstPartyImmutable
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder optionalFirstPartyImmutable(Optional<? extends FirstPartyImmutable> optionalFirstPartyImmutable) {
      this.optionalFirstPartyImmutable = convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(optionalFirstPartyImmutable.orElse(null));
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link VanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} attribute.
     * @param nullableFirstPartyImmutable The value for nullableFirstPartyImmutable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder nullableFirstPartyImmutable(@Nullable FirstPartyImmutable nullableFirstPartyImmutable) {
      this.nullableFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(nullableFirstPartyImmutable == null ? null : convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(nullableFirstPartyImmutable));
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link VanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutableBuilder() {
      if (this.nullableFirstPartyImmutable == null) {
        this.nullableFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      }

      return this.nullableFirstPartyImmutable;
    }

    /**
     * Sets {@link VanillaAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final VanillaAttributeBuilderParent.Builder nullableFirstPartyImmutableBuilder(@Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutable) {
      this.nullableFirstPartyImmutable = nullableFirstPartyImmutable;
      return (VanillaAttributeBuilderParent.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableVanillaAttributeBuilderParent ImmutableVanillaAttributeBuilderParent}.
     * @return An immutable instance of VanillaAttributeBuilderParent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVanillaAttributeBuilderParent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVanillaAttributeBuilderParent(
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutable),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(firstPartyImmutableWithDifferentStyle),
          ImmutableList.copyOf(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutableList.build())),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(thirdPartyImmutable),
          ImmutableList.copyOf(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(thirdPartyImmutableList.build())),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(thirdPartyImmutableWithPrimitive),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(optionalFirstPartyImmutable),
          nullableFirstPartyImmutable == null ? null : convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(nullableFirstPartyImmutable));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIRST_PARTY_IMMUTABLE) != 0) attributes.add("firstPartyImmutable");
      if ((initBits & INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE) != 0) attributes.add("firstPartyImmutableWithDifferentStyle");
      if ((initBits & INIT_BIT_THIRD_PARTY_IMMUTABLE) != 0) attributes.add("thirdPartyImmutable");
      if ((initBits & INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE) != 0) attributes.add("thirdPartyImmutableWithPrimitive");
      return "Cannot build VanillaAttributeBuilderParent, some of required attributes are not set " + attributes;
    }



    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static FirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon builder) {
      if (builder == null) return null;
      return builder.doIIT();
    }

    @Nullable 
    private static FirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value);
    }

    private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> builderList) {
      ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderList) {
        list.add(element.build());
      }
      return list.build();
    }

    private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... builderArray) {
      ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderArray) {
        list.add(element.build());
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable> valueList) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueList) {
        list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable... valueArray) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueArray) {
        list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
      }
      return list.build();
    }
    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> builderList) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderList) {
        list.add(element.doTheBuild());
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... builderArray) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderArray) {
        list.add(element.doTheBuild());
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> valueList) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueList) {
        list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
      }
      return list.build();
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... valueArray) {
      ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list = ImmutableList.builder();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueArray) {
        list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
      }
      return list.build();
    }
  }



  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static FirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon builder) {
    if (builder == null) return null;
    return builder.doIIT();
  }

  @Nullable 
  private static FirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value);
  }

  private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> builderList) {
    ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderList) {
      list.add(element.build());
    }
    return list.build();
  }

  private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... builderArray) {
    ImmutableList.Builder<FirstPartyImmutable> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderArray) {
      list.add(element.build());
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable> valueList) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueList) {
      list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable... valueArray) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueArray) {
      list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
    }
    return list.build();
  }
  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> builderList) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderList) {
      list.add(element.doTheBuild());
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... builderArray) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderArray) {
      list.add(element.doTheBuild());
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> valueList) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueList) {
      list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
    }
    return list.build();
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... valueArray) {
    ImmutableList.Builder<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list = ImmutableList.builder();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueArray) {
      list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
    }
    return list.build();
  }
}
