package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OneAndTwoAndThreeConcrete}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOneAndTwoAndThreeConcrete.builder()}.
 */
@Generated(from = "OneAndTwoAndThreeConcrete", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableOneAndTwoAndThreeConcrete
    implements OneAndTwoAndThreeConcrete {
  private final String one;
  private final String two;
  private final String three;

  private ImmutableOneAndTwoAndThreeConcrete(String one, String two, String three) {
    this.one = one;
    this.two = two;
    this.three = three;
  }

  /**
   * @return The value of the {@code one} attribute
   */
  @Override
  public String one() {
    return one;
  }

  /**
   * @return The value of the {@code two} attribute
   */
  @Override
  public String two() {
    return two;
  }

  /**
   * @return The value of the {@code three} attribute
   */
  @Override
  public String three() {
    return three;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OneAndTwoAndThreeConcrete#one() one} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for one
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOneAndTwoAndThreeConcrete withOne(String value) {
    String newValue = Objects.requireNonNull(value, "one");
    if (this.one.equals(newValue)) return this;
    return new ImmutableOneAndTwoAndThreeConcrete(newValue, this.two, this.three);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OneAndTwoAndThreeConcrete#two() two} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for two
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOneAndTwoAndThreeConcrete withTwo(String value) {
    String newValue = Objects.requireNonNull(value, "two");
    if (this.two.equals(newValue)) return this;
    return new ImmutableOneAndTwoAndThreeConcrete(this.one, newValue, this.three);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OneAndTwoAndThreeConcrete#three() three} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for three
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOneAndTwoAndThreeConcrete withThree(String value) {
    String newValue = Objects.requireNonNull(value, "three");
    if (this.three.equals(newValue)) return this;
    return new ImmutableOneAndTwoAndThreeConcrete(this.one, this.two, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOneAndTwoAndThreeConcrete} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOneAndTwoAndThreeConcrete
        && equalTo(0, (ImmutableOneAndTwoAndThreeConcrete) another);
  }

  private boolean equalTo(int synthetic, ImmutableOneAndTwoAndThreeConcrete another) {
    return one.equals(another.one)
        && two.equals(another.two)
        && three.equals(another.three);
  }

  /**
   * Computes a hash code from attributes: {@code one}, {@code two}, {@code three}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + one.hashCode();
    h += (h << 5) + two.hashCode();
    h += (h << 5) + three.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OneAndTwoAndThreeConcrete} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OneAndTwoAndThreeConcrete")
        .omitNullValues()
        .add("one", one)
        .add("two", two)
        .add("three", three)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link OneAndTwoAndThreeConcrete} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OneAndTwoAndThreeConcrete instance
   */
  public static ImmutableOneAndTwoAndThreeConcrete copyOf(OneAndTwoAndThreeConcrete instance) {
    if (instance instanceof ImmutableOneAndTwoAndThreeConcrete) {
      return (ImmutableOneAndTwoAndThreeConcrete) instance;
    }
    return ImmutableOneAndTwoAndThreeConcrete.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOneAndTwoAndThreeConcrete ImmutableOneAndTwoAndThreeConcrete}.
   * <pre>
   * ImmutableOneAndTwoAndThreeConcrete.builder()
   *    .one(String) // required {@link OneAndTwoAndThreeConcrete#one() one}
   *    .two(String) // required {@link OneAndTwoAndThreeConcrete#two() two}
   *    .three(String) // required {@link OneAndTwoAndThreeConcrete#three() three}
   *    .build();
   * </pre>
   * @return A new ImmutableOneAndTwoAndThreeConcrete builder
   */
  public static ImmutableOneAndTwoAndThreeConcrete.Builder builder() {
    return new ImmutableOneAndTwoAndThreeConcrete.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOneAndTwoAndThreeConcrete ImmutableOneAndTwoAndThreeConcrete}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OneAndTwoAndThreeConcrete", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ONE = 0x1L;
    private static final long INIT_BIT_TWO = 0x2L;
    private static final long INIT_BIT_THREE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String one;
    private @Nullable String two;
    private @Nullable String three;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.OneAndTwoAndThree} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OneAndTwoAndThree instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.OneAndTwo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OneAndTwo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.One} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(One instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.OneAndTwoAndThreeConcrete} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OneAndTwoAndThreeConcrete instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.Three} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Three instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.Two} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Two instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof OneAndTwoAndThree) {
        OneAndTwoAndThree instance = (OneAndTwoAndThree) object;
        if ((bits & 0x2L) == 0) {
          two(instance.two());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          three(instance.three());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          one(instance.one());
          bits |= 0x1L;
        }
      }
      if (object instanceof OneAndTwo) {
        OneAndTwo instance = (OneAndTwo) object;
        if ((bits & 0x2L) == 0) {
          two(instance.two());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          one(instance.one());
          bits |= 0x1L;
        }
      }
      if (object instanceof One) {
        One instance = (One) object;
        if ((bits & 0x1L) == 0) {
          one(instance.one());
          bits |= 0x1L;
        }
      }
      if (object instanceof OneAndTwoAndThreeConcrete) {
        OneAndTwoAndThreeConcrete instance = (OneAndTwoAndThreeConcrete) object;
        if ((bits & 0x2L) == 0) {
          two(instance.two());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          three(instance.three());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          one(instance.one());
          bits |= 0x1L;
        }
      }
      if (object instanceof Three) {
        Three instance = (Three) object;
        if ((bits & 0x4L) == 0) {
          three(instance.three());
          bits |= 0x4L;
        }
      }
      if (object instanceof Two) {
        Two instance = (Two) object;
        if ((bits & 0x2L) == 0) {
          two(instance.two());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link OneAndTwoAndThreeConcrete#one() one} attribute.
     * @param one The value for one 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder one(String one) {
      this.one = Objects.requireNonNull(one, "one");
      initBits &= ~INIT_BIT_ONE;
      return this;
    }

    /**
     * Initializes the value for the {@link OneAndTwoAndThreeConcrete#two() two} attribute.
     * @param two The value for two 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder two(String two) {
      this.two = Objects.requireNonNull(two, "two");
      initBits &= ~INIT_BIT_TWO;
      return this;
    }

    /**
     * Initializes the value for the {@link OneAndTwoAndThreeConcrete#three() three} attribute.
     * @param three The value for three 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder three(String three) {
      this.three = Objects.requireNonNull(three, "three");
      initBits &= ~INIT_BIT_THREE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOneAndTwoAndThreeConcrete ImmutableOneAndTwoAndThreeConcrete}.
     * @return An immutable instance of OneAndTwoAndThreeConcrete
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOneAndTwoAndThreeConcrete build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOneAndTwoAndThreeConcrete(one, two, three);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ONE) != 0) attributes.add("one");
      if ((initBits & INIT_BIT_TWO) != 0) attributes.add("two");
      if ((initBits & INIT_BIT_THREE) != 0) attributes.add("three");
      return "Cannot build OneAndTwoAndThreeConcrete, some of required attributes are not set " + attributes;
    }
  }
}
