package org.immutables.fixture.builder;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.attribute_builders.FirstPartyWithBuilderExtension;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NeapolitanAttributeBuilderParent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNeapolitanAttributeBuilderParent.builder()}.
 */
@Generated(from = "NeapolitanAttributeBuilderParent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNeapolitanAttributeBuilderParent
    extends NeapolitanAttributeBuilderParent {
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod tpiWithValueInstanceCopyMethod;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod tpiWithValueClassCopyMethod;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod tpiWithBuilderInstanceCopyMethod;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod tpiWithBuilderClassCopyMethod;
  private final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension fpWithBuilderExtension;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder tpiWithNestedBuilder;

  private ImmutableNeapolitanAttributeBuilderParent(
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod tpiWithValueInstanceCopyMethod,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod tpiWithValueClassCopyMethod,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod tpiWithBuilderInstanceCopyMethod,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod tpiWithBuilderClassCopyMethod,
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension fpWithBuilderExtension,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder tpiWithNestedBuilder) {
    this.tpiWithValueInstanceCopyMethod = tpiWithValueInstanceCopyMethod;
    this.tpiWithValueClassCopyMethod = tpiWithValueClassCopyMethod;
    this.tpiWithBuilderInstanceCopyMethod = tpiWithBuilderInstanceCopyMethod;
    this.tpiWithBuilderClassCopyMethod = tpiWithBuilderClassCopyMethod;
    this.fpWithBuilderExtension = fpWithBuilderExtension;
    this.tpiWithNestedBuilder = tpiWithNestedBuilder;
  }

  /**
   * @return The value of the {@code tpiWithValueInstanceCopyMethod} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod tpiWithValueInstanceCopyMethod() {
    return tpiWithValueInstanceCopyMethod;
  }

  /**
   * @return The value of the {@code tpiWithValueClassCopyMethod} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod tpiWithValueClassCopyMethod() {
    return tpiWithValueClassCopyMethod;
  }

  /**
   * @return The value of the {@code tpiWithBuilderInstanceCopyMethod} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod tpiWithBuilderInstanceCopyMethod() {
    return tpiWithBuilderInstanceCopyMethod;
  }

  /**
   * @return The value of the {@code tpiWithBuilderClassCopyMethod} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod tpiWithBuilderClassCopyMethod() {
    return tpiWithBuilderClassCopyMethod;
  }

  /**
   * @return The value of the {@code fpWithBuilderExtension} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension fpWithBuilderExtension() {
    return fpWithBuilderExtension;
  }

  /**
   * @return The value of the {@code tpiWithNestedBuilder} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder tpiWithNestedBuilder() {
    return tpiWithNestedBuilder;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NeapolitanAttributeBuilderParent#tpiWithValueInstanceCopyMethod() tpiWithValueInstanceCopyMethod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tpiWithValueInstanceCopyMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNeapolitanAttributeBuilderParent withTpiWithValueInstanceCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod value) {
    if (this.tpiWithValueInstanceCopyMethod == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod newValue = Objects.requireNonNull(value, "tpiWithValueInstanceCopyMethod");
    return new ImmutableNeapolitanAttributeBuilderParent(
        newValue,
        this.tpiWithValueClassCopyMethod,
        this.tpiWithBuilderInstanceCopyMethod,
        this.tpiWithBuilderClassCopyMethod,
        this.fpWithBuilderExtension,
        this.tpiWithNestedBuilder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NeapolitanAttributeBuilderParent#tpiWithValueClassCopyMethod() tpiWithValueClassCopyMethod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tpiWithValueClassCopyMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNeapolitanAttributeBuilderParent withTpiWithValueClassCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod value) {
    if (this.tpiWithValueClassCopyMethod == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod newValue = Objects.requireNonNull(value, "tpiWithValueClassCopyMethod");
    return new ImmutableNeapolitanAttributeBuilderParent(
        this.tpiWithValueInstanceCopyMethod,
        newValue,
        this.tpiWithBuilderInstanceCopyMethod,
        this.tpiWithBuilderClassCopyMethod,
        this.fpWithBuilderExtension,
        this.tpiWithNestedBuilder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NeapolitanAttributeBuilderParent#tpiWithBuilderInstanceCopyMethod() tpiWithBuilderInstanceCopyMethod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tpiWithBuilderInstanceCopyMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNeapolitanAttributeBuilderParent withTpiWithBuilderInstanceCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod value) {
    if (this.tpiWithBuilderInstanceCopyMethod == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod newValue = Objects.requireNonNull(value, "tpiWithBuilderInstanceCopyMethod");
    return new ImmutableNeapolitanAttributeBuilderParent(
        this.tpiWithValueInstanceCopyMethod,
        this.tpiWithValueClassCopyMethod,
        newValue,
        this.tpiWithBuilderClassCopyMethod,
        this.fpWithBuilderExtension,
        this.tpiWithNestedBuilder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NeapolitanAttributeBuilderParent#tpiWithBuilderClassCopyMethod() tpiWithBuilderClassCopyMethod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tpiWithBuilderClassCopyMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNeapolitanAttributeBuilderParent withTpiWithBuilderClassCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod value) {
    if (this.tpiWithBuilderClassCopyMethod == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod newValue = Objects.requireNonNull(value, "tpiWithBuilderClassCopyMethod");
    return new ImmutableNeapolitanAttributeBuilderParent(
        this.tpiWithValueInstanceCopyMethod,
        this.tpiWithValueClassCopyMethod,
        this.tpiWithBuilderInstanceCopyMethod,
        newValue,
        this.fpWithBuilderExtension,
        this.tpiWithNestedBuilder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NeapolitanAttributeBuilderParent#fpWithBuilderExtension() fpWithBuilderExtension} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fpWithBuilderExtension
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNeapolitanAttributeBuilderParent withFpWithBuilderExtension(FirstPartyWithBuilderExtension value) {
    if (this.fpWithBuilderExtension == value) return this;
    org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension newValue = new FirstPartyWithBuilderExtension.Builder().from(value).build();
    return new ImmutableNeapolitanAttributeBuilderParent(
        this.tpiWithValueInstanceCopyMethod,
        this.tpiWithValueClassCopyMethod,
        this.tpiWithBuilderInstanceCopyMethod,
        this.tpiWithBuilderClassCopyMethod,
        newValue,
        this.tpiWithNestedBuilder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NeapolitanAttributeBuilderParent#tpiWithNestedBuilder() tpiWithNestedBuilder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tpiWithNestedBuilder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNeapolitanAttributeBuilderParent withTpiWithNestedBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
    if (this.tpiWithNestedBuilder == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder newValue = Objects.requireNonNull(value, "tpiWithNestedBuilder");
    return new ImmutableNeapolitanAttributeBuilderParent(
        this.tpiWithValueInstanceCopyMethod,
        this.tpiWithValueClassCopyMethod,
        this.tpiWithBuilderInstanceCopyMethod,
        this.tpiWithBuilderClassCopyMethod,
        this.fpWithBuilderExtension,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNeapolitanAttributeBuilderParent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNeapolitanAttributeBuilderParent
        && equalTo(0, (ImmutableNeapolitanAttributeBuilderParent) another);
  }

  private boolean equalTo(int synthetic, ImmutableNeapolitanAttributeBuilderParent another) {
    return tpiWithValueInstanceCopyMethod.equals(another.tpiWithValueInstanceCopyMethod)
        && tpiWithValueClassCopyMethod.equals(another.tpiWithValueClassCopyMethod)
        && tpiWithBuilderInstanceCopyMethod.equals(another.tpiWithBuilderInstanceCopyMethod)
        && tpiWithBuilderClassCopyMethod.equals(another.tpiWithBuilderClassCopyMethod)
        && fpWithBuilderExtension.equals(another.fpWithBuilderExtension)
        && tpiWithNestedBuilder.equals(another.tpiWithNestedBuilder);
  }

  /**
   * Computes a hash code from attributes: {@code tpiWithValueInstanceCopyMethod}, {@code tpiWithValueClassCopyMethod}, {@code tpiWithBuilderInstanceCopyMethod}, {@code tpiWithBuilderClassCopyMethod}, {@code fpWithBuilderExtension}, {@code tpiWithNestedBuilder}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + tpiWithValueInstanceCopyMethod.hashCode();
    h += (h << 5) + tpiWithValueClassCopyMethod.hashCode();
    h += (h << 5) + tpiWithBuilderInstanceCopyMethod.hashCode();
    h += (h << 5) + tpiWithBuilderClassCopyMethod.hashCode();
    h += (h << 5) + fpWithBuilderExtension.hashCode();
    h += (h << 5) + tpiWithNestedBuilder.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NeapolitanAttributeBuilderParent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NeapolitanAttributeBuilderParent")
        .omitNullValues()
        .add("tpiWithValueInstanceCopyMethod", tpiWithValueInstanceCopyMethod)
        .add("tpiWithValueClassCopyMethod", tpiWithValueClassCopyMethod)
        .add("tpiWithBuilderInstanceCopyMethod", tpiWithBuilderInstanceCopyMethod)
        .add("tpiWithBuilderClassCopyMethod", tpiWithBuilderClassCopyMethod)
        .add("fpWithBuilderExtension", fpWithBuilderExtension)
        .add("tpiWithNestedBuilder", tpiWithNestedBuilder)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NeapolitanAttributeBuilderParent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NeapolitanAttributeBuilderParent instance
   */
  public static ImmutableNeapolitanAttributeBuilderParent copyOf(NeapolitanAttributeBuilderParent instance) {
    if (instance instanceof ImmutableNeapolitanAttributeBuilderParent) {
      return (ImmutableNeapolitanAttributeBuilderParent) instance;
    }
    return ImmutableNeapolitanAttributeBuilderParent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNeapolitanAttributeBuilderParent ImmutableNeapolitanAttributeBuilderParent}.
   * <pre>
   * ImmutableNeapolitanAttributeBuilderParent.builder()
   *    .tpiWithValueInstanceCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod) // required {@link NeapolitanAttributeBuilderParent#tpiWithValueInstanceCopyMethod() tpiWithValueInstanceCopyMethod}
   *    .tpiWithValueClassCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod) // required {@link NeapolitanAttributeBuilderParent#tpiWithValueClassCopyMethod() tpiWithValueClassCopyMethod}
   *    .tpiWithBuilderInstanceCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod) // required {@link NeapolitanAttributeBuilderParent#tpiWithBuilderInstanceCopyMethod() tpiWithBuilderInstanceCopyMethod}
   *    .tpiWithBuilderClassCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod) // required {@link NeapolitanAttributeBuilderParent#tpiWithBuilderClassCopyMethod() tpiWithBuilderClassCopyMethod}
   *    .fpWithBuilderExtension(org.immutables.fixture.builder.attribute_builders.FirstPartyWithBuilderExtension) // required {@link NeapolitanAttributeBuilderParent#fpWithBuilderExtension() fpWithBuilderExtension}
   *    .tpiWithNestedBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder) // required {@link NeapolitanAttributeBuilderParent#tpiWithNestedBuilder() tpiWithNestedBuilder}
   *    .build();
   * </pre>
   * @return A new ImmutableNeapolitanAttributeBuilderParent builder
   */
  public static ImmutableNeapolitanAttributeBuilderParent.Builder builder() {
    return new ImmutableNeapolitanAttributeBuilderParent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNeapolitanAttributeBuilderParent ImmutableNeapolitanAttributeBuilderParent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NeapolitanAttributeBuilderParent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TPI_WITH_VALUE_INSTANCE_COPY_METHOD = 0x1L;
    private static final long INIT_BIT_TPI_WITH_VALUE_CLASS_COPY_METHOD = 0x2L;
    private static final long INIT_BIT_TPI_WITH_BUILDER_INSTANCE_COPY_METHOD = 0x4L;
    private static final long INIT_BIT_TPI_WITH_BUILDER_CLASS_COPY_METHOD = 0x8L;
    private static final long INIT_BIT_FP_WITH_BUILDER_EXTENSION = 0x10L;
    private static final long INIT_BIT_TPI_WITH_NESTED_BUILDER = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod.Builder tpiWithValueInstanceCopyMethod;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.Builder tpiWithValueClassCopyMethod;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.Builder tpiWithBuilderInstanceCopyMethod;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder tpiWithBuilderClassCopyMethod;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension.Builder fpWithBuilderExtension;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder tpiWithNestedBuilder;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NeapolitanAttributeBuilderParent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NeapolitanAttributeBuilderParent instance) {
      Objects.requireNonNull(instance, "instance");
      tpiWithValueInstanceCopyMethod(instance.tpiWithValueInstanceCopyMethod());
      tpiWithValueClassCopyMethod(instance.tpiWithValueClassCopyMethod());
      tpiWithBuilderInstanceCopyMethod(instance.tpiWithBuilderInstanceCopyMethod());
      tpiWithBuilderClassCopyMethod(instance.tpiWithBuilderClassCopyMethod());
      fpWithBuilderExtension(instance.fpWithBuilderExtension());
      tpiWithNestedBuilder(instance.tpiWithNestedBuilder());
      return this;
    }

    /**
     * Initializes the value for the {@link NeapolitanAttributeBuilderParent#tpiWithValueInstanceCopyMethod() tpiWithValueInstanceCopyMethod} attribute.
     * @param tpiWithValueInstanceCopyMethod The value for tpiWithValueInstanceCopyMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithValueInstanceCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod tpiWithValueInstanceCopyMethod) {
      this.tpiWithValueInstanceCopyMethod = Objects.requireNonNull(tpiWithValueInstanceCopyMethod, "tpiWithValueInstanceCopyMethod").toBuilder();
      initBits &= ~INIT_BIT_TPI_WITH_VALUE_INSTANCE_COPY_METHOD;
      return this;
    }

    /**
     * Returns a builder for {@link NeapolitanAttributeBuilderParent#tpiWithValueInstanceCopyMethod() tpiWithValueInstanceCopyMethod}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod.Builder tpiWithValueInstanceCopyMethodBuilder() {
      if (this.tpiWithValueInstanceCopyMethod == null) {
        this.tpiWithValueInstanceCopyMethod = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_TPI_WITH_VALUE_INSTANCE_COPY_METHOD;

      return this.tpiWithValueInstanceCopyMethod;
    }

    /**
     * Sets {@link NeapolitanAttributeBuilderParent#tpiWithValueInstanceCopyMethod() tpiWithValueInstanceCopyMethod} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithValueInstanceCopyMethodBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod.Builder tpiWithValueInstanceCopyMethod) {
      this.tpiWithValueInstanceCopyMethod = tpiWithValueInstanceCopyMethod;
      initBits &= ~INIT_BIT_TPI_WITH_VALUE_INSTANCE_COPY_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link NeapolitanAttributeBuilderParent#tpiWithValueClassCopyMethod() tpiWithValueClassCopyMethod} attribute.
     * @param tpiWithValueClassCopyMethod The value for tpiWithValueClassCopyMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithValueClassCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod tpiWithValueClassCopyMethod) {
      this.tpiWithValueClassCopyMethod = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.generateNewBuilder(Objects.requireNonNull(tpiWithValueClassCopyMethod, "tpiWithValueClassCopyMethod"));
      initBits &= ~INIT_BIT_TPI_WITH_VALUE_CLASS_COPY_METHOD;
      return this;
    }

    /**
     * Returns a builder for {@link NeapolitanAttributeBuilderParent#tpiWithValueClassCopyMethod() tpiWithValueClassCopyMethod}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.Builder tpiWithValueClassCopyMethodBuilder() {
      if (this.tpiWithValueClassCopyMethod == null) {
        this.tpiWithValueClassCopyMethod = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_TPI_WITH_VALUE_CLASS_COPY_METHOD;

      return this.tpiWithValueClassCopyMethod;
    }

    /**
     * Sets {@link NeapolitanAttributeBuilderParent#tpiWithValueClassCopyMethod() tpiWithValueClassCopyMethod} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithValueClassCopyMethodBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.Builder tpiWithValueClassCopyMethod) {
      this.tpiWithValueClassCopyMethod = tpiWithValueClassCopyMethod;
      initBits &= ~INIT_BIT_TPI_WITH_VALUE_CLASS_COPY_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link NeapolitanAttributeBuilderParent#tpiWithBuilderInstanceCopyMethod() tpiWithBuilderInstanceCopyMethod} attribute.
     * @param tpiWithBuilderInstanceCopyMethod The value for tpiWithBuilderInstanceCopyMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithBuilderInstanceCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod tpiWithBuilderInstanceCopyMethod) {
      this.tpiWithBuilderInstanceCopyMethod = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.generateNewBuilder().from(Objects.requireNonNull(tpiWithBuilderInstanceCopyMethod, "tpiWithBuilderInstanceCopyMethod"));
      initBits &= ~INIT_BIT_TPI_WITH_BUILDER_INSTANCE_COPY_METHOD;
      return this;
    }

    /**
     * Returns a builder for {@link NeapolitanAttributeBuilderParent#tpiWithBuilderInstanceCopyMethod() tpiWithBuilderInstanceCopyMethod}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.Builder tpiWithBuilderInstanceCopyMethodBuilder() {
      if (this.tpiWithBuilderInstanceCopyMethod == null) {
        this.tpiWithBuilderInstanceCopyMethod = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_TPI_WITH_BUILDER_INSTANCE_COPY_METHOD;

      return this.tpiWithBuilderInstanceCopyMethod;
    }

    /**
     * Sets {@link NeapolitanAttributeBuilderParent#tpiWithBuilderInstanceCopyMethod() tpiWithBuilderInstanceCopyMethod} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithBuilderInstanceCopyMethodBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.Builder tpiWithBuilderInstanceCopyMethod) {
      this.tpiWithBuilderInstanceCopyMethod = tpiWithBuilderInstanceCopyMethod;
      initBits &= ~INIT_BIT_TPI_WITH_BUILDER_INSTANCE_COPY_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link NeapolitanAttributeBuilderParent#tpiWithBuilderClassCopyMethod() tpiWithBuilderClassCopyMethod} attribute.
     * @param tpiWithBuilderClassCopyMethod The value for tpiWithBuilderClassCopyMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithBuilderClassCopyMethod(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod tpiWithBuilderClassCopyMethod) {
      this.tpiWithBuilderClassCopyMethod = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder.from(Objects.requireNonNull(tpiWithBuilderClassCopyMethod, "tpiWithBuilderClassCopyMethod"));
      initBits &= ~INIT_BIT_TPI_WITH_BUILDER_CLASS_COPY_METHOD;
      return this;
    }

    /**
     * Returns a builder for {@link NeapolitanAttributeBuilderParent#tpiWithBuilderClassCopyMethod() tpiWithBuilderClassCopyMethod}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder tpiWithBuilderClassCopyMethodBuilder() {
      if (this.tpiWithBuilderClassCopyMethod == null) {
        this.tpiWithBuilderClassCopyMethod = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_TPI_WITH_BUILDER_CLASS_COPY_METHOD;

      return this.tpiWithBuilderClassCopyMethod;
    }

    /**
     * Sets {@link NeapolitanAttributeBuilderParent#tpiWithBuilderClassCopyMethod() tpiWithBuilderClassCopyMethod} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithBuilderClassCopyMethodBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder tpiWithBuilderClassCopyMethod) {
      this.tpiWithBuilderClassCopyMethod = tpiWithBuilderClassCopyMethod;
      initBits &= ~INIT_BIT_TPI_WITH_BUILDER_CLASS_COPY_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link NeapolitanAttributeBuilderParent#fpWithBuilderExtension() fpWithBuilderExtension} attribute.
     * @param fpWithBuilderExtension The value for fpWithBuilderExtension 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fpWithBuilderExtension(FirstPartyWithBuilderExtension fpWithBuilderExtension) {
      this.fpWithBuilderExtension = new FirstPartyWithBuilderExtension.Builder().from(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyWithBuilderExtension(fpWithBuilderExtension));
      initBits &= ~INIT_BIT_FP_WITH_BUILDER_EXTENSION;
      return this;
    }

    /**
     * Returns a builder for {@link NeapolitanAttributeBuilderParent#fpWithBuilderExtension() fpWithBuilderExtension}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension.Builder fpWithBuilderExtensionBuilder() {
      if (this.fpWithBuilderExtension == null) {
        this.fpWithBuilderExtension = new FirstPartyWithBuilderExtension.Builder();
      }
      initBits &= ~INIT_BIT_FP_WITH_BUILDER_EXTENSION;

      return this.fpWithBuilderExtension;
    }

    /**
     * Sets {@link NeapolitanAttributeBuilderParent#fpWithBuilderExtension() fpWithBuilderExtension} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final Builder fpWithBuilderExtensionBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension.Builder fpWithBuilderExtension) {
      this.fpWithBuilderExtension = fpWithBuilderExtension;
      initBits &= ~INIT_BIT_FP_WITH_BUILDER_EXTENSION;
      return this;
    }

    /**
     * Initializes the value for the {@link NeapolitanAttributeBuilderParent#tpiWithNestedBuilder() tpiWithNestedBuilder} attribute.
     * @param tpiWithNestedBuilder The value for tpiWithNestedBuilder 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithNestedBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder tpiWithNestedBuilder) {
      this.tpiWithNestedBuilder = new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(Objects.requireNonNull(tpiWithNestedBuilder, "tpiWithNestedBuilder"));
      initBits &= ~INIT_BIT_TPI_WITH_NESTED_BUILDER;
      return this;
    }

    /**
     * Returns a builder for {@link NeapolitanAttributeBuilderParent#tpiWithNestedBuilder() tpiWithNestedBuilder}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder tpiWithNestedBuilderBuilder() {
      if (this.tpiWithNestedBuilder == null) {
        this.tpiWithNestedBuilder = new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder();
      }
      initBits &= ~INIT_BIT_TPI_WITH_NESTED_BUILDER;

      return this.tpiWithNestedBuilder;
    }

    /**
     * Sets {@link NeapolitanAttributeBuilderParent#tpiWithNestedBuilder() tpiWithNestedBuilder} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final Builder tpiWithNestedBuilderBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder tpiWithNestedBuilder) {
      this.tpiWithNestedBuilder = tpiWithNestedBuilder;
      initBits &= ~INIT_BIT_TPI_WITH_NESTED_BUILDER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNeapolitanAttributeBuilderParent ImmutableNeapolitanAttributeBuilderParent}.
     * @return An immutable instance of NeapolitanAttributeBuilderParent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNeapolitanAttributeBuilderParent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNeapolitanAttributeBuilderParent(
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueInstanceCopyMethod(tpiWithValueInstanceCopyMethod),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueClassCopyMethod(tpiWithValueClassCopyMethod),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderInstanceCopyMethod(tpiWithBuilderInstanceCopyMethod),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderClassCopyMethod(tpiWithBuilderClassCopyMethod),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyWithBuilderExtension(fpWithBuilderExtension),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(tpiWithNestedBuilder));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TPI_WITH_VALUE_INSTANCE_COPY_METHOD) != 0) attributes.add("tpiWithValueInstanceCopyMethod");
      if ((initBits & INIT_BIT_TPI_WITH_VALUE_CLASS_COPY_METHOD) != 0) attributes.add("tpiWithValueClassCopyMethod");
      if ((initBits & INIT_BIT_TPI_WITH_BUILDER_INSTANCE_COPY_METHOD) != 0) attributes.add("tpiWithBuilderInstanceCopyMethod");
      if ((initBits & INIT_BIT_TPI_WITH_BUILDER_CLASS_COPY_METHOD) != 0) attributes.add("tpiWithBuilderClassCopyMethod");
      if ((initBits & INIT_BIT_FP_WITH_BUILDER_EXTENSION) != 0) attributes.add("fpWithBuilderExtension");
      if ((initBits & INIT_BIT_TPI_WITH_NESTED_BUILDER) != 0) attributes.add("tpiWithNestedBuilder");
      return "Cannot build NeapolitanAttributeBuilderParent, some of required attributes are not set " + attributes;
    }



    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod value) {
      if (value == null) return null;
      return value.toBuilder().build();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod value) {
      if (value == null) return null;
      return value.toBuilder();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.generateNewBuilder(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.generateNewBuilder().from(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.generateNewBuilder().from(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder.from(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder.from(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyWithBuilderExtension(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static FirstPartyWithBuilderExtension convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyWithBuilderExtension(@Nullable  FirstPartyWithBuilderExtension value) {
      if (value == null) return null;
      return new FirstPartyWithBuilderExtension.Builder().from(value).build();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyWithBuilderExtension(@Nullable  FirstPartyWithBuilderExtension value) {
      if (value == null) return null;
      return new FirstPartyWithBuilderExtension.Builder().from(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
      if (value == null) return null;
      return new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
      if (value == null) return null;
      return new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(value);
    }

  }



  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod value) {
    if (value == null) return null;
    return value.toBuilder().build();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueInstanceCopyMethod value) {
    if (value == null) return null;
    return value.toBuilder();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithValueClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithValueClassCopyMethod.generateNewBuilder(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.generateNewBuilder().from(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderInstanceCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderInstanceCopyMethod.generateNewBuilder().from(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder.from(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithBuilderClassCopyMethod(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithBuilderClassCopyMethod.Builder.from(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyWithBuilderExtension(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static FirstPartyWithBuilderExtension convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyWithBuilderExtension(@Nullable  FirstPartyWithBuilderExtension value) {
    if (value == null) return null;
    return new FirstPartyWithBuilderExtension.Builder().from(value).build();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyWithBuilderExtension.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyWithBuilderExtension(@Nullable  FirstPartyWithBuilderExtension value) {
    if (value == null) return null;
    return new FirstPartyWithBuilderExtension.Builder().from(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
    if (value == null) return null;
    return new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithNestedBuilder(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder value) {
    if (value == null) return null;
    return new org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithNestedBuilder.Builder(value);
  }

}
