package org.immutables.fixture.builder;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable;
import org.immutables.fixture.builder.attribute_builders.FirstPartyImmutableWithDifferentStyle;
import org.immutables.fixture.builder.functional.AttributeBuilderValueI;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JdkOnlyAttributeBuilderParent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new JdkOnlyAttributeBuilderParent.Builder()}.
 */
@Generated(from = "JdkOnlyAttributeBuilderParent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJdkOnlyAttributeBuilderParent
    extends JdkOnlyAttributeBuilderParent {
  private final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable;
  private final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle;
  private final List<FirstPartyImmutable> firstPartyImmutableList;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable;
  private final List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList;
  private final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive;
  private final @Nullable FirstPartyImmutable optionalFirstPartyImmutable;
  private final @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable;

  private ImmutableJdkOnlyAttributeBuilderParent(
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable,
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle,
      List<FirstPartyImmutable> firstPartyImmutableList,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable,
      List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList,
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive,
      @Nullable FirstPartyImmutable optionalFirstPartyImmutable,
      @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable) {
    this.firstPartyImmutable = firstPartyImmutable;
    this.firstPartyImmutableWithDifferentStyle = firstPartyImmutableWithDifferentStyle;
    this.firstPartyImmutableList = firstPartyImmutableList;
    this.thirdPartyImmutable = thirdPartyImmutable;
    this.thirdPartyImmutableList = thirdPartyImmutableList;
    this.thirdPartyImmutableWithPrimitive = thirdPartyImmutableWithPrimitive;
    this.optionalFirstPartyImmutable = optionalFirstPartyImmutable;
    this.nullableFirstPartyImmutable = nullableFirstPartyImmutable;
  }

  /**
   * @return The value of the {@code firstPartyImmutable} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable firstPartyImmutable() {
    return firstPartyImmutable;
  }

  /**
   * @return The value of the {@code firstPartyImmutableWithDifferentStyle} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle() {
    return firstPartyImmutableWithDifferentStyle;
  }

  /**
   * @return The value of the {@code firstPartyImmutableList} attribute
   */
  @Override
  public List<FirstPartyImmutable> firstPartyImmutableList() {
    return firstPartyImmutableList;
  }

  /**
   * @return The value of the {@code thirdPartyImmutable} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable() {
    return thirdPartyImmutable;
  }

  /**
   * @return The value of the {@code thirdPartyImmutableList} attribute
   */
  @Override
  public List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> thirdPartyImmutableList() {
    return thirdPartyImmutableList;
  }

  /**
   * @return The value of the {@code thirdPartyImmutableWithPrimitive} attribute
   */
  @Override
  public org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive() {
    return thirdPartyImmutableWithPrimitive;
  }

  /**
   * @return The value of the {@code optionalFirstPartyImmutable} attribute
   */
  @Override
  public Optional<FirstPartyImmutable> optionalFirstPartyImmutable() {
    return Optional.ofNullable(optionalFirstPartyImmutable);
  }

  /**
   * @return The value of the {@code nullableFirstPartyImmutable} attribute
   */
  @Override
  public @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable nullableFirstPartyImmutable() {
    return nullableFirstPartyImmutable;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkOnlyAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstPartyImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withFirstPartyImmutable(FirstPartyImmutable value) {
    if (this.firstPartyImmutable == value) return this;
    org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    return new ImmutableJdkOnlyAttributeBuilderParent(
        newValue,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for firstPartyImmutableWithDifferentStyle
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withFirstPartyImmutableWithDifferentStyle(FirstPartyImmutableWithDifferentStyle value) {
    if (this.firstPartyImmutableWithDifferentStyle == value) return this;
    org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        newValue,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withFirstPartyImmutableList(FirstPartyImmutable... elements) {
    List<FirstPartyImmutable> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        newValue,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of firstPartyImmutableList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withFirstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
    if (this.firstPartyImmutableList == elements) return this;
    List<FirstPartyImmutable> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        newValue,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdPartyImmutable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (this.thirdPartyImmutable == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable newValue = Objects.requireNonNull(value, "thirdPartyImmutable");
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        newValue,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... elements) {
    List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        newValue,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of thirdPartyImmutableList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withThirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
    if (this.thirdPartyImmutableList == elements) return this;
    List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        newValue,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for thirdPartyImmutableWithPrimitive
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withThirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (this.thirdPartyImmutableWithPrimitive == value) return this;
    org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive newValue = Objects.requireNonNull(value, "thirdPartyImmutableWithPrimitive");
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        newValue,
        this.optionalFirstPartyImmutable,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOnlyAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} attribute.
   * @param value The value for optionalFirstPartyImmutable
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withOptionalFirstPartyImmutable(FirstPartyImmutable value) {
    FirstPartyImmutable newValue = Objects.requireNonNull(value, "optionalFirstPartyImmutable");
    if (this.optionalFirstPartyImmutable == newValue) return this;
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        newValue,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOnlyAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optionalFirstPartyImmutable
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableJdkOnlyAttributeBuilderParent withOptionalFirstPartyImmutable(Optional<? extends FirstPartyImmutable> optional) {
    @Nullable FirstPartyImmutable value = optional.orElse(null);
    if (this.optionalFirstPartyImmutable == value) return this;
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        value,
        this.nullableFirstPartyImmutable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JdkOnlyAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullableFirstPartyImmutable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJdkOnlyAttributeBuilderParent withNullableFirstPartyImmutable(@Nullable FirstPartyImmutable value) {
    if (this.nullableFirstPartyImmutable == value) return this;
    @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable newValue = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    return new ImmutableJdkOnlyAttributeBuilderParent(
        this.firstPartyImmutable,
        this.firstPartyImmutableWithDifferentStyle,
        this.firstPartyImmutableList,
        this.thirdPartyImmutable,
        this.thirdPartyImmutableList,
        this.thirdPartyImmutableWithPrimitive,
        this.optionalFirstPartyImmutable,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkOnlyAttributeBuilderParent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJdkOnlyAttributeBuilderParent
        && equalTo(0, (ImmutableJdkOnlyAttributeBuilderParent) another);
  }

  private boolean equalTo(int synthetic, ImmutableJdkOnlyAttributeBuilderParent another) {
    return firstPartyImmutable.equals(another.firstPartyImmutable)
        && firstPartyImmutableWithDifferentStyle.equals(another.firstPartyImmutableWithDifferentStyle)
        && firstPartyImmutableList.equals(another.firstPartyImmutableList)
        && thirdPartyImmutable.equals(another.thirdPartyImmutable)
        && thirdPartyImmutableList.equals(another.thirdPartyImmutableList)
        && thirdPartyImmutableWithPrimitive.equals(another.thirdPartyImmutableWithPrimitive)
        && Objects.equals(optionalFirstPartyImmutable, another.optionalFirstPartyImmutable)
        && Objects.equals(nullableFirstPartyImmutable, another.nullableFirstPartyImmutable);
  }

  /**
   * Computes a hash code from attributes: {@code firstPartyImmutable}, {@code firstPartyImmutableWithDifferentStyle}, {@code firstPartyImmutableList}, {@code thirdPartyImmutable}, {@code thirdPartyImmutableList}, {@code thirdPartyImmutableWithPrimitive}, {@code optionalFirstPartyImmutable}, {@code nullableFirstPartyImmutable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + firstPartyImmutable.hashCode();
    h += (h << 5) + firstPartyImmutableWithDifferentStyle.hashCode();
    h += (h << 5) + firstPartyImmutableList.hashCode();
    h += (h << 5) + thirdPartyImmutable.hashCode();
    h += (h << 5) + thirdPartyImmutableList.hashCode();
    h += (h << 5) + thirdPartyImmutableWithPrimitive.hashCode();
    h += (h << 5) + Objects.hashCode(optionalFirstPartyImmutable);
    h += (h << 5) + Objects.hashCode(nullableFirstPartyImmutable);
    return h;
  }

  /**
   * Prints the immutable value {@code JdkOnlyAttributeBuilderParent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("JdkOnlyAttributeBuilderParent{");
    builder.append("firstPartyImmutable=").append(firstPartyImmutable);
    builder.append(", ");
    builder.append("firstPartyImmutableWithDifferentStyle=").append(firstPartyImmutableWithDifferentStyle);
    builder.append(", ");
    builder.append("firstPartyImmutableList=").append(firstPartyImmutableList);
    builder.append(", ");
    builder.append("thirdPartyImmutable=").append(thirdPartyImmutable);
    builder.append(", ");
    builder.append("thirdPartyImmutableList=").append(thirdPartyImmutableList);
    builder.append(", ");
    builder.append("thirdPartyImmutableWithPrimitive=").append(thirdPartyImmutableWithPrimitive);
    if (optionalFirstPartyImmutable != null) {
      builder.append(", ");
      builder.append("optionalFirstPartyImmutable=").append(optionalFirstPartyImmutable);
    }
    if (nullableFirstPartyImmutable != null) {
      builder.append(", ");
      builder.append("nullableFirstPartyImmutable=").append(nullableFirstPartyImmutable);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link JdkOnlyAttributeBuilderParent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkOnlyAttributeBuilderParent instance
   */
  public static ImmutableJdkOnlyAttributeBuilderParent copyOf(JdkOnlyAttributeBuilderParent instance) {
    if (instance instanceof ImmutableJdkOnlyAttributeBuilderParent) {
      return (ImmutableJdkOnlyAttributeBuilderParent) instance;
    }
    return new JdkOnlyAttributeBuilderParent.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableJdkOnlyAttributeBuilderParent ImmutableJdkOnlyAttributeBuilderParent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JdkOnlyAttributeBuilderParent", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_FIRST_PARTY_IMMUTABLE = 0x1L;
    private static final long INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE = 0x2L;
    private static final long INIT_BIT_THIRD_PARTY_IMMUTABLE = 0x4L;
    private static final long INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutable;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyle;
    private List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> firstPartyImmutableList = new ArrayList<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder>();
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutable;
    private List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> thirdPartyImmutableList = new ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder>();
    private @Nullable org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitive;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutable;
    private @Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutable;

    /**
     * Creates a builder for {@link ImmutableJdkOnlyAttributeBuilderParent ImmutableJdkOnlyAttributeBuilderParent} instances.
     * <pre>
     * new JdkOnlyAttributeBuilderParent.Builder()
     *    .firstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // required {@link JdkOnlyAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable}
     *    .firstPartyImmutableWithDifferentStyle(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutableWithDifferentStyle) // required {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle}
     *    .addFirstPartyImmutable|addAllFirstPartyImmutableList(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} elements
     *    .thirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable) // required {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable}
     *    .addThirdPartyImmutable|addAllThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable) // {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} elements
     *    .thirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive) // required {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive}
     *    .optionalFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable) // optional {@link JdkOnlyAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable}
     *    .nullableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.FirstPartyImmutable | null) // nullable {@link JdkOnlyAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof JdkOnlyAttributeBuilderParent.Builder)) {
        throw new UnsupportedOperationException("Use: new JdkOnlyAttributeBuilderParent.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.functional.AttributeBuilderValueI} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder from(AttributeBuilderValueI instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.builder.JdkOnlyAttributeBuilderParent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder from(JdkOnlyAttributeBuilderParent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof AttributeBuilderValueI) {
        AttributeBuilderValueI instance = (AttributeBuilderValueI) object;
        firstPartyImmutableWithDifferentStyle(instance.firstPartyImmutableWithDifferentStyle());
        thirdPartyImmutableWithPrimitive(instance.thirdPartyImmutableWithPrimitive());
        firstPartyImmutable(instance.firstPartyImmutable());
        @Nullable FirstPartyImmutable nullableFirstPartyImmutableValue = instance.nullableFirstPartyImmutable();
        if (nullableFirstPartyImmutableValue != null) {
          nullableFirstPartyImmutable(nullableFirstPartyImmutableValue);
        }
        addAllThirdPartyImmutableList(instance.thirdPartyImmutableList());
        addAllFirstPartyImmutableList(instance.firstPartyImmutableList());
        thirdPartyImmutable(instance.thirdPartyImmutable());
        Optional<FirstPartyImmutable> optionalFirstPartyImmutableOptional = instance.optionalFirstPartyImmutable();
        if (optionalFirstPartyImmutableOptional.isPresent()) {
          optionalFirstPartyImmutable(optionalFirstPartyImmutableOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link JdkOnlyAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} attribute.
     * @param firstPartyImmutable The value for firstPartyImmutable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder firstPartyImmutable(FirstPartyImmutable firstPartyImmutable) {
      this.firstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutable));
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link JdkOnlyAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutableBuilder() {
      if (this.firstPartyImmutable == null) {
        this.firstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      }
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;

      return this.firstPartyImmutable;
    }

    /**
     * Sets {@link JdkOnlyAttributeBuilderParent#firstPartyImmutable() firstPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder firstPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder firstPartyImmutable) {
      this.firstPartyImmutable = firstPartyImmutable;
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} attribute.
     * @param firstPartyImmutableWithDifferentStyle The value for firstPartyImmutableWithDifferentStyle 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder firstPartyImmutableWithDifferentStyle(FirstPartyImmutableWithDifferentStyle firstPartyImmutableWithDifferentStyle) {
      this.firstPartyImmutableWithDifferentStyle = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(firstPartyImmutableWithDifferentStyle));
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyleBuilder() {
      if (this.firstPartyImmutableWithDifferentStyle == null) {
        this.firstPartyImmutableWithDifferentStyle = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder();
      }
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;

      return this.firstPartyImmutableWithDifferentStyle;
    }

    /**
     * Sets {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableWithDifferentStyle() firstPartyImmutableWithDifferentStyle} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder firstPartyImmutableWithDifferentStyleBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon firstPartyImmutableWithDifferentStyle) {
      this.firstPartyImmutableWithDifferentStyle = firstPartyImmutableWithDifferentStyle;
      initBits &= ~INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds one element to {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param element A firstPartyImmutableList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addFirstPartyImmutable(FirstPartyImmutable element) {
      element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
      this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An array of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addFirstPartyImmutableList(FirstPartyImmutable... elements) {
      for (FirstPartyImmutable element : elements) {
        element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
        this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      }
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds a new builder to the {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list and returns
     * the builder.
     */
    @CanIgnoreReturnValue 
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder addFirstPartyImmutableBuilder() {
      org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      this.firstPartyImmutableList.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An array of firstPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addAllFirstPartyImmutableBuilders(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... elements) {
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : elements) {
        this.firstPartyImmutableList.add(Objects.requireNonNull(element, "firstPartyImmutableList element"));
      }
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Gets the builder elements to {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> firstPartyImmutableBuilders() {
      return createUnmodifiableList(false, this.firstPartyImmutableList);
    }

    /**
     * Sets or replaces all elements for {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder firstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
      this.firstPartyImmutableList.clear();
      return addAllFirstPartyImmutableList(elements);
    }

    /**
     * Adds elements to {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addAllFirstPartyImmutableList(Iterable<? extends FirstPartyImmutable> elements) {
      for (FirstPartyImmutable element : elements) {
        element = convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(element);
        this.firstPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(element, "firstPartyImmutableList element")));
      }
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link JdkOnlyAttributeBuilderParent#firstPartyImmutableList() firstPartyImmutableList} list.
     * @param elements An iterable of firstPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addAllFirstPartyImmutableBuilders(Iterable<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> elements) {
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : elements) {
        this.firstPartyImmutableList.add(Objects.requireNonNull(element, "firstPartyImmutableList element"));
      }
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} attribute.
     * @param thirdPartyImmutable The value for thirdPartyImmutable 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder thirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable thirdPartyImmutable) {
      this.thirdPartyImmutable = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(Objects.requireNonNull(thirdPartyImmutable, "thirdPartyImmutable"));
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutableBuilder() {
      if (this.thirdPartyImmutable == null) {
        this.thirdPartyImmutable = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;

      return this.thirdPartyImmutable;
    }

    /**
     * Sets {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutable() thirdPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder thirdPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder thirdPartyImmutable) {
      this.thirdPartyImmutable = thirdPartyImmutable;
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds one element to {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param element A thirdPartyImmutableList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element) {
      this.thirdPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(Objects.requireNonNull(element, "thirdPartyImmutableList element")));
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An array of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addThirdPartyImmutableList(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... elements) {
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : elements) {
        this.thirdPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(Objects.requireNonNull(element, "thirdPartyImmutableList element")));
      }
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds a new builder to the {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list and returns
     * the builder.
     */
    @CanIgnoreReturnValue 
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder addThirdPartyImmutableBuilder() {
      org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder();
      this.thirdPartyImmutableList.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An array of thirdPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addAllThirdPartyImmutableBuilders(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... elements) {
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : elements) {
        this.thirdPartyImmutableList.add(Objects.requireNonNull(element, "thirdPartyImmutableList element"));
      }
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Gets the builder elements to {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> thirdPartyImmutableBuilders() {
      return createUnmodifiableList(false, this.thirdPartyImmutableList);
    }

    /**
     * Sets or replaces all elements for {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder thirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
      this.thirdPartyImmutableList.clear();
      return addAllThirdPartyImmutableList(elements);
    }

    /**
     * Adds elements to {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addAllThirdPartyImmutableList(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> elements) {
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : elements) {
        this.thirdPartyImmutableList.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(Objects.requireNonNull(element, "thirdPartyImmutableList element")));
      }
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Adds elements to {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableList() thirdPartyImmutableList} list.
     * @param elements An iterable of thirdPartyImmutableList builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder addAllThirdPartyImmutableBuilders(Iterable<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> elements) {
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : elements) {
        this.thirdPartyImmutableList.add(Objects.requireNonNull(element, "thirdPartyImmutableList element"));
      }
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} attribute.
     * @param thirdPartyImmutableWithPrimitive The value for thirdPartyImmutableWithPrimitive 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder thirdPartyImmutableWithPrimitive(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive thirdPartyImmutableWithPrimitive) {
      this.thirdPartyImmutableWithPrimitive = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(Objects.requireNonNull(thirdPartyImmutableWithPrimitive, "thirdPartyImmutableWithPrimitive"));
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitiveBuilder() {
      if (this.thirdPartyImmutableWithPrimitive == null) {
        this.thirdPartyImmutableWithPrimitive = org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder();
      }
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;

      return this.thirdPartyImmutableWithPrimitive;
    }

    /**
     * Sets {@link JdkOnlyAttributeBuilderParent#thirdPartyImmutableWithPrimitive() thirdPartyImmutableWithPrimitive} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder thirdPartyImmutableWithPrimitiveBuilder(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder thirdPartyImmutableWithPrimitive) {
      this.thirdPartyImmutableWithPrimitive = thirdPartyImmutableWithPrimitive;
      initBits &= ~INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the optional value {@link JdkOnlyAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to optionalFirstPartyImmutable.
     * @param optionalFirstPartyImmutable The value for optionalFirstPartyImmutable
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder optionalFirstPartyImmutable(FirstPartyImmutable optionalFirstPartyImmutable) {
      this.optionalFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(Objects.requireNonNull(optionalFirstPartyImmutable, "optionalFirstPartyImmutable"));
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

      /**
       * Returns a builder for {@link JdkOnlyAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable}.
       *
       * Once called, the attribute builder field is set to a new instance of the builder.
       * If called more than once, returns the same builder instance.
       */
      public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutableBuilder() {
        if (this.optionalFirstPartyImmutable == null) {
          this.optionalFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
        }

        return this.optionalFirstPartyImmutable;
      }

      /**
       * Sets {@link JdkOnlyAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to the provided builder.
       */
      @CanIgnoreReturnValue 
      public final JdkOnlyAttributeBuilderParent.Builder optionalFirstPartyImmutableBuilder(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder optionalFirstPartyImmutable) {
        this.optionalFirstPartyImmutable = optionalFirstPartyImmutable;
        return (JdkOnlyAttributeBuilderParent.Builder) this;
      }

    /**
     * Initializes the optional value {@link JdkOnlyAttributeBuilderParent#optionalFirstPartyImmutable() optionalFirstPartyImmutable} to optionalFirstPartyImmutable.
     * @param optionalFirstPartyImmutable The value for optionalFirstPartyImmutable
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder optionalFirstPartyImmutable(Optional<? extends FirstPartyImmutable> optionalFirstPartyImmutable) {
      this.optionalFirstPartyImmutable = convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(optionalFirstPartyImmutable.orElse(null));
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Initializes the value for the {@link JdkOnlyAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} attribute.
     * @param nullableFirstPartyImmutable The value for nullableFirstPartyImmutable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder nullableFirstPartyImmutable(@Nullable FirstPartyImmutable nullableFirstPartyImmutable) {
      this.nullableFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(nullableFirstPartyImmutable == null ? null : convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(nullableFirstPartyImmutable));
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Returns a builder for {@link JdkOnlyAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable}.
     *
     * Once called, the attribute builder field is set to a new instance of the builder.
     * If called more than once, returns the same builder instance.
     */
    public final org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutableBuilder() {
      if (this.nullableFirstPartyImmutable == null) {
        this.nullableFirstPartyImmutable = org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder();
      }

      return this.nullableFirstPartyImmutable;
    }

    /**
     * Sets {@link JdkOnlyAttributeBuilderParent#nullableFirstPartyImmutable() nullableFirstPartyImmutable} to the provided builder.
     */
    @CanIgnoreReturnValue 
    public final JdkOnlyAttributeBuilderParent.Builder nullableFirstPartyImmutableBuilder(@Nullable org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder nullableFirstPartyImmutable) {
      this.nullableFirstPartyImmutable = nullableFirstPartyImmutable;
      return (JdkOnlyAttributeBuilderParent.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableJdkOnlyAttributeBuilderParent ImmutableJdkOnlyAttributeBuilderParent}.
     * @return An immutable instance of JdkOnlyAttributeBuilderParent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJdkOnlyAttributeBuilderParent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJdkOnlyAttributeBuilderParent(
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutable),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(firstPartyImmutableWithDifferentStyle),
          createUnmodifiableList(true, convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(firstPartyImmutableList)),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(thirdPartyImmutable),
          createUnmodifiableList(true, convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(thirdPartyImmutableList)),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(thirdPartyImmutableWithPrimitive),
          convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(optionalFirstPartyImmutable),
          nullableFirstPartyImmutable == null ? null : convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(nullableFirstPartyImmutable));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIRST_PARTY_IMMUTABLE) != 0) attributes.add("firstPartyImmutable");
      if ((initBits & INIT_BIT_FIRST_PARTY_IMMUTABLE_WITH_DIFFERENT_STYLE) != 0) attributes.add("firstPartyImmutableWithDifferentStyle");
      if ((initBits & INIT_BIT_THIRD_PARTY_IMMUTABLE) != 0) attributes.add("thirdPartyImmutable");
      if ((initBits & INIT_BIT_THIRD_PARTY_IMMUTABLE_WITH_PRIMITIVE) != 0) attributes.add("thirdPartyImmutableWithPrimitive");
      return "Cannot build JdkOnlyAttributeBuilderParent, some of required attributes are not set " + attributes;
    }



    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static FirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon builder) {
      if (builder == null) return null;
      return builder.doIIT();
    }

    @Nullable 
    private static FirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value);
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder builder) {
      if (builder == null) return null;
      return builder.doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value).doTheBuild();
    }

    @Nullable 
    private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
      if (value == null) return null;
      return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value);
    }

    private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> builderList) {
      ArrayList<FirstPartyImmutable> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... builderArray) {
      ArrayList<FirstPartyImmutable> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable> valueList) {
      ArrayList<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueList) {
        list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
      }
      return list;
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable... valueArray) {
      ArrayList<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueArray) {
        list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
      }
      return list;
    }
    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> builderList) {
      ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderList) {
        list.add(element.doTheBuild());
      }
      return list;
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... builderArray) {
      ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderArray) {
        list.add(element.doTheBuild());
      }
      return list;
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> valueList) {
      ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueList) {
        list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
      }
      return list;
    }

    private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... valueArray) {
      ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueArray) {
        list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static FirstPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value).build();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(@Nullable  FirstPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon builder) {
    if (builder == null) return null;
    return builder.doIIT();
  }

  @Nullable 
  private static FirstPartyImmutableWithDifferentStyle convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value).doIIT();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.Abonabon convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutableWithDifferentStyle(@Nullable  FirstPartyImmutableWithDifferentStyle value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutableWithDifferentStyle.getTheBuilder().makeDaCopy(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(value);
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder builder) {
    if (builder == null) return null;
    return builder.doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value).doTheBuild();
  }

  @Nullable 
  private static org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.Builder convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutableWithPrimitive(@Nullable  org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive value) {
    if (value == null) return null;
    return org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutableWithPrimitive.generateNewBuilder(value);
  }

  private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> builderList) {
    ArrayList<FirstPartyImmutable> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<FirstPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder... builderArray) {
    ArrayList<FirstPartyImmutable> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable> valueList) {
    ArrayList<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueList) {
      list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
    }
    return list;
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ImmutableFirstPartyImmutable(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable... valueArray) {
    ArrayList<org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable element : valueArray) {
      list.add(org.immutables.fixture.builder.attribute_builders.ImmutableFirstPartyImmutable.builder().from(element));
    }
    return list;
  }
  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> builderList) {
    ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderList) {
      list.add(element.doTheBuild());
    }
    return list;
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> convertToValueTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder... builderArray) {
    ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder element : builderArray) {
      list.add(element.doTheBuild());
    }
    return list;
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(Iterable<? extends org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable> valueList) {
    ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueList) {
      list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
    }
    return list;
  }

  private static List<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> convertToBuilderTypeorg_immutables_fixture_builder_attribute_builders_ThirdPartyImmutable(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable... valueArray) {
    ArrayList<org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable element : valueArray) {
      list.add(org.immutables.fixture.builder.attribute_builders.ThirdPartyImmutable.generateNewBuilder(element));
    }
    return list;
  }
}
