package org.immutables.fixture.annotation;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FallbackNullable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFallbackNullable.builder()}.
 */
@Generated(from = "FallbackNullable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFallbackNullable implements FallbackNullable {
  private final @Nil String jdkOptional;
  private final @Nil String nullable;

  private ImmutableFallbackNullable(
      @Nil String jdkOptional,
      @Nil String nullable) {
    this.jdkOptional = jdkOptional;
    this.nullable = nullable;
  }

  /**
   * @return The value of the {@code jdkOptional} attribute
   */
  @Override
  public Optional<String> jdkOptional() {
    return Optional.ofNullable(jdkOptional);
  }

  /**
   * @return The value of the {@code nullable} attribute
   */
  @Override
  public @Nil String nullable() {
    return nullable;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FallbackNullable#jdkOptional() jdkOptional} attribute.
   * @param value The value for jdkOptional, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFallbackNullable withJdkOptional(@Nil String value) {
    @Nil String newValue = value;
    if (Objects.equals(this.jdkOptional, newValue)) return this;
    return new ImmutableFallbackNullable(newValue, this.nullable);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FallbackNullable#jdkOptional() jdkOptional} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for jdkOptional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFallbackNullable withJdkOptional(Optional<String> optional) {
    @Nil String value = optional.orElse(null);
    if (Objects.equals(this.jdkOptional, value)) return this;
    return new ImmutableFallbackNullable(value, this.nullable);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FallbackNullable#nullable() nullable} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullable (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFallbackNullable withNullable(@Nil String value) {
    if (Objects.equals(this.nullable, value)) return this;
    return new ImmutableFallbackNullable(this.jdkOptional, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFallbackNullable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nil Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFallbackNullable
        && equalTo(0, (ImmutableFallbackNullable) another);
  }

  private boolean equalTo(int synthetic, ImmutableFallbackNullable another) {
    return Objects.equals(jdkOptional, another.jdkOptional)
        && Objects.equals(nullable, another.nullable);
  }

  /**
   * Computes a hash code from attributes: {@code jdkOptional}, {@code nullable}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(jdkOptional);
    h += (h << 5) + Objects.hashCode(nullable);
    return h;
  }

  /**
   * Prints the immutable value {@code FallbackNullable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FallbackNullable")
        .omitNullValues()
        .add("jdkOptional", jdkOptional)
        .add("nullable", nullable)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FallbackNullable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FallbackNullable instance
   */
  public static ImmutableFallbackNullable copyOf(FallbackNullable instance) {
    if (instance instanceof ImmutableFallbackNullable) {
      return (ImmutableFallbackNullable) instance;
    }
    return ImmutableFallbackNullable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFallbackNullable ImmutableFallbackNullable}.
   * <pre>
   * ImmutableFallbackNullable.builder()
   *    .jdkOptional(String) // optional {@link FallbackNullable#jdkOptional() jdkOptional}
   *    .nullable(String | null) // nullable {@link FallbackNullable#nullable() nullable}
   *    .build();
   * </pre>
   * @return A new ImmutableFallbackNullable builder
   */
  public static ImmutableFallbackNullable.Builder builder() {
    return new ImmutableFallbackNullable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFallbackNullable ImmutableFallbackNullable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FallbackNullable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nil String jdkOptional;
    private @Nil String nullable;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FallbackNullable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FallbackNullable instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> jdkOptionalOptional = instance.jdkOptional();
      if (jdkOptionalOptional.isPresent()) {
        jdkOptional(jdkOptionalOptional);
      }
      @Nil String nullableValue = instance.nullable();
      if (nullableValue != null) {
        nullable(nullableValue);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link FallbackNullable#jdkOptional() jdkOptional} to jdkOptional.
     * @param jdkOptional The value for jdkOptional, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder jdkOptional(@Nil String jdkOptional) {
      this.jdkOptional = jdkOptional;
      return this;
    }

    /**
     * Initializes the optional value {@link FallbackNullable#jdkOptional() jdkOptional} to jdkOptional.
     * @param jdkOptional The value for jdkOptional
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder jdkOptional(Optional<String> jdkOptional) {
      this.jdkOptional = jdkOptional.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link FallbackNullable#nullable() nullable} attribute.
     * @param nullable The value for nullable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nullable(@Nil String nullable) {
      this.nullable = nullable;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFallbackNullable ImmutableFallbackNullable}.
     * @return An immutable instance of FallbackNullable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFallbackNullable build() {
      return new ImmutableFallbackNullable(jdkOptional, nullable);
    }
  }
}
