package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValDerivedCollection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValDerivedCollection.builder()}.
 */
@Generated(from = "ValDerivedCollection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableValDerivedCollection extends ValDerivedCollection {
  private transient final Set<Integer> available;

  private ImmutableValDerivedCollection(ImmutableValDerivedCollection.Builder builder) {
    this.available = Objects.requireNonNull(super.available(), "available");
  }

  /**
   * @return The computed-at-construction value of the {@code available} attribute
   */
  @Override
  Set<Integer> available() {
    return available;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValDerivedCollection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValDerivedCollection
        && equalTo(0, (ImmutableValDerivedCollection) another);
  }

  private boolean equalTo(int synthetic, ImmutableValDerivedCollection another) {
    return available.equals(another.available);
  }

  /**
   * Computes a hash code from attributes: {@code available}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + available.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValDerivedCollection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValDerivedCollection")
        .omitNullValues()
        .add("available", available)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ValDerivedCollection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValDerivedCollection instance
   */
  public static ImmutableValDerivedCollection copyOf(ValDerivedCollection instance) {
    if (instance instanceof ImmutableValDerivedCollection) {
      return (ImmutableValDerivedCollection) instance;
    }
    return ImmutableValDerivedCollection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValDerivedCollection ImmutableValDerivedCollection}.
   * <pre>
   * ImmutableValDerivedCollection.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableValDerivedCollection builder
   */
  public static ImmutableValDerivedCollection.Builder builder() {
    return new ImmutableValDerivedCollection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValDerivedCollection ImmutableValDerivedCollection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValDerivedCollection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValDerivedCollection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValDerivedCollection instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableValDerivedCollection ImmutableValDerivedCollection}.
     * @return An immutable instance of ValDerivedCollection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValDerivedCollection build() {
      return new ImmutableValDerivedCollection(this);
    }
  }
}
