package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Sing2}.
 * <p>
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableSing2.of()}.
 */
@Generated(from = "Sing2", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSing2 implements Sing2 {
  private final int a;

  private ImmutableSing2() {
    this.a = Sing2.super.a();
  }

  private ImmutableSing2(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Sing2#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSing2 withA(int value) {
    if (this.a == value) return this;
    return validate(new ImmutableSing2(value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSing2} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSing2
        && equalTo(0, (ImmutableSing2) another);
  }

  private boolean equalTo(int synthetic, ImmutableSing2 another) {
    return a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    return h;
  }

  /**
   * Prints the immutable value {@code Sing2} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Sing2")
        .omitNullValues()
        .add("a", a)
        .toString();
  }

  private static final ImmutableSing2 INSTANCE = validate(new ImmutableSing2());

  /**
   * Returns the default immutable singleton value of {@code Sing2}
   * @return An immutable instance of Sing2
   */
  public static ImmutableSing2 of() {
    return INSTANCE;
  }

  private static ImmutableSing2 validate(ImmutableSing2 instance) {
    return instance;
  }
}
