package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyValidatedBuiltValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyValidatedBuiltValue.builder()}.
 */
@Generated(from = "SillyValidatedBuiltValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyValidatedBuiltValue extends SillyValidatedBuiltValue {
  private final int value;
  private final boolean negativeOnly;

  private ImmutableSillyValidatedBuiltValue(int value, boolean negativeOnly) {
    this.value = value;
    this.negativeOnly = negativeOnly;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public int value() {
    return value;
  }

  /**
   * @return The value of the {@code negativeOnly} attribute
   */
  @Override
  public boolean negativeOnly() {
    return negativeOnly;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyValidatedBuiltValue#value() value} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyValidatedBuiltValue withValue(int value) {
    if (this.value == value) return this;
    return validate(new ImmutableSillyValidatedBuiltValue(value, this.negativeOnly));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyValidatedBuiltValue#negativeOnly() negativeOnly} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for negativeOnly
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyValidatedBuiltValue withNegativeOnly(boolean value) {
    if (this.negativeOnly == value) return this;
    return validate(new ImmutableSillyValidatedBuiltValue(this.value, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyValidatedBuiltValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyValidatedBuiltValue
        && equalTo(0, (ImmutableSillyValidatedBuiltValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyValidatedBuiltValue another) {
    return value == another.value
        && negativeOnly == another.negativeOnly;
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code negativeOnly}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value;
    h += (h << 5) + Booleans.hashCode(negativeOnly);
    return h;
  }

  /**
   * Prints the immutable value {@code SillyValidatedBuiltValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyValidatedBuiltValue")
        .omitNullValues()
        .add("value", value)
        .add("negativeOnly", negativeOnly)
        .toString();
  }

  private static ImmutableSillyValidatedBuiltValue validate(ImmutableSillyValidatedBuiltValue instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link SillyValidatedBuiltValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyValidatedBuiltValue instance
   */
  public static ImmutableSillyValidatedBuiltValue copyOf(SillyValidatedBuiltValue instance) {
    if (instance instanceof ImmutableSillyValidatedBuiltValue) {
      return (ImmutableSillyValidatedBuiltValue) instance;
    }
    return ImmutableSillyValidatedBuiltValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyValidatedBuiltValue ImmutableSillyValidatedBuiltValue}.
   * <pre>
   * ImmutableSillyValidatedBuiltValue.builder()
   *    .value(int) // required {@link SillyValidatedBuiltValue#value() value}
   *    .negativeOnly(boolean) // required {@link SillyValidatedBuiltValue#negativeOnly() negativeOnly}
   *    .build();
   * </pre>
   * @return A new ImmutableSillyValidatedBuiltValue builder
   */
  public static ImmutableSillyValidatedBuiltValue.Builder builder() {
    return new ImmutableSillyValidatedBuiltValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyValidatedBuiltValue ImmutableSillyValidatedBuiltValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyValidatedBuiltValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_NEGATIVE_ONLY = 0x2L;
    private long initBits = 0x3L;

    private int value;
    private boolean negativeOnly;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyValidatedBuiltValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyValidatedBuiltValue instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.value());
      negativeOnly(instance.negativeOnly());
      return this;
    }

    /**
     * Initializes the value for the {@link SillyValidatedBuiltValue#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(int value) {
      this.value = value;
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link SillyValidatedBuiltValue#negativeOnly() negativeOnly} attribute.
     * @param negativeOnly The value for negativeOnly 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder negativeOnly(boolean negativeOnly) {
      this.negativeOnly = negativeOnly;
      initBits &= ~INIT_BIT_NEGATIVE_ONLY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyValidatedBuiltValue ImmutableSillyValidatedBuiltValue}.
     * @return An immutable instance of SillyValidatedBuiltValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyValidatedBuiltValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableSillyValidatedBuiltValue.validate(new ImmutableSillyValidatedBuiltValue(value, negativeOnly));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_NEGATIVE_ONLY) != 0) attributes.add("negativeOnly");
      return "Cannot build SillyValidatedBuiltValue, some of required attributes are not set " + attributes;
    }
  }
}
