package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Floats;
import com.google.errorprone.annotations.Var;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyTuplie}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSillyTuplie.of()}.
 */
@Generated(from = "SillyTuplie", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyTuplie extends SillyTuplie {
  private final float float1;
  private final Optional<Byte> opt2;
  private final ImmutableSet<Boolean> set3;

  private ImmutableSillyTuplie(
      float float1,
      Optional<Byte> opt2,
      Iterable<Boolean> set3) {
    this.float1 = float1;
    this.opt2 = opt2;
    this.set3 = ImmutableSet.copyOf(set3);
  }

  private ImmutableSillyTuplie(
      ImmutableSillyTuplie original,
      float float1,
      Optional<Byte> opt2,
      ImmutableSet<Boolean> set3) {
    this.float1 = float1;
    this.opt2 = opt2;
    this.set3 = set3;
  }

  /**
   * @return The value of the {@code float1} attribute
   */
  @Override
  public float float1() {
    return float1;
  }

  /**
   * @return The value of the {@code opt2} attribute
   */
  @Override
  public Optional<Byte> opt2() {
    return opt2;
  }

  /**
   * @return The value of the {@code set3} attribute
   */
  @Override
  public ImmutableSet<Boolean> set3() {
    return set3;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyTuplie#float1() float1} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for float1
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyTuplie withFloat1(float value) {
    if (Float.floatToIntBits(this.float1) == Float.floatToIntBits(value)) return this;
    return new ImmutableSillyTuplie(this, value, this.opt2, this.set3);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SillyTuplie#opt2() opt2} attribute.
   * @param value The value for opt2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyTuplie withOpt2(byte value) {
    Optional<Byte> newValue = Optional.of(value);
    if (this.opt2.equals(newValue)) return this;
    return new ImmutableSillyTuplie(this, this.float1, newValue, this.set3);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SillyTuplie#opt2() opt2} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for opt2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyTuplie withOpt2(Optional<Byte> optional) {
    Optional<Byte> value = optional;
    if (this.opt2.equals(value)) return this;
    return new ImmutableSillyTuplie(this, this.float1, value, this.set3);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyTuplie#set3() set3}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyTuplie withSet3(boolean... elements) {
    ImmutableSet<Boolean> newValue = ImmutableSet.copyOf(Booleans.asList(elements));
    return new ImmutableSillyTuplie(this, this.float1, this.opt2, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyTuplie#set3() set3}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of set3 elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyTuplie withSet3(Iterable<Boolean> elements) {
    if (this.set3 == elements) return this;
    ImmutableSet<Boolean> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableSillyTuplie(this, this.float1, this.opt2, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyTuplie} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyTuplie
        && equalTo(0, (ImmutableSillyTuplie) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyTuplie another) {
    return Float.floatToIntBits(float1) == Float.floatToIntBits(another.float1)
        && opt2.equals(another.opt2)
        && set3.equals(another.set3);
  }

  /**
   * Computes a hash code from attributes: {@code float1}, {@code opt2}, {@code set3}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Floats.hashCode(float1);
    h += (h << 5) + opt2.hashCode();
    h += (h << 5) + set3.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillyTuplie} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyTuplie")
        .omitNullValues()
        .add("float1", float1)
        .add("opt2", opt2.orNull())
        .add("set3", set3)
        .toString();
  }

  /**
   * Construct a new immutable {@code SillyTuplie} instance.
   * @param float1 The value for the {@code float1} attribute
   * @param opt2 The value for the {@code opt2} attribute
   * @param set3 The value for the {@code set3} attribute
   * @return An immutable SillyTuplie instance
   */
  public static ImmutableSillyTuplie of(float float1, Optional<Byte> opt2, Set<Boolean> set3) {
    return of(float1, opt2, (Iterable<Boolean>) set3);
  }

  /**
   * Construct a new immutable {@code SillyTuplie} instance.
   * @param float1 The value for the {@code float1} attribute
   * @param opt2 The value for the {@code opt2} attribute
   * @param set3 The value for the {@code set3} attribute
   * @return An immutable SillyTuplie instance
   */
  public static ImmutableSillyTuplie of(float float1, Optional<Byte> opt2, Iterable<Boolean> set3) {
    return new ImmutableSillyTuplie(float1, opt2, set3);
  }

  /**
   * Creates an immutable copy of a {@link SillyTuplie} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyTuplie instance
   */
  public static ImmutableSillyTuplie copyOf(SillyTuplie instance) {
    if (instance instanceof ImmutableSillyTuplie) {
      return (ImmutableSillyTuplie) instance;
    }
    return ImmutableSillyTuplie.of(instance.float1(), instance.opt2(), instance.set3());
  }
}
