package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillySub3}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillySub3.builder()}.
 */
@Generated(from = "SillySub3", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillySub3 extends SillySub3 {
  private final ImmutableList<Double> b;

  private ImmutableSillySub3(ImmutableList<Double> b) {
    this.b = b;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public ImmutableList<Double> b() {
    return b;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillySub3#b() b}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillySub3 withB(double... elements) {
    ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
    return new ImmutableSillySub3(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillySub3#b() b}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of b elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillySub3 withB(Iterable<Double> elements) {
    if (this.b == elements) return this;
    ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSillySub3(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillySub3} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillySub3
        && equalTo(0, (ImmutableSillySub3) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillySub3 another) {
    return b.equals(another.b);
  }

  /**
   * Computes a hash code from attributes: {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + b.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillySub3} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillySub3")
        .omitNullValues()
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SillySub3} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillySub3 instance
   */
  public static ImmutableSillySub3 copyOf(SillySub3 instance) {
    if (instance instanceof ImmutableSillySub3) {
      return (ImmutableSillySub3) instance;
    }
    return ImmutableSillySub3.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillySub3 ImmutableSillySub3}.
   * <pre>
   * ImmutableSillySub3.builder()
   *    .addB|addAllB(double) // {@link SillySub3#b() b} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSillySub3 builder
   */
  public static ImmutableSillySub3.Builder builder() {
    return new ImmutableSillySub3.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillySub3 ImmutableSillySub3}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillySub3", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<Double> b = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillySub3} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillySub3 instance) {
      Objects.requireNonNull(instance, "instance");
      addAllB(instance.b());
      return this;
    }

    /**
     * Adds one element to {@link SillySub3#b() b} list.
     * @param element A b element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(double element) {
      this.b.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SillySub3#b() b} list.
     * @param elements An array of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(double... elements) {
      this.b.addAll(Doubles.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SillySub3#b() b} list.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(Iterable<Double> elements) {
      this.b = ImmutableList.builder();
      return addAllB(elements);
    }

    /**
     * Adds elements to {@link SillySub3#b() b} list.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllB(Iterable<Double> elements) {
      this.b.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillySub3 ImmutableSillySub3}.
     * @return An immutable instance of SillySub3
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillySub3 build() {
      return new ImmutableSillySub3(b.build());
    }
  }
}
