package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyPolyHost2}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyPolyHost2.builder()}.
 */
@Generated(from = "SillyPolyHost2", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyPolyHost2 extends SillyPolyHost2 {
  private final SillyAbstract s;
  private final Optional<SillyAbstract> o;

  private ImmutableSillyPolyHost2(
      SillyAbstract s,
      Optional<SillyAbstract> o) {
    this.s = s;
    this.o = o;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @Override
  public SillyAbstract s() {
    return s;
  }

  /**
   * @return The value of the {@code o} attribute
   */
  @Override
  public Optional<SillyAbstract> o() {
    return o;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyPolyHost2#s() s} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for s
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyPolyHost2 withS(SillyAbstract value) {
    if (this.s == value) return this;
    SillyAbstract newValue = Objects.requireNonNull(value, "s");
    return new ImmutableSillyPolyHost2(newValue, this.o);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SillyPolyHost2#o() o} attribute.
   * @param value The value for o
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyPolyHost2 withO(SillyAbstract value) {
    Optional<SillyAbstract> newValue = Optional.of(value);
    if (this.o.isPresent() && this.o.get() == value) return this;
    return new ImmutableSillyPolyHost2(this.s, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SillyPolyHost2#o() o} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for o
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableSillyPolyHost2 withO(Optional<? extends SillyAbstract> optional) {
    Optional<SillyAbstract> value = (Optional<SillyAbstract>) optional;
    if (!this.o.isPresent() && !value.isPresent()) return this;
    if (this.o.isPresent() && value.isPresent() && this.o.get() == value.get()) return this;
    return new ImmutableSillyPolyHost2(this.s, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyPolyHost2} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyPolyHost2
        && equalTo(0, (ImmutableSillyPolyHost2) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyPolyHost2 another) {
    return s.equals(another.s)
        && o.equals(another.o);
  }

  /**
   * Computes a hash code from attributes: {@code s}, {@code o}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + s.hashCode();
    h += (h << 5) + o.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillyPolyHost2} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyPolyHost2")
        .omitNullValues()
        .add("s", s)
        .add("o", o.orNull())
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SillyPolyHost2} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyPolyHost2 instance
   */
  public static ImmutableSillyPolyHost2 copyOf(SillyPolyHost2 instance) {
    if (instance instanceof ImmutableSillyPolyHost2) {
      return (ImmutableSillyPolyHost2) instance;
    }
    return ImmutableSillyPolyHost2.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyPolyHost2 ImmutableSillyPolyHost2}.
   * <pre>
   * ImmutableSillyPolyHost2.builder()
   *    .s(org.immutables.fixture.SillyAbstract) // required {@link SillyPolyHost2#s() s}
   *    .o(org.immutables.fixture.SillyAbstract) // optional {@link SillyPolyHost2#o() o}
   *    .build();
   * </pre>
   * @return A new ImmutableSillyPolyHost2 builder
   */
  public static ImmutableSillyPolyHost2.Builder builder() {
    return new ImmutableSillyPolyHost2.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyPolyHost2 ImmutableSillyPolyHost2}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyPolyHost2", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_S = 0x1L;
    private long initBits = 0x1L;

    private @Nullable SillyAbstract s;
    private Optional<SillyAbstract> o = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyPolyHost2} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyPolyHost2 instance) {
      Objects.requireNonNull(instance, "instance");
      s(instance.s());
      Optional<SillyAbstract> oOptional = instance.o();
      if (oOptional.isPresent()) {
        o(oOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SillyPolyHost2#s() s} attribute.
     * @param s The value for s 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder s(SillyAbstract s) {
      this.s = Objects.requireNonNull(s, "s");
      initBits &= ~INIT_BIT_S;
      return this;
    }

    /**
     * Initializes the optional value {@link SillyPolyHost2#o() o} to o.
     * @param o The value for o
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder o(SillyAbstract o) {
      this.o = Optional.of(o);
      return this;
    }

    /**
     * Initializes the optional value {@link SillyPolyHost2#o() o} to o.
     * @param o The value for o
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    public final Builder o(Optional<? extends SillyAbstract> o) {
      this.o = (Optional<SillyAbstract>) o;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyPolyHost2 ImmutableSillyPolyHost2}.
     * @return An immutable instance of SillyPolyHost2
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyPolyHost2 build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSillyPolyHost2(s, o);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_S) != 0) attributes.add("s");
      return "Cannot build SillyPolyHost2, some of required attributes are not set " + attributes;
    }
  }
}
