package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyLazy}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyLazy.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableSillyLazy.of()}.
 */
@Generated(from = "SillyLazy", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyLazy extends SillyLazy {
  private final AtomicInteger counter;

  private ImmutableSillyLazy(AtomicInteger counter) {
    this.counter = Objects.requireNonNull(counter, "counter");
  }

  private ImmutableSillyLazy(ImmutableSillyLazy original, AtomicInteger counter) {
    this.counter = counter;
  }

  /**
   * @return The value of the {@code counter} attribute
   */
  @Override
  public AtomicInteger counter() {
    return counter;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyLazy#counter() counter} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for counter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyLazy withCounter(AtomicInteger value) {
    AtomicInteger newValue = Objects.requireNonNull(value, "counter");
    if (this.counter.equals(newValue)) return this;
    return new ImmutableSillyLazy(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyLazy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyLazy
        && equalTo(0, (ImmutableSillyLazy) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyLazy another) {
    return counter.equals(another.counter);
  }

  /**
   * Computes a hash code from attributes: {@code counter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + counter.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillyLazy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyLazy")
        .omitNullValues()
        .add("counter", counter)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long VAL1_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient int val1;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link SillyLazy#val1() val1} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code val1} attribute
   */
  @Override
  public int val1() {
    if ((lazyInitBitmap & VAL1_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VAL1_LAZY_INIT_BIT) == 0) {
          this.val1 = super.val1();
          lazyInitBitmap |= VAL1_LAZY_INIT_BIT;
        }
      }
    }
    return val1;
  }

  private static final long VAL2_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient int val2;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link SillyLazy#val2() val2} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code val2} attribute
   */
  @Override
  public int val2() {
    if ((lazyInitBitmap & VAL2_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & VAL2_LAZY_INIT_BIT) == 0) {
          this.val2 = super.val2();
          lazyInitBitmap |= VAL2_LAZY_INIT_BIT;
        }
      }
    }
    return val2;
  }

  /**
   * Construct a new immutable {@code SillyLazy} instance.
   * @param counter The value for the {@code counter} attribute
   * @return An immutable SillyLazy instance
   */
  public static ImmutableSillyLazy of(AtomicInteger counter) {
    return new ImmutableSillyLazy(counter);
  }

  /**
   * Creates an immutable copy of a {@link SillyLazy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyLazy instance
   */
  public static ImmutableSillyLazy copyOf(SillyLazy instance) {
    if (instance instanceof ImmutableSillyLazy) {
      return (ImmutableSillyLazy) instance;
    }
    return ImmutableSillyLazy.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyLazy ImmutableSillyLazy}.
   * <pre>
   * ImmutableSillyLazy.builder()
   *    .counter(concurrent.atomic.AtomicInteger) // required {@link SillyLazy#counter() counter}
   *    .build();
   * </pre>
   * @return A new ImmutableSillyLazy builder
   */
  public static ImmutableSillyLazy.Builder builder() {
    return new ImmutableSillyLazy.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyLazy ImmutableSillyLazy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyLazy", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COUNTER = 0x1L;
    private long initBits = 0x1L;

    private @Nullable AtomicInteger counter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyLazy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyLazy instance) {
      Objects.requireNonNull(instance, "instance");
      counter(instance.counter());
      return this;
    }

    /**
     * Initializes the value for the {@link SillyLazy#counter() counter} attribute.
     * @param counter The value for counter 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder counter(AtomicInteger counter) {
      this.counter = Objects.requireNonNull(counter, "counter");
      initBits &= ~INIT_BIT_COUNTER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyLazy ImmutableSillyLazy}.
     * @return An immutable instance of SillyLazy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyLazy build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSillyLazy(null, counter);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COUNTER) != 0) attributes.add("counter");
      return "Cannot build SillyLazy, some of required attributes are not set " + attributes;
    }
  }
}
