package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.mongo.types.Id;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyEntitySecond}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyEntitySecond.builder()}.
 */
@Generated(from = "SillyEntitySecond", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyEntitySecond extends SillyEntitySecond {
  private final Id id;

  private ImmutableSillyEntitySecond(ImmutableSillyEntitySecond.Builder builder) {
    this.id = builder.id != null
        ? builder.id
        : Objects.requireNonNull(super.id(), "id");
  }

  private ImmutableSillyEntitySecond(Id id) {
    this.id = id;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public Id id() {
    return id;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyEntitySecond#id() id} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyEntitySecond withId(Id value) {
    if (this.id == value) return this;
    Id newValue = Objects.requireNonNull(value, "id");
    return new ImmutableSillyEntitySecond(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyEntitySecond} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyEntitySecond
        && equalTo(0, (ImmutableSillyEntitySecond) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyEntitySecond another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillyEntitySecond} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyEntitySecond")
        .omitNullValues()
        .add("id", id)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SillyEntitySecond} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyEntitySecond instance
   */
  public static ImmutableSillyEntitySecond copyOf(SillyEntitySecond instance) {
    if (instance instanceof ImmutableSillyEntitySecond) {
      return (ImmutableSillyEntitySecond) instance;
    }
    return ImmutableSillyEntitySecond.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyEntitySecond ImmutableSillyEntitySecond}.
   * <pre>
   * ImmutableSillyEntitySecond.builder()
   *    .id(org.immutables.mongo.types.Id) // optional {@link SillyEntitySecond#id() id}
   *    .build();
   * </pre>
   * @return A new ImmutableSillyEntitySecond builder
   */
  public static ImmutableSillyEntitySecond.Builder builder() {
    return new ImmutableSillyEntitySecond.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyEntitySecond ImmutableSillyEntitySecond}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyEntitySecond", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Id id;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyEntitySecond} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyEntitySecond instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      return this;
    }

    /**
     * Initializes the value for the {@link SillyEntitySecond#id() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SillyEntitySecond#id() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(Id id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyEntitySecond ImmutableSillyEntitySecond}.
     * @return An immutable instance of SillyEntitySecond
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyEntitySecond build() {
      return new ImmutableSillyEntitySecond(this);
    }
  }
}
