package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillyEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillyEntity.builder()}.
 */
@Generated(from = "SillyEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillyEntity extends SillyEntity {
  private final int id;
  private final String val;
  private final ImmutableMap<String, Integer> payload;
  private final ImmutableList<Integer> ints;
  private transient final UnsignedInteger der;

  private ImmutableSillyEntity(
      int id,
      String val,
      ImmutableMap<String, Integer> payload,
      ImmutableList<Integer> ints) {
    this.id = id;
    this.val = val;
    this.payload = payload;
    this.ints = ints;
    this.der = Objects.requireNonNull(super.der(), "der");
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public int id() {
    return id;
  }

  /**
   * @return The value of the {@code val} attribute
   */
  @Override
  public String val() {
    return val;
  }

  /**
   * @return The value of the {@code payload} attribute
   */
  @Override
  public ImmutableMap<String, Integer> payload() {
    return payload;
  }

  /**
   * @return The value of the {@code ints} attribute
   */
  @Override
  public ImmutableList<Integer> ints() {
    return ints;
  }

  /**
   * @return The computed-at-construction value of the {@code der} attribute
   */
  @Override
  public UnsignedInteger der() {
    return der;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyEntity#id() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyEntity withId(int value) {
    if (this.id == value) return this;
    return new ImmutableSillyEntity(value, this.val, this.payload, this.ints);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillyEntity#val() val} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for val
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillyEntity withVal(String value) {
    String newValue = Objects.requireNonNull(value, "val");
    if (this.val.equals(newValue)) return this;
    return new ImmutableSillyEntity(this.id, newValue, this.payload, this.ints);
  }

  /**
   * Copy the current immutable object by replacing the {@link SillyEntity#payload() payload} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the payload map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyEntity withPayload(Map<String, ? extends Integer> entries) {
    if (this.payload == entries) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableSillyEntity(this.id, this.val, newValue, this.ints);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyEntity#ints() ints}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyEntity withInts(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableSillyEntity(this.id, this.val, this.payload, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillyEntity#ints() ints}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ints elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillyEntity withInts(Iterable<Integer> elements) {
    if (this.ints == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSillyEntity(this.id, this.val, this.payload, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillyEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillyEntity
        && equalTo(0, (ImmutableSillyEntity) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillyEntity another) {
    return id == another.id
        && val.equals(another.val)
        && payload.equals(another.payload)
        && ints.equals(another.ints)
        && der.equals(another.der);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code val}, {@code payload}, {@code ints}, {@code der}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id;
    h += (h << 5) + val.hashCode();
    h += (h << 5) + payload.hashCode();
    h += (h << 5) + ints.hashCode();
    h += (h << 5) + der.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillyEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillyEntity")
        .omitNullValues()
        .add("id", id)
        .add("val", val)
        .add("payload", payload)
        .add("ints", ints)
        .add("der", der)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SillyEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillyEntity instance
   */
  public static ImmutableSillyEntity copyOf(SillyEntity instance) {
    if (instance instanceof ImmutableSillyEntity) {
      return (ImmutableSillyEntity) instance;
    }
    return ImmutableSillyEntity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillyEntity ImmutableSillyEntity}.
   * <pre>
   * ImmutableSillyEntity.builder()
   *    .id(int) // required {@link SillyEntity#id() id}
   *    .val(String) // required {@link SillyEntity#val() val}
   *    .putPayload|putAllPayload(String =&gt; int) // {@link SillyEntity#payload() payload} mappings
   *    .addInts|addAllInts(int) // {@link SillyEntity#ints() ints} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSillyEntity builder
   */
  public static ImmutableSillyEntity.Builder builder() {
    return new ImmutableSillyEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillyEntity ImmutableSillyEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillyEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_VAL = 0x2L;
    private long initBits = 0x3L;

    private int id;
    private @Nullable String val;
    private ImmutableMap.Builder<String, Integer> payload = ImmutableMap.builder();
    private ImmutableList.Builder<Integer> ints = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillyEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillyEntity instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      val(instance.val());
      putAllPayload(instance.payload());
      addAllInts(instance.ints());
      return this;
    }

    /**
     * Initializes the value for the {@link SillyEntity#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(int id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SillyEntity#val() val} attribute.
     * @param val The value for val 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder val(String val) {
      this.val = Objects.requireNonNull(val, "val");
      initBits &= ~INIT_BIT_VAL;
      return this;
    }

    /**
     * Put one entry to the {@link SillyEntity#payload() payload} map.
     * @param key The key in the payload map
     * @param value The associated value in the payload map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPayload(String key, int value) {
      this.payload.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SillyEntity#payload() payload} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPayload(Map.Entry<String, ? extends Integer> entry) {
      this.payload.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SillyEntity#payload() payload} map. Nulls are not permitted
     * @param entries The entries that will be added to the payload map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder payload(Map<String, ? extends Integer> entries) {
      this.payload = ImmutableMap.builder();
      return putAllPayload(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SillyEntity#payload() payload} map. Nulls are not permitted
     * @param entries The entries that will be added to the payload map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllPayload(Map<String, ? extends Integer> entries) {
      this.payload.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link SillyEntity#ints() ints} list.
     * @param element A ints element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int element) {
      this.ints.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SillyEntity#ints() ints} list.
     * @param elements An array of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int... elements) {
      this.ints.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SillyEntity#ints() ints} list.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ints(Iterable<Integer> elements) {
      this.ints = ImmutableList.builder();
      return addAllInts(elements);
    }

    /**
     * Adds elements to {@link SillyEntity#ints() ints} list.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInts(Iterable<Integer> elements) {
      this.ints.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillyEntity ImmutableSillyEntity}.
     * @return An immutable instance of SillyEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillyEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSillyEntity(id, val, payload.build(), ints.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_VAL) != 0) attributes.add("val");
      return "Cannot build SillyEntity, some of required attributes are not set " + attributes;
    }
  }
}
